/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetTeamRequest {
    private String teamId;
    private String expand;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public GetTeamRequest withTeamId(String teamId) {
        this.setTeamId(teamId);
        return this;
    }

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public GetTeamRequest withExpand(String expand) {
        this.setExpand(expand);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetTeamRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.teamId == null) {
            throw new IllegalStateException("Missing the required parameter 'teamId' when building request for GetTeamRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/teams/{teamId}").withPathParameter("teamId", this.teamId).withQueryParameters("expand", "", this.expand).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String teamId) {
        return new Builder().withRequiredParams(teamId);
    }

    public static class Builder {
        private final GetTeamRequest request = new GetTeamRequest();

        private Builder() {
        }

        public Builder withTeamId(String teamId) {
            this.request.setTeamId(teamId);
            return this;
        }

        public Builder withExpand(String expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withExpand(expandValues expand) {
            this.request.setExpand(expand.toString());
            return this;
        }

        public Builder withRequiredParams(String teamId) {
            this.request.setTeamId(teamId);
            return this;
        }

        public GetTeamRequest build() {
            if (this.request.teamId == null) {
                throw new IllegalStateException("Missing the required parameter 'teamId' when building request for GetTeamRequest.");
            }
            return this.request;
        }
    }

    public static enum expandValues {
        ENTITIES_DIVISION("entities.division");

        private String value;

        private expandValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static expandValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (expandValues value : expandValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return expandValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

