/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WhatsAppConfig
implements Serializable {
    private List<String> whatsAppColumns = new ArrayList<String>();
    private AddressableEntityRef whatsAppIntegration = null;
    private DomainEntityRef contentTemplate = null;

    public WhatsAppConfig whatsAppColumns(List<String> whatsAppColumns) {
        this.whatsAppColumns = whatsAppColumns;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The contact list columns specifying the WhatsApp address(es) of the contact.")
    @JsonProperty(value="whatsAppColumns")
    public List<String> getWhatsAppColumns() {
        return this.whatsAppColumns;
    }

    public void setWhatsAppColumns(List<String> whatsAppColumns) {
        this.whatsAppColumns = whatsAppColumns;
    }

    public WhatsAppConfig whatsAppIntegration(AddressableEntityRef whatsAppIntegration) {
        this.whatsAppIntegration = whatsAppIntegration;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The WhatsApp integration used to send message to the contact.")
    @JsonProperty(value="whatsAppIntegration")
    public AddressableEntityRef getWhatsAppIntegration() {
        return this.whatsAppIntegration;
    }

    public void setWhatsAppIntegration(AddressableEntityRef whatsAppIntegration) {
        this.whatsAppIntegration = whatsAppIntegration;
    }

    public WhatsAppConfig contentTemplate(DomainEntityRef contentTemplate) {
        this.contentTemplate = contentTemplate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The content template used to formulate the WhatsApp message to send to the contact.")
    @JsonProperty(value="contentTemplate")
    public DomainEntityRef getContentTemplate() {
        return this.contentTemplate;
    }

    public void setContentTemplate(DomainEntityRef contentTemplate) {
        this.contentTemplate = contentTemplate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsAppConfig whatsAppConfig = (WhatsAppConfig)o;
        return Objects.equals(this.whatsAppColumns, whatsAppConfig.whatsAppColumns) && Objects.equals(this.whatsAppIntegration, whatsAppConfig.whatsAppIntegration) && Objects.equals(this.contentTemplate, whatsAppConfig.contentTemplate);
    }

    public int hashCode() {
        return Objects.hash(this.whatsAppColumns, this.whatsAppIntegration, this.contentTemplate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsAppConfig {\n");
        sb.append("    whatsAppColumns: ").append(this.toIndentedString(this.whatsAppColumns)).append("\n");
        sb.append("    whatsAppIntegration: ").append(this.toIndentedString(this.whatsAppIntegration)).append("\n");
        sb.append("    contentTemplate: ").append(this.toIndentedString(this.contentTemplate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

