/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class SpeechTextAnalyticsConversationSummary
implements Serializable {
    private SummaryTypeEnum summaryType = null;
    private MediaTypeEnum mediaType = null;
    private String language = null;
    private String agentId = null;
    private String summary = null;
    private Boolean generated = null;
    private Date dateCreated = null;

    public SpeechTextAnalyticsConversationSummary summaryType(SummaryTypeEnum summaryType) {
        this.summaryType = summaryType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of summary")
    @JsonProperty(value="summaryType")
    public SummaryTypeEnum getSummaryType() {
        return this.summaryType;
    }

    public void setSummaryType(SummaryTypeEnum summaryType) {
        this.summaryType = summaryType;
    }

    public SpeechTextAnalyticsConversationSummary mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="The media type of the associated interaction")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public SpeechTextAnalyticsConversationSummary language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", value="Language of the summary")
    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public SpeechTextAnalyticsConversationSummary agentId(String agentId) {
        this.agentId = agentId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the agent associated with the summary")
    @JsonProperty(value="agentId")
    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public SpeechTextAnalyticsConversationSummary summary(String summary) {
        this.summary = summary;
        return this;
    }

    @ApiModelProperty(example="null", value="A summarization of the conversation transcription")
    @JsonProperty(value="summary")
    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public SpeechTextAnalyticsConversationSummary generated(Boolean generated) {
        this.generated = generated;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether or not the summary was generated by AI")
    @JsonProperty(value="generated")
    public Boolean getGenerated() {
        return this.generated;
    }

    public void setGenerated(Boolean generated) {
        this.generated = generated;
    }

    public SpeechTextAnalyticsConversationSummary dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp of when the summary was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpeechTextAnalyticsConversationSummary speechTextAnalyticsConversationSummary = (SpeechTextAnalyticsConversationSummary)o;
        return Objects.equals((Object)this.summaryType, (Object)speechTextAnalyticsConversationSummary.summaryType) && Objects.equals((Object)this.mediaType, (Object)speechTextAnalyticsConversationSummary.mediaType) && Objects.equals(this.language, speechTextAnalyticsConversationSummary.language) && Objects.equals(this.agentId, speechTextAnalyticsConversationSummary.agentId) && Objects.equals(this.summary, speechTextAnalyticsConversationSummary.summary) && Objects.equals(this.generated, speechTextAnalyticsConversationSummary.generated) && Objects.equals(this.dateCreated, speechTextAnalyticsConversationSummary.dateCreated);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.summaryType, this.mediaType, this.language, this.agentId, this.summary, this.generated, this.dateCreated});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SpeechTextAnalyticsConversationSummary {\n");
        sb.append("    summaryType: ").append(this.toIndentedString((Object)this.summaryType)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    agentId: ").append(this.toIndentedString(this.agentId)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("    generated: ").append(this.toIndentedString(this.generated)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SummaryTypeEnumDeserializer.class)
    public static enum SummaryTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CONVERSATION("Conversation"),
        AGENT("Agent");

        private String value;

        private SummaryTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SummaryTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SummaryTypeEnum value : SummaryTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SummaryTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        MESSAGE("Message"),
        CALL("Call"),
        EMAIL("Email");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class SummaryTypeEnumDeserializer
    extends StdDeserializer<SummaryTypeEnum> {
        public SummaryTypeEnumDeserializer() {
            super(SummaryTypeEnumDeserializer.class);
        }

        public SummaryTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SummaryTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

