/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.Reaction;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class ResponseSet
implements Serializable {
    private String id = null;
    private String name = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private Integer version = null;
    private Map<String, Reaction> responses = null;
    private Boolean beepDetectionEnabled = null;
    private Boolean amdSpeechDistinguishEnabled = null;
    private LiveSpeakerDetectionModeEnum liveSpeakerDetectionMode = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ResponseSet name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the ResponseSet.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public ResponseSet version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="Required for updates, must match the version number of the most recent update")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public ResponseSet responses(Map<String, Reaction> responses) {
        this.responses = responses;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Map of disposition identifiers to reactions. For example: {\"disposition.classification.callable.person\": {\"reactionType\": \"transfer\"}}.")
    @JsonProperty(value="responses")
    public Map<String, Reaction> getResponses() {
        return this.responses;
    }

    public void setResponses(Map<String, Reaction> responses) {
        this.responses = responses;
    }

    public ResponseSet beepDetectionEnabled(Boolean beepDetectionEnabled) {
        this.beepDetectionEnabled = beepDetectionEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to enable answering machine beep detection")
    @JsonProperty(value="beepDetectionEnabled")
    public Boolean getBeepDetectionEnabled() {
        return this.beepDetectionEnabled;
    }

    public void setBeepDetectionEnabled(Boolean beepDetectionEnabled) {
        this.beepDetectionEnabled = beepDetectionEnabled;
    }

    public ResponseSet amdSpeechDistinguishEnabled(Boolean amdSpeechDistinguishEnabled) {
        this.amdSpeechDistinguishEnabled = amdSpeechDistinguishEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to enable answering machine detection")
    @JsonProperty(value="amdSpeechDistinguishEnabled")
    public Boolean getAmdSpeechDistinguishEnabled() {
        return this.amdSpeechDistinguishEnabled;
    }

    public void setAmdSpeechDistinguishEnabled(Boolean amdSpeechDistinguishEnabled) {
        this.amdSpeechDistinguishEnabled = amdSpeechDistinguishEnabled;
    }

    public ResponseSet liveSpeakerDetectionMode(LiveSpeakerDetectionModeEnum liveSpeakerDetectionMode) {
        this.liveSpeakerDetectionMode = liveSpeakerDetectionMode;
        return this;
    }

    @ApiModelProperty(example="null", value="Setting level of live speaker detection based on ringbacks")
    @JsonProperty(value="liveSpeakerDetectionMode")
    public LiveSpeakerDetectionModeEnum getLiveSpeakerDetectionMode() {
        return this.liveSpeakerDetectionMode;
    }

    public void setLiveSpeakerDetectionMode(LiveSpeakerDetectionModeEnum liveSpeakerDetectionMode) {
        this.liveSpeakerDetectionMode = liveSpeakerDetectionMode;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseSet responseSet = (ResponseSet)o;
        return Objects.equals(this.id, responseSet.id) && Objects.equals(this.name, responseSet.name) && Objects.equals(this.dateCreated, responseSet.dateCreated) && Objects.equals(this.dateModified, responseSet.dateModified) && Objects.equals(this.version, responseSet.version) && Objects.equals(this.responses, responseSet.responses) && Objects.equals(this.beepDetectionEnabled, responseSet.beepDetectionEnabled) && Objects.equals(this.amdSpeechDistinguishEnabled, responseSet.amdSpeechDistinguishEnabled) && Objects.equals((Object)this.liveSpeakerDetectionMode, (Object)responseSet.liveSpeakerDetectionMode) && Objects.equals(this.selfUri, responseSet.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.dateCreated, this.dateModified, this.version, this.responses, this.beepDetectionEnabled, this.amdSpeechDistinguishEnabled, this.liveSpeakerDetectionMode, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResponseSet {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    responses: ").append(this.toIndentedString(this.responses)).append("\n");
        sb.append("    beepDetectionEnabled: ").append(this.toIndentedString(this.beepDetectionEnabled)).append("\n");
        sb.append("    amdSpeechDistinguishEnabled: ").append(this.toIndentedString(this.amdSpeechDistinguishEnabled)).append("\n");
        sb.append("    liveSpeakerDetectionMode: ").append(this.toIndentedString((Object)this.liveSpeakerDetectionMode)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=LiveSpeakerDetectionModeEnumDeserializer.class)
    public static enum LiveSpeakerDetectionModeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DISABLED("Disabled"),
        LOW("Low"),
        MEDIUM("Medium"),
        HIGH("High");

        private String value;

        private LiveSpeakerDetectionModeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LiveSpeakerDetectionModeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (LiveSpeakerDetectionModeEnum value : LiveSpeakerDetectionModeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return LiveSpeakerDetectionModeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class LiveSpeakerDetectionModeEnumDeserializer
    extends StdDeserializer<LiveSpeakerDetectionModeEnum> {
        public LiveSpeakerDetectionModeEnumDeserializer() {
            super(LiveSpeakerDetectionModeEnumDeserializer.class);
        }

        public LiveSpeakerDetectionModeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return LiveSpeakerDetectionModeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

