/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.EscalationTarget;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ManualEscalationResponse
implements Serializable {
    private String socialMediaNormalizedMessageId = null;
    private String conversationNormalizedMessageId = null;
    private EscalationTarget escalationTarget = null;
    private EscalationStatusEnum escalationStatus = null;

    public ManualEscalationResponse socialMediaNormalizedMessageId(String socialMediaNormalizedMessageId) {
        this.socialMediaNormalizedMessageId = socialMediaNormalizedMessageId;
        return this;
    }

    @ApiModelProperty(example="null", value="The Id of the message that got escalated.")
    @JsonProperty(value="socialMediaNormalizedMessageId")
    public String getSocialMediaNormalizedMessageId() {
        return this.socialMediaNormalizedMessageId;
    }

    public void setSocialMediaNormalizedMessageId(String socialMediaNormalizedMessageId) {
        this.socialMediaNormalizedMessageId = socialMediaNormalizedMessageId;
    }

    public ManualEscalationResponse conversationNormalizedMessageId(String conversationNormalizedMessageId) {
        this.conversationNormalizedMessageId = conversationNormalizedMessageId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the message in the conversation.")
    @JsonProperty(value="conversationNormalizedMessageId")
    public String getConversationNormalizedMessageId() {
        return this.conversationNormalizedMessageId;
    }

    public void setConversationNormalizedMessageId(String conversationNormalizedMessageId) {
        this.conversationNormalizedMessageId = conversationNormalizedMessageId;
    }

    public ManualEscalationResponse escalationTarget(EscalationTarget escalationTarget) {
        this.escalationTarget = escalationTarget;
        return this;
    }

    @ApiModelProperty(example="null", value="The target integration configuration used for an social media message.")
    @JsonProperty(value="escalationTarget")
    public EscalationTarget getEscalationTarget() {
        return this.escalationTarget;
    }

    public void setEscalationTarget(EscalationTarget escalationTarget) {
        this.escalationTarget = escalationTarget;
    }

    public ManualEscalationResponse escalationStatus(EscalationStatusEnum escalationStatus) {
        this.escalationStatus = escalationStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="Escalation Status of the message.")
    @JsonProperty(value="escalationStatus")
    public EscalationStatusEnum getEscalationStatus() {
        return this.escalationStatus;
    }

    public void setEscalationStatus(EscalationStatusEnum escalationStatus) {
        this.escalationStatus = escalationStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManualEscalationResponse manualEscalationResponse = (ManualEscalationResponse)o;
        return Objects.equals(this.socialMediaNormalizedMessageId, manualEscalationResponse.socialMediaNormalizedMessageId) && Objects.equals(this.conversationNormalizedMessageId, manualEscalationResponse.conversationNormalizedMessageId) && Objects.equals(this.escalationTarget, manualEscalationResponse.escalationTarget) && Objects.equals((Object)this.escalationStatus, (Object)manualEscalationResponse.escalationStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.socialMediaNormalizedMessageId, this.conversationNormalizedMessageId, this.escalationTarget, this.escalationStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ManualEscalationResponse {\n");
        sb.append("    socialMediaNormalizedMessageId: ").append(this.toIndentedString(this.socialMediaNormalizedMessageId)).append("\n");
        sb.append("    conversationNormalizedMessageId: ").append(this.toIndentedString(this.conversationNormalizedMessageId)).append("\n");
        sb.append("    escalationTarget: ").append(this.toIndentedString(this.escalationTarget)).append("\n");
        sb.append("    escalationStatus: ").append(this.toIndentedString((Object)this.escalationStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=EscalationStatusEnumDeserializer.class)
    public static enum EscalationStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        MANUAL("Manual"),
        THROTTLED("Throttled"),
        PREVIOUSLYESCALATED("PreviouslyEscalated"),
        NOTESCALATED("NotEscalated"),
        AUTOMATIC("Automatic");

        private String value;

        private EscalationStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EscalationStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (EscalationStatusEnum value : EscalationStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return EscalationStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class EscalationStatusEnumDeserializer
    extends StdDeserializer<EscalationStatusEnum> {
        public EscalationStatusEnumDeserializer() {
            super(EscalationStatusEnumDeserializer.class);
        }

        public EscalationStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return EscalationStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

