/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class LogCaptureUserConfiguration
implements Serializable {
    private String id = null;
    private Date dateStarted = null;
    private Date dateExpired = null;
    private CaptureMethodEnum captureMethod = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="Indicates when log capture was enabled for the user. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateStarted")
    public Date getDateStarted() {
        return this.dateStarted;
    }

    public LogCaptureUserConfiguration dateExpired(Date dateExpired) {
        this.dateExpired = dateExpired;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicates when log capture will be turned off for the user. (Must be within 24 hours). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateExpired")
    public Date getDateExpired() {
        return this.dateExpired;
    }

    public void setDateExpired(Date dateExpired) {
        this.dateExpired = dateExpired;
    }

    @ApiModelProperty(example="null", value="Indicates the method by which the logs were captured.")
    @JsonProperty(value="captureMethod")
    public CaptureMethodEnum getCaptureMethod() {
        return this.captureMethod;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogCaptureUserConfiguration logCaptureUserConfiguration = (LogCaptureUserConfiguration)o;
        return Objects.equals(this.id, logCaptureUserConfiguration.id) && Objects.equals(this.dateStarted, logCaptureUserConfiguration.dateStarted) && Objects.equals(this.dateExpired, logCaptureUserConfiguration.dateExpired) && Objects.equals((Object)this.captureMethod, (Object)logCaptureUserConfiguration.captureMethod) && Objects.equals(this.selfUri, logCaptureUserConfiguration.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.dateStarted, this.dateExpired, this.captureMethod, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogCaptureUserConfiguration {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    dateStarted: ").append(this.toIndentedString(this.dateStarted)).append("\n");
        sb.append("    dateExpired: ").append(this.toIndentedString(this.dateExpired)).append("\n");
        sb.append("    captureMethod: ").append(this.toIndentedString((Object)this.captureMethod)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CaptureMethodEnumDeserializer.class)
    public static enum CaptureMethodEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ONDEMAND("OnDemand"),
        SCHEDULED("Scheduled");

        private String value;

        private CaptureMethodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CaptureMethodEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CaptureMethodEnum value : CaptureMethodEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CaptureMethodEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CaptureMethodEnumDeserializer
    extends StdDeserializer<CaptureMethodEnum> {
        public CaptureMethodEnumDeserializer() {
            super(CaptureMethodEnumDeserializer.class);
        }

        public CaptureMethodEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CaptureMethodEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

