/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.OverrideEscalationTarget;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class EscalationTarget
implements Serializable {
    private TargetTypeEnum targetType = null;
    private DestinationEnum destination = null;
    private OverrideEscalationTarget override = null;

    public EscalationTarget targetType(TargetTypeEnum targetType) {
        this.targetType = targetType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Defines the target that the message will be escalated to.")
    @JsonProperty(value="targetType")
    public TargetTypeEnum getTargetType() {
        return this.targetType;
    }

    public void setTargetType(TargetTypeEnum targetType) {
        this.targetType = targetType;
    }

    public EscalationTarget destination(DestinationEnum destination) {
        this.destination = destination;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Defines the destination of the escalation.SourceIntegration means use the SocialMedia Source Integration as the destination.OverrideIntegration means the set integration will be used regardless of the source.")
    @JsonProperty(value="destination")
    public DestinationEnum getDestination() {
        return this.destination;
    }

    public void setDestination(DestinationEnum destination) {
        this.destination = destination;
    }

    public EscalationTarget override(OverrideEscalationTarget override) {
        this.override = override;
        return this;
    }

    @ApiModelProperty(example="null", value="Set the integration ID.Only valid when type is OverrideIntegration.")
    @JsonProperty(value="override")
    public OverrideEscalationTarget getOverride() {
        return this.override;
    }

    public void setOverride(OverrideEscalationTarget override) {
        this.override = override;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EscalationTarget escalationTarget = (EscalationTarget)o;
        return Objects.equals((Object)this.targetType, (Object)escalationTarget.targetType) && Objects.equals((Object)this.destination, (Object)escalationTarget.destination) && Objects.equals(this.override, escalationTarget.override);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.targetType, this.destination, this.override});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EscalationTarget {\n");
        sb.append("    targetType: ").append(this.toIndentedString((Object)this.targetType)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString((Object)this.destination)).append("\n");
        sb.append("    override: ").append(this.toIndentedString(this.override)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TargetTypeEnumDeserializer.class)
    public static enum TargetTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CONVERSATION("Conversation");

        private String value;

        private TargetTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TargetTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TargetTypeEnum value : TargetTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TargetTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DestinationEnumDeserializer.class)
    public static enum DestinationEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SOURCEINTEGRATION("SourceIntegration"),
        OVERRIDEINTEGRATION("OverrideIntegration");

        private String value;

        private DestinationEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DestinationEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DestinationEnum value : DestinationEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DestinationEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DestinationEnumDeserializer
    extends StdDeserializer<DestinationEnum> {
        public DestinationEnumDeserializer() {
            super(DestinationEnumDeserializer.class);
        }

        public DestinationEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DestinationEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TargetTypeEnumDeserializer
    extends StdDeserializer<TargetTypeEnum> {
        public TargetTypeEnumDeserializer() {
            super(TargetTypeEnumDeserializer.class);
        }

        public TargetTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TargetTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

