/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.EscalationTarget;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class EscalationRuleResponse
implements Serializable {
    private String id = null;
    private String name = null;
    private String matchCriteria = null;
    private Integer priority = null;
    private String divisionId = null;
    private String description = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private StatusEnum status = null;
    private EscalationTarget openEscalation = null;
    private EscalationTarget facebookEscalation = null;
    private EscalationTarget instagramEscalation = null;
    private EscalationTarget twitterEscalation = null;
    private String selfUri = null;

    public EscalationRuleResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the escalation rule.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EscalationRuleResponse name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the escalation rule.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EscalationRuleResponse matchCriteria(String matchCriteria) {
        this.matchCriteria = matchCriteria;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The criteria that defines when a social media message should be escalated.")
    @JsonProperty(value="matchCriteria")
    public String getMatchCriteria() {
        return this.matchCriteria;
    }

    public void setMatchCriteria(String matchCriteria) {
        this.matchCriteria = matchCriteria;
    }

    public EscalationRuleResponse priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(example="null", value="The priority of the escalation rule.")
    @JsonProperty(value="priority")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public EscalationRuleResponse divisionId(String divisionId) {
        this.divisionId = divisionId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the division the social escalation rule belongs to.")
    @JsonProperty(value="divisionId")
    public String getDivisionId() {
        return this.divisionId;
    }

    public void setDivisionId(String divisionId) {
        this.divisionId = divisionId;
    }

    public EscalationRuleResponse description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="A description of the social escalation rule.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public EscalationRuleResponse dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp indicating when the escalation rule was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public EscalationRuleResponse dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp indicating when the escalation rule was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public EscalationRuleResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the escalation rule.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public EscalationRuleResponse openEscalation(EscalationTarget openEscalation) {
        this.openEscalation = openEscalation;
        return this;
    }

    @ApiModelProperty(example="null", value="The target integration configuration used for an open social media message if the match criteria returns true.")
    @JsonProperty(value="openEscalation")
    public EscalationTarget getOpenEscalation() {
        return this.openEscalation;
    }

    public void setOpenEscalation(EscalationTarget openEscalation) {
        this.openEscalation = openEscalation;
    }

    public EscalationRuleResponse facebookEscalation(EscalationTarget facebookEscalation) {
        this.facebookEscalation = facebookEscalation;
        return this;
    }

    @ApiModelProperty(example="null", value="The target integration configuration used for a Facebook social media message if the match criteria returns true.")
    @JsonProperty(value="facebookEscalation")
    public EscalationTarget getFacebookEscalation() {
        return this.facebookEscalation;
    }

    public void setFacebookEscalation(EscalationTarget facebookEscalation) {
        this.facebookEscalation = facebookEscalation;
    }

    public EscalationRuleResponse instagramEscalation(EscalationTarget instagramEscalation) {
        this.instagramEscalation = instagramEscalation;
        return this;
    }

    @ApiModelProperty(example="null", value="The target integration configuration used for an Instagram social media message if the match criteria returns true.")
    @JsonProperty(value="instagramEscalation")
    public EscalationTarget getInstagramEscalation() {
        return this.instagramEscalation;
    }

    public void setInstagramEscalation(EscalationTarget instagramEscalation) {
        this.instagramEscalation = instagramEscalation;
    }

    public EscalationRuleResponse twitterEscalation(EscalationTarget twitterEscalation) {
        this.twitterEscalation = twitterEscalation;
        return this;
    }

    @ApiModelProperty(example="null", value="The target integration configuration used for a X (formerly Twitter) social media message if the match criteria returns true.")
    @JsonProperty(value="twitterEscalation")
    public EscalationTarget getTwitterEscalation() {
        return this.twitterEscalation;
    }

    public void setTwitterEscalation(EscalationTarget twitterEscalation) {
        this.twitterEscalation = twitterEscalation;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EscalationRuleResponse escalationRuleResponse = (EscalationRuleResponse)o;
        return Objects.equals(this.id, escalationRuleResponse.id) && Objects.equals(this.name, escalationRuleResponse.name) && Objects.equals(this.matchCriteria, escalationRuleResponse.matchCriteria) && Objects.equals(this.priority, escalationRuleResponse.priority) && Objects.equals(this.divisionId, escalationRuleResponse.divisionId) && Objects.equals(this.description, escalationRuleResponse.description) && Objects.equals(this.dateCreated, escalationRuleResponse.dateCreated) && Objects.equals(this.dateModified, escalationRuleResponse.dateModified) && Objects.equals((Object)this.status, (Object)escalationRuleResponse.status) && Objects.equals(this.openEscalation, escalationRuleResponse.openEscalation) && Objects.equals(this.facebookEscalation, escalationRuleResponse.facebookEscalation) && Objects.equals(this.instagramEscalation, escalationRuleResponse.instagramEscalation) && Objects.equals(this.twitterEscalation, escalationRuleResponse.twitterEscalation) && Objects.equals(this.selfUri, escalationRuleResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.matchCriteria, this.priority, this.divisionId, this.description, this.dateCreated, this.dateModified, this.status, this.openEscalation, this.facebookEscalation, this.instagramEscalation, this.twitterEscalation, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EscalationRuleResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    matchCriteria: ").append(this.toIndentedString(this.matchCriteria)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    divisionId: ").append(this.toIndentedString(this.divisionId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    openEscalation: ").append(this.toIndentedString(this.openEscalation)).append("\n");
        sb.append("    facebookEscalation: ").append(this.toIndentedString(this.facebookEscalation)).append("\n");
        sb.append("    instagramEscalation: ").append(this.toIndentedString(this.instagramEscalation)).append("\n");
        sb.append("    twitterEscalation: ").append(this.toIndentedString(this.twitterEscalation)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("Active"),
        PAUSED("Paused");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

