/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ContestDataMetrics;
import com.mypurecloud.sdk.v2.model.ContestDataPrizes;
import com.mypurecloud.sdk.v2.model.ContestDataWinners;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ContestCompleteData
implements Serializable {
    private LocalDate dateEnd = null;
    private AnonymizationEnum anonymization = null;
    private List<ContestDataMetrics> metrics = new ArrayList<ContestDataMetrics>();
    private List<ContestDataPrizes> prizes = new ArrayList<ContestDataPrizes>();
    private List<ContestDataWinners> winners = new ArrayList<ContestDataWinners>();

    public ContestCompleteData dateEnd(LocalDate dateEnd) {
        this.dateEnd = dateEnd;
        return this;
    }

    @ApiModelProperty(example="null", value="End date of the contest. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateEnd")
    public LocalDate getDateEnd() {
        return this.dateEnd;
    }

    public void setDateEnd(LocalDate dateEnd) {
        this.dateEnd = dateEnd;
    }

    public ContestCompleteData anonymization(AnonymizationEnum anonymization) {
        this.anonymization = anonymization;
        return this;
    }

    @ApiModelProperty(example="null", value="Anonymization of the contest")
    @JsonProperty(value="anonymization")
    public AnonymizationEnum getAnonymization() {
        return this.anonymization;
    }

    public void setAnonymization(AnonymizationEnum anonymization) {
        this.anonymization = anonymization;
    }

    public ContestCompleteData metrics(List<ContestDataMetrics> metrics) {
        this.metrics = metrics;
        return this;
    }

    @ApiModelProperty(example="null", value="Metrics of the contest")
    @JsonProperty(value="metrics")
    public List<ContestDataMetrics> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<ContestDataMetrics> metrics) {
        this.metrics = metrics;
    }

    public ContestCompleteData prizes(List<ContestDataPrizes> prizes) {
        this.prizes = prizes;
        return this;
    }

    @ApiModelProperty(example="null", value="Prizes of the contest")
    @JsonProperty(value="prizes")
    public List<ContestDataPrizes> getPrizes() {
        return this.prizes;
    }

    public void setPrizes(List<ContestDataPrizes> prizes) {
        this.prizes = prizes;
    }

    public ContestCompleteData winners(List<ContestDataWinners> winners) {
        this.winners = winners;
        return this;
    }

    @ApiModelProperty(example="null", value="Winners of the contest")
    @JsonProperty(value="winners")
    public List<ContestDataWinners> getWinners() {
        return this.winners;
    }

    public void setWinners(List<ContestDataWinners> winners) {
        this.winners = winners;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContestCompleteData contestCompleteData = (ContestCompleteData)o;
        return Objects.equals(this.dateEnd, contestCompleteData.dateEnd) && Objects.equals((Object)this.anonymization, (Object)contestCompleteData.anonymization) && Objects.equals(this.metrics, contestCompleteData.metrics) && Objects.equals(this.prizes, contestCompleteData.prizes) && Objects.equals(this.winners, contestCompleteData.winners);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateEnd, this.anonymization, this.metrics, this.prizes, this.winners});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContestCompleteData {\n");
        sb.append("    dateEnd: ").append(this.toIndentedString(this.dateEnd)).append("\n");
        sb.append("    anonymization: ").append(this.toIndentedString((Object)this.anonymization)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    prizes: ").append(this.toIndentedString(this.prizes)).append("\n");
        sb.append("    winners: ").append(this.toIndentedString(this.winners)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AnonymizationEnumDeserializer.class)
    public static enum AnonymizationEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NOANONYMIZATION("NoAnonymization"),
        ALL("All"),
        ALLEXCEPTTOP("AllExceptTop");

        private String value;

        private AnonymizationEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AnonymizationEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AnonymizationEnum value : AnonymizationEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AnonymizationEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AnonymizationEnumDeserializer
    extends StdDeserializer<AnonymizationEnum> {
        public AnonymizationEnumDeserializer() {
            super(AnonymizationEnumDeserializer.class);
        }

        public AnonymizationEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AnonymizationEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

