/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.SourceEntity;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class Celebration
implements Serializable {
    private String id = null;
    private UserReference recipient = null;
    private UserReference createdBy = null;
    private Date dateCreated = null;
    private TypeEnum type = null;
    private String title = null;
    private String note = null;
    private SourceEntity sourceEntity = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Celebration recipient(UserReference recipient) {
        this.recipient = recipient;
        return this;
    }

    @ApiModelProperty(example="null", value="The Recipient of the celebration")
    @JsonProperty(value="recipient")
    public UserReference getRecipient() {
        return this.recipient;
    }

    public void setRecipient(UserReference recipient) {
        this.recipient = recipient;
    }

    public Celebration createdBy(UserReference createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The creator of the celebration")
    @JsonProperty(value="createdBy")
    public UserReference getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(UserReference createdBy) {
        this.createdBy = createdBy;
    }

    public Celebration dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="2023-01-01T01:01:01Z", value="The date the celebration was created on. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Celebration type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="The Celebration Type")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Celebration title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", value="The Celebration title")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Celebration note(String note) {
        this.note = note;
        return this;
    }

    @ApiModelProperty(example="null", value="The Celebration note")
    @JsonProperty(value="note")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Celebration sourceEntity(SourceEntity sourceEntity) {
        this.sourceEntity = sourceEntity;
        return this;
    }

    @ApiModelProperty(example="null", value="The celebration's source entity")
    @JsonProperty(value="sourceEntity")
    public SourceEntity getSourceEntity() {
        return this.sourceEntity;
    }

    public void setSourceEntity(SourceEntity sourceEntity) {
        this.sourceEntity = sourceEntity;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Celebration celebration = (Celebration)o;
        return Objects.equals(this.id, celebration.id) && Objects.equals(this.recipient, celebration.recipient) && Objects.equals(this.createdBy, celebration.createdBy) && Objects.equals(this.dateCreated, celebration.dateCreated) && Objects.equals((Object)this.type, (Object)celebration.type) && Objects.equals(this.title, celebration.title) && Objects.equals(this.note, celebration.note) && Objects.equals(this.sourceEntity, celebration.sourceEntity) && Objects.equals(this.selfUri, celebration.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.recipient, this.createdBy, this.dateCreated, this.type, this.title, this.note, this.sourceEntity, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Celebration {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    sourceEntity: ").append(this.toIndentedString(this.sourceEntity)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        RECOGNITION("Recognition"),
        CONTESTCOMPLETE("ContestComplete");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

