/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Settings for authenticated webdeployments.")
public class AuthenticationSettings
implements Serializable {
    private Boolean enabled = null;
    private String integrationId = null;
    private Boolean allowSessionUpgrade = null;

    public AuthenticationSettings enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicate if these auth is required for this deployment. If, for example, this flag is set to true then webmessaging sessions can not send messages unless the end-user is authenticated.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public AuthenticationSettings integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The integration identifier which contains the auth settings required on the deployment.")
    @JsonProperty(value="integrationId")
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public AuthenticationSettings allowSessionUpgrade(Boolean allowSessionUpgrade) {
        this.allowSessionUpgrade = allowSessionUpgrade;
        return this;
    }

    @ApiModelProperty(example="null", value="Allow end-users to upgrade an anonymous session to authenticated conversation.")
    @JsonProperty(value="allowSessionUpgrade")
    public Boolean getAllowSessionUpgrade() {
        return this.allowSessionUpgrade;
    }

    public void setAllowSessionUpgrade(Boolean allowSessionUpgrade) {
        this.allowSessionUpgrade = allowSessionUpgrade;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationSettings authenticationSettings = (AuthenticationSettings)o;
        return Objects.equals(this.enabled, authenticationSettings.enabled) && Objects.equals(this.integrationId, authenticationSettings.integrationId) && Objects.equals(this.allowSessionUpgrade, authenticationSettings.allowSessionUpgrade);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.integrationId, this.allowSessionUpgrade);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticationSettings {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    allowSessionUpgrade: ").append(this.toIndentedString(this.allowSessionUpgrade)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

