/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.Address;
import com.mypurecloud.sdk.v2.model.InternalMessageDetails;
import com.mypurecloud.sdk.v2.model.Segment;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class InternalMessage
implements Serializable {
    private StateEnum state = null;
    private InitialStateEnum initialState = null;
    private String id = null;
    private List<Segment> segments = new ArrayList<Segment>();
    private DisconnectTypeEnum disconnectType = null;
    private Date connectedTime = null;
    private Date disconnectedTime = null;
    private String provider = null;
    private String peerId = null;
    private String targetUserId = null;
    private String sourceUserId = null;
    private Address toAddress = null;
    private Address fromAddress = null;
    private List<InternalMessageDetails> messages = new ArrayList<InternalMessageDetails>();

    public InternalMessage state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The connection state of this communication.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public InternalMessage initialState(InitialStateEnum initialState) {
        this.initialState = initialState;
        return this;
    }

    @ApiModelProperty(example="null", value="The initial connection state of this communication.")
    @JsonProperty(value="initialState")
    public InitialStateEnum getInitialState() {
        return this.initialState;
    }

    public void setInitialState(InitialStateEnum initialState) {
        this.initialState = initialState;
    }

    public InternalMessage id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for this communication.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public InternalMessage segments(List<Segment> segments) {
        this.segments = segments;
        return this;
    }

    @ApiModelProperty(example="null", value="The time line of the participant's internal message, divided into activity segments.")
    @JsonProperty(value="segments")
    public List<Segment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<Segment> segments) {
        this.segments = segments;
    }

    public InternalMessage disconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
        return this;
    }

    @ApiModelProperty(example="null", value="System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.")
    @JsonProperty(value="disconnectType")
    public DisconnectTypeEnum getDisconnectType() {
        return this.disconnectType;
    }

    public void setDisconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
    }

    public InternalMessage connectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication was connected in the cloud clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="connectedTime")
    public Date getConnectedTime() {
        return this.connectedTime;
    }

    public void setConnectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
    }

    public InternalMessage disconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="disconnectedTime")
    public Date getDisconnectedTime() {
        return this.disconnectedTime;
    }

    public void setDisconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
    }

    public InternalMessage provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", value="The source provider for the message.")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public InternalMessage peerId(String peerId) {
        this.peerId = peerId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the peer communication corresponding to a matching leg for this communication.")
    @JsonProperty(value="peerId")
    public String getPeerId() {
        return this.peerId;
    }

    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    public InternalMessage targetUserId(String targetUserId) {
        this.targetUserId = targetUserId;
        return this;
    }

    @ApiModelProperty(example="null", value="The user ID for the participant on receiving side of the internal message conversation.")
    @JsonProperty(value="targetUserId")
    public String getTargetUserId() {
        return this.targetUserId;
    }

    public void setTargetUserId(String targetUserId) {
        this.targetUserId = targetUserId;
    }

    public InternalMessage sourceUserId(String sourceUserId) {
        this.sourceUserId = sourceUserId;
        return this;
    }

    @ApiModelProperty(example="null", value="The user ID for the participant on sending side of the internal message conversation.")
    @JsonProperty(value="sourceUserId")
    public String getSourceUserId() {
        return this.sourceUserId;
    }

    public void setSourceUserId(String sourceUserId) {
        this.sourceUserId = sourceUserId;
    }

    public InternalMessage toAddress(Address toAddress) {
        this.toAddress = toAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="Address for the participant on receiving side of the internal message communication.")
    @JsonProperty(value="toAddress")
    public Address getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(Address toAddress) {
        this.toAddress = toAddress;
    }

    public InternalMessage fromAddress(Address fromAddress) {
        this.fromAddress = fromAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="Address for the participant on the sending side of the internal message communication.")
    @JsonProperty(value="fromAddress")
    public Address getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(Address fromAddress) {
        this.fromAddress = fromAddress;
    }

    public InternalMessage messages(List<InternalMessageDetails> messages) {
        this.messages = messages;
        return this;
    }

    @ApiModelProperty(example="null", value="The messages sent on this communication channel.")
    @JsonProperty(value="messages")
    public List<InternalMessageDetails> getMessages() {
        return this.messages;
    }

    public void setMessages(List<InternalMessageDetails> messages) {
        this.messages = messages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalMessage internalMessage = (InternalMessage)o;
        return Objects.equals((Object)this.state, (Object)internalMessage.state) && Objects.equals((Object)this.initialState, (Object)internalMessage.initialState) && Objects.equals(this.id, internalMessage.id) && Objects.equals(this.segments, internalMessage.segments) && Objects.equals((Object)this.disconnectType, (Object)internalMessage.disconnectType) && Objects.equals(this.connectedTime, internalMessage.connectedTime) && Objects.equals(this.disconnectedTime, internalMessage.disconnectedTime) && Objects.equals(this.provider, internalMessage.provider) && Objects.equals(this.peerId, internalMessage.peerId) && Objects.equals(this.targetUserId, internalMessage.targetUserId) && Objects.equals(this.sourceUserId, internalMessage.sourceUserId) && Objects.equals(this.toAddress, internalMessage.toAddress) && Objects.equals(this.fromAddress, internalMessage.fromAddress) && Objects.equals(this.messages, internalMessage.messages);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.initialState, this.id, this.segments, this.disconnectType, this.connectedTime, this.disconnectedTime, this.provider, this.peerId, this.targetUserId, this.sourceUserId, this.toAddress, this.fromAddress, this.messages});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InternalMessage {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    initialState: ").append(this.toIndentedString((Object)this.initialState)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    segments: ").append(this.toIndentedString(this.segments)).append("\n");
        sb.append("    disconnectType: ").append(this.toIndentedString((Object)this.disconnectType)).append("\n");
        sb.append("    connectedTime: ").append(this.toIndentedString(this.connectedTime)).append("\n");
        sb.append("    disconnectedTime: ").append(this.toIndentedString(this.disconnectedTime)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    peerId: ").append(this.toIndentedString(this.peerId)).append("\n");
        sb.append("    targetUserId: ").append(this.toIndentedString(this.targetUserId)).append("\n");
        sb.append("    sourceUserId: ").append(this.toIndentedString(this.sourceUserId)).append("\n");
        sb.append("    toAddress: ").append(this.toIndentedString(this.toAddress)).append("\n");
        sb.append("    fromAddress: ").append(this.toIndentedString(this.fromAddress)).append("\n");
        sb.append("    messages: ").append(this.toIndentedString(this.messages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=InitialStateEnumDeserializer.class)
    public static enum InitialStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected");

        private String value;

        private InitialStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static InitialStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (InitialStateEnum value : InitialStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return InitialStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DisconnectTypeEnumDeserializer.class)
    public static enum DisconnectTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CLIENT("client"),
        SYSTEM("system"),
        PEER("peer"),
        TRANSFER("transfer");

        private String value;

        private DisconnectTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DisconnectTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DisconnectTypeEnum value : DisconnectTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DisconnectTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DisconnectTypeEnumDeserializer
    extends StdDeserializer<DisconnectTypeEnum> {
        public DisconnectTypeEnumDeserializer() {
            super(DisconnectTypeEnumDeserializer.class);
        }

        public DisconnectTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DisconnectTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class InitialStateEnumDeserializer
    extends StdDeserializer<InitialStateEnum> {
        public InitialStateEnumDeserializer() {
            super(InitialStateEnumDeserializer.class);
        }

        public InitialStateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return InitialStateEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

