/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AiScoring;
import com.mypurecloud.sdk.v2.model.Calibration;
import com.mypurecloud.sdk.v2.model.ConversationReference;
import com.mypurecloud.sdk.v2.model.EvaluationForm;
import com.mypurecloud.sdk.v2.model.EvaluationScoringSet;
import com.mypurecloud.sdk.v2.model.EvaluationSource;
import com.mypurecloud.sdk.v2.model.Queue;
import com.mypurecloud.sdk.v2.model.Team;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class Evaluation
implements Serializable {
    private String id = null;
    private String name = null;
    private ConversationReference conversation = null;
    private EvaluationForm evaluationForm = null;
    private User evaluator = null;
    private User agent = null;
    private Calibration calibration = null;
    private StatusEnum status = null;
    private EvaluationScoringSet answers = null;
    private Boolean agentHasRead = null;
    private User assignee = null;
    private Boolean assigneeApplicable = null;
    private Date releaseDate = null;
    private Date assignedDate = null;
    private Date changedDate = null;
    private Date revisionCreatedDate = null;
    private Queue queue = null;
    private List<MediaTypeEnum> mediaType = new ArrayList<MediaTypeEnum>();
    private Boolean rescore = null;
    private Date conversationDate = null;
    private Date conversationEndDate = null;
    private Boolean neverRelease = null;
    private Boolean assigned = null;
    private Date dateAssigneeChanged = null;
    private String resourceId = null;
    private ResourceTypeEnum resourceType = null;
    private Boolean redacted = null;
    private Team agentTeam = null;
    private Boolean isScoringIndex = null;
    private List<String> authorizedActions = new ArrayList<String>();
    private Boolean hasAssistanceFailed = null;
    private EvaluationSource evaluationSource = null;
    private AiScoring aiScoring = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Evaluation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Evaluation conversation(ConversationReference conversation) {
        this.conversation = conversation;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="conversation")
    public ConversationReference getConversation() {
        return this.conversation;
    }

    public void setConversation(ConversationReference conversation) {
        this.conversation = conversation;
    }

    public Evaluation evaluationForm(EvaluationForm evaluationForm) {
        this.evaluationForm = evaluationForm;
        return this;
    }

    @ApiModelProperty(example="null", value="Evaluation form used for evaluation.")
    @JsonProperty(value="evaluationForm")
    public EvaluationForm getEvaluationForm() {
        return this.evaluationForm;
    }

    public void setEvaluationForm(EvaluationForm evaluationForm) {
        this.evaluationForm = evaluationForm;
    }

    public Evaluation evaluator(User evaluator) {
        this.evaluator = evaluator;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="evaluator")
    public User getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(User evaluator) {
        this.evaluator = evaluator;
    }

    public Evaluation agent(User agent) {
        this.agent = agent;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="agent")
    public User getAgent() {
        return this.agent;
    }

    public void setAgent(User agent) {
        this.agent = agent;
    }

    public Evaluation calibration(Calibration calibration) {
        this.calibration = calibration;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="calibration")
    public Calibration getCalibration() {
        return this.calibration;
    }

    public void setCalibration(Calibration calibration) {
        this.calibration = calibration;
    }

    public Evaluation status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Evaluation answers(EvaluationScoringSet answers) {
        this.answers = answers;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="answers")
    public EvaluationScoringSet getAnswers() {
        return this.answers;
    }

    public void setAnswers(EvaluationScoringSet answers) {
        this.answers = answers;
    }

    public Evaluation agentHasRead(Boolean agentHasRead) {
        this.agentHasRead = agentHasRead;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="agentHasRead")
    public Boolean getAgentHasRead() {
        return this.agentHasRead;
    }

    public void setAgentHasRead(Boolean agentHasRead) {
        this.agentHasRead = agentHasRead;
    }

    public Evaluation assignee(User assignee) {
        this.assignee = assignee;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="assignee")
    public User getAssignee() {
        return this.assignee;
    }

    public void setAssignee(User assignee) {
        this.assignee = assignee;
    }

    public Evaluation assigneeApplicable(Boolean assigneeApplicable) {
        this.assigneeApplicable = assigneeApplicable;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether an assignee is applicable for the evaluation. Set to false when assignee is not applicable.")
    @JsonProperty(value="assigneeApplicable")
    public Boolean getAssigneeApplicable() {
        return this.assigneeApplicable;
    }

    public void setAssigneeApplicable(Boolean assigneeApplicable) {
        this.assigneeApplicable = assigneeApplicable;
    }

    public Evaluation releaseDate(Date releaseDate) {
        this.releaseDate = releaseDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="releaseDate")
    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(Date releaseDate) {
        this.releaseDate = releaseDate;
    }

    public Evaluation assignedDate(Date assignedDate) {
        this.assignedDate = assignedDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="assignedDate")
    public Date getAssignedDate() {
        return this.assignedDate;
    }

    public void setAssignedDate(Date assignedDate) {
        this.assignedDate = assignedDate;
    }

    public Evaluation changedDate(Date changedDate) {
        this.changedDate = changedDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="changedDate")
    public Date getChangedDate() {
        return this.changedDate;
    }

    public void setChangedDate(Date changedDate) {
        this.changedDate = changedDate;
    }

    public Evaluation revisionCreatedDate(Date revisionCreatedDate) {
        this.revisionCreatedDate = revisionCreatedDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="revisionCreatedDate")
    public Date getRevisionCreatedDate() {
        return this.revisionCreatedDate;
    }

    public void setRevisionCreatedDate(Date revisionCreatedDate) {
        this.revisionCreatedDate = revisionCreatedDate;
    }

    public Evaluation queue(Queue queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="queue")
    public Queue getQueue() {
        return this.queue;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public Evaluation mediaType(List<MediaTypeEnum> mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="List of different communication types used in conversation.")
    @JsonProperty(value="mediaType")
    public List<MediaTypeEnum> getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(List<MediaTypeEnum> mediaType) {
        this.mediaType = mediaType;
    }

    public Evaluation rescore(Boolean rescore) {
        this.rescore = rescore;
        return this;
    }

    @ApiModelProperty(example="null", value="Is only true when evaluation is re-scored.")
    @JsonProperty(value="rescore")
    public Boolean getRescore() {
        return this.rescore;
    }

    public void setRescore(Boolean rescore) {
        this.rescore = rescore;
    }

    public Evaluation conversationDate(Date conversationDate) {
        this.conversationDate = conversationDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date of conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="conversationDate")
    public Date getConversationDate() {
        return this.conversationDate;
    }

    public void setConversationDate(Date conversationDate) {
        this.conversationDate = conversationDate;
    }

    public Evaluation conversationEndDate(Date conversationEndDate) {
        this.conversationEndDate = conversationEndDate;
        return this;
    }

    @ApiModelProperty(example="null", value="End date of conversation if it had completed before evaluation creation. Null if created before the conversation ended. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="conversationEndDate")
    public Date getConversationEndDate() {
        return this.conversationEndDate;
    }

    public void setConversationEndDate(Date conversationEndDate) {
        this.conversationEndDate = conversationEndDate;
    }

    public Evaluation neverRelease(Boolean neverRelease) {
        this.neverRelease = neverRelease;
        return this;
    }

    @ApiModelProperty(example="null", value="Signifies if the evaluation is never to be released. This cannot be set true if release date is also set.")
    @JsonProperty(value="neverRelease")
    public Boolean getNeverRelease() {
        return this.neverRelease;
    }

    public void setNeverRelease(Boolean neverRelease) {
        this.neverRelease = neverRelease;
    }

    public Evaluation assigned(Boolean assigned) {
        this.assigned = assigned;
        return this;
    }

    @ApiModelProperty(example="null", value="Set to false to unassign the evaluation. This cannot be set to false when assignee is also set.")
    @JsonProperty(value="assigned")
    public Boolean getAssigned() {
        return this.assigned;
    }

    public void setAssigned(Boolean assigned) {
        this.assigned = assigned;
    }

    public Evaluation dateAssigneeChanged(Date dateAssigneeChanged) {
        this.dateAssigneeChanged = dateAssigneeChanged;
        return this;
    }

    @ApiModelProperty(example="null", value="Date when the assignee was last changed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateAssigneeChanged")
    public Date getDateAssigneeChanged() {
        return this.dateAssigneeChanged;
    }

    public void setDateAssigneeChanged(Date dateAssigneeChanged) {
        this.dateAssigneeChanged = dateAssigneeChanged;
    }

    public Evaluation resourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @ApiModelProperty(example="null", value="Only used for email evaluations. Will be null for all other evaluations.")
    @JsonProperty(value="resourceId")
    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public Evaluation resourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of resource. Only used for email evaluations. Will be null for evaluations on all other resources.")
    @JsonProperty(value="resourceType")
    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public Evaluation redacted(Boolean redacted) {
        this.redacted = redacted;
        return this;
    }

    @ApiModelProperty(example="null", value="Is only true when the user making the request does not have sufficient permissions to see evaluation")
    @JsonProperty(value="redacted")
    public Boolean getRedacted() {
        return this.redacted;
    }

    public void setRedacted(Boolean redacted) {
        this.redacted = redacted;
    }

    public Evaluation agentTeam(Team agentTeam) {
        this.agentTeam = agentTeam;
        return this;
    }

    @ApiModelProperty(example="null", value="Team of the evaluation agent")
    @JsonProperty(value="agentTeam")
    public Team getAgentTeam() {
        return this.agentTeam;
    }

    public void setAgentTeam(Team agentTeam) {
        this.agentTeam = agentTeam;
    }

    public Evaluation isScoringIndex(Boolean isScoringIndex) {
        this.isScoringIndex = isScoringIndex;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="isScoringIndex")
    public Boolean getIsScoringIndex() {
        return this.isScoringIndex;
    }

    public void setIsScoringIndex(Boolean isScoringIndex) {
        this.isScoringIndex = isScoringIndex;
    }

    public Evaluation authorizedActions(List<String> authorizedActions) {
        this.authorizedActions = authorizedActions;
        return this;
    }

    @ApiModelProperty(example="null", value="List of user authorized actions on evaluation. Possible values: assign, edit, editScore, editAgentSignoff, delete, release, viewAudit")
    @JsonProperty(value="authorizedActions")
    public List<String> getAuthorizedActions() {
        return this.authorizedActions;
    }

    public void setAuthorizedActions(List<String> authorizedActions) {
        this.authorizedActions = authorizedActions;
    }

    public Evaluation hasAssistanceFailed(Boolean hasAssistanceFailed) {
        this.hasAssistanceFailed = hasAssistanceFailed;
        return this;
    }

    @ApiModelProperty(example="null", value="Is true when evaluation assistance didn't execute successfully")
    @JsonProperty(value="hasAssistanceFailed")
    public Boolean getHasAssistanceFailed() {
        return this.hasAssistanceFailed;
    }

    public void setHasAssistanceFailed(Boolean hasAssistanceFailed) {
        this.hasAssistanceFailed = hasAssistanceFailed;
    }

    @ApiModelProperty(example="null", value="The source that created the evaluation.")
    @JsonProperty(value="evaluationSource")
    public EvaluationSource getEvaluationSource() {
        return this.evaluationSource;
    }

    @ApiModelProperty(example="null", value="AI scoring details for the evaluation.")
    @JsonProperty(value="aiScoring")
    public AiScoring getAiScoring() {
        return this.aiScoring;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Evaluation evaluation = (Evaluation)o;
        return Objects.equals(this.id, evaluation.id) && Objects.equals(this.name, evaluation.name) && Objects.equals(this.conversation, evaluation.conversation) && Objects.equals(this.evaluationForm, evaluation.evaluationForm) && Objects.equals(this.evaluator, evaluation.evaluator) && Objects.equals(this.agent, evaluation.agent) && Objects.equals(this.calibration, evaluation.calibration) && Objects.equals((Object)this.status, (Object)evaluation.status) && Objects.equals(this.answers, evaluation.answers) && Objects.equals(this.agentHasRead, evaluation.agentHasRead) && Objects.equals(this.assignee, evaluation.assignee) && Objects.equals(this.assigneeApplicable, evaluation.assigneeApplicable) && Objects.equals(this.releaseDate, evaluation.releaseDate) && Objects.equals(this.assignedDate, evaluation.assignedDate) && Objects.equals(this.changedDate, evaluation.changedDate) && Objects.equals(this.revisionCreatedDate, evaluation.revisionCreatedDate) && Objects.equals(this.queue, evaluation.queue) && Objects.equals(this.mediaType, evaluation.mediaType) && Objects.equals(this.rescore, evaluation.rescore) && Objects.equals(this.conversationDate, evaluation.conversationDate) && Objects.equals(this.conversationEndDate, evaluation.conversationEndDate) && Objects.equals(this.neverRelease, evaluation.neverRelease) && Objects.equals(this.assigned, evaluation.assigned) && Objects.equals(this.dateAssigneeChanged, evaluation.dateAssigneeChanged) && Objects.equals(this.resourceId, evaluation.resourceId) && Objects.equals((Object)this.resourceType, (Object)evaluation.resourceType) && Objects.equals(this.redacted, evaluation.redacted) && Objects.equals(this.agentTeam, evaluation.agentTeam) && Objects.equals(this.isScoringIndex, evaluation.isScoringIndex) && Objects.equals(this.authorizedActions, evaluation.authorizedActions) && Objects.equals(this.hasAssistanceFailed, evaluation.hasAssistanceFailed) && Objects.equals(this.evaluationSource, evaluation.evaluationSource) && Objects.equals(this.aiScoring, evaluation.aiScoring) && Objects.equals(this.selfUri, evaluation.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.conversation, this.evaluationForm, this.evaluator, this.agent, this.calibration, this.status, this.answers, this.agentHasRead, this.assignee, this.assigneeApplicable, this.releaseDate, this.assignedDate, this.changedDate, this.revisionCreatedDate, this.queue, this.mediaType, this.rescore, this.conversationDate, this.conversationEndDate, this.neverRelease, this.assigned, this.dateAssigneeChanged, this.resourceId, this.resourceType, this.redacted, this.agentTeam, this.isScoringIndex, this.authorizedActions, this.hasAssistanceFailed, this.evaluationSource, this.aiScoring, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Evaluation {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("    evaluationForm: ").append(this.toIndentedString(this.evaluationForm)).append("\n");
        sb.append("    evaluator: ").append(this.toIndentedString(this.evaluator)).append("\n");
        sb.append("    agent: ").append(this.toIndentedString(this.agent)).append("\n");
        sb.append("    calibration: ").append(this.toIndentedString(this.calibration)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    answers: ").append(this.toIndentedString(this.answers)).append("\n");
        sb.append("    agentHasRead: ").append(this.toIndentedString(this.agentHasRead)).append("\n");
        sb.append("    assignee: ").append(this.toIndentedString(this.assignee)).append("\n");
        sb.append("    assigneeApplicable: ").append(this.toIndentedString(this.assigneeApplicable)).append("\n");
        sb.append("    releaseDate: ").append(this.toIndentedString(this.releaseDate)).append("\n");
        sb.append("    assignedDate: ").append(this.toIndentedString(this.assignedDate)).append("\n");
        sb.append("    changedDate: ").append(this.toIndentedString(this.changedDate)).append("\n");
        sb.append("    revisionCreatedDate: ").append(this.toIndentedString(this.revisionCreatedDate)).append("\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString(this.mediaType)).append("\n");
        sb.append("    rescore: ").append(this.toIndentedString(this.rescore)).append("\n");
        sb.append("    conversationDate: ").append(this.toIndentedString(this.conversationDate)).append("\n");
        sb.append("    conversationEndDate: ").append(this.toIndentedString(this.conversationEndDate)).append("\n");
        sb.append("    neverRelease: ").append(this.toIndentedString(this.neverRelease)).append("\n");
        sb.append("    assigned: ").append(this.toIndentedString(this.assigned)).append("\n");
        sb.append("    dateAssigneeChanged: ").append(this.toIndentedString(this.dateAssigneeChanged)).append("\n");
        sb.append("    resourceId: ").append(this.toIndentedString(this.resourceId)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString((Object)this.resourceType)).append("\n");
        sb.append("    redacted: ").append(this.toIndentedString(this.redacted)).append("\n");
        sb.append("    agentTeam: ").append(this.toIndentedString(this.agentTeam)).append("\n");
        sb.append("    isScoringIndex: ").append(this.toIndentedString(this.isScoringIndex)).append("\n");
        sb.append("    authorizedActions: ").append(this.toIndentedString(this.authorizedActions)).append("\n");
        sb.append("    hasAssistanceFailed: ").append(this.toIndentedString(this.hasAssistanceFailed)).append("\n");
        sb.append("    evaluationSource: ").append(this.toIndentedString(this.evaluationSource)).append("\n");
        sb.append("    aiScoring: ").append(this.toIndentedString(this.aiScoring)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PENDING("PENDING"),
        INPROGRESS("INPROGRESS"),
        FINISHED("FINISHED"),
        INREVIEW("INREVIEW"),
        RETRACTED("RETRACTED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ResourceTypeEnumDeserializer.class)
    public static enum ResourceTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EMAIL("EMAIL");

        private String value;

        private ResourceTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ResourceTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ResourceTypeEnum value : ResourceTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ResourceTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ResourceTypeEnumDeserializer
    extends StdDeserializer<ResourceTypeEnum> {
        public ResourceTypeEnumDeserializer() {
            super(ResourceTypeEnumDeserializer.class);
        }

        public ResourceTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ResourceTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        CALL("CALL"),
        CALLBACK("CALLBACK"),
        CHAT("CHAT"),
        COBROWSE("COBROWSE"),
        EMAIL("EMAIL"),
        MESSAGE("MESSAGE"),
        INTERNAL_MESSAGE("INTERNAL_MESSAGE"),
        SOCIAL_EXPRESSION("SOCIAL_EXPRESSION"),
        VIDEO("VIDEO"),
        SCREENSHARE("SCREENSHARE");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

