/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.BuShortTermForecastWeekReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Create work plan bid model")
public class CreateWorkPlanBid
implements Serializable {
    private String name = null;
    private BuShortTermForecastWeekReference forecast = null;
    private LocalDate bidWindowStartDate = null;
    private LocalDate bidWindowEndDate = null;
    private LocalDate effectiveDate = null;
    private AgentRankingTypeEnum agentRankingType = null;
    private RankingTiebreakerTypeEnum rankingTiebreakerType = null;
    private List<WorkPlanFieldsVisibleToAgentsEnum> workPlanFieldsVisibleToAgents = new ArrayList<WorkPlanFieldsVisibleToAgentsEnum>();

    public CreateWorkPlanBid name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the work plan bid")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateWorkPlanBid forecast(BuShortTermForecastWeekReference forecast) {
        this.forecast = forecast;
        return this;
    }

    @ApiModelProperty(example="null", value="The selected forecast in this work plan bid")
    @JsonProperty(value="forecast")
    public BuShortTermForecastWeekReference getForecast() {
        return this.forecast;
    }

    public void setForecast(BuShortTermForecastWeekReference forecast) {
        this.forecast = forecast;
    }

    public CreateWorkPlanBid bidWindowStartDate(LocalDate bidWindowStartDate) {
        this.bidWindowStartDate = bidWindowStartDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The bid start date where agents start participate in work plan bidding in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="bidWindowStartDate")
    public LocalDate getBidWindowStartDate() {
        return this.bidWindowStartDate;
    }

    public void setBidWindowStartDate(LocalDate bidWindowStartDate) {
        this.bidWindowStartDate = bidWindowStartDate;
    }

    public CreateWorkPlanBid bidWindowEndDate(LocalDate bidWindowEndDate) {
        this.bidWindowEndDate = bidWindowEndDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The bid end date in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="bidWindowEndDate")
    public LocalDate getBidWindowEndDate() {
        return this.bidWindowEndDate;
    }

    public void setBidWindowEndDate(LocalDate bidWindowEndDate) {
        this.bidWindowEndDate = bidWindowEndDate;
    }

    public CreateWorkPlanBid effectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The date when agents will be assigned to the new work plan in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="effectiveDate")
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public CreateWorkPlanBid agentRankingType(AgentRankingTypeEnum agentRankingType) {
        this.agentRankingType = agentRankingType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of agent ranking selected for this bid")
    @JsonProperty(value="agentRankingType")
    public AgentRankingTypeEnum getAgentRankingType() {
        return this.agentRankingType;
    }

    public void setAgentRankingType(AgentRankingTypeEnum agentRankingType) {
        this.agentRankingType = agentRankingType;
    }

    public CreateWorkPlanBid rankingTiebreakerType(RankingTiebreakerTypeEnum rankingTiebreakerType) {
        this.rankingTiebreakerType = rankingTiebreakerType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Ranking tiebreaker to be used")
    @JsonProperty(value="rankingTiebreakerType")
    public RankingTiebreakerTypeEnum getRankingTiebreakerType() {
        return this.rankingTiebreakerType;
    }

    public void setRankingTiebreakerType(RankingTiebreakerTypeEnum rankingTiebreakerType) {
        this.rankingTiebreakerType = rankingTiebreakerType;
    }

    public CreateWorkPlanBid workPlanFieldsVisibleToAgents(List<WorkPlanFieldsVisibleToAgentsEnum> workPlanFieldsVisibleToAgents) {
        this.workPlanFieldsVisibleToAgents = workPlanFieldsVisibleToAgents;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The work plan fields visible to agents whenever work plan preferences are made")
    @JsonProperty(value="workPlanFieldsVisibleToAgents")
    public List<WorkPlanFieldsVisibleToAgentsEnum> getWorkPlanFieldsVisibleToAgents() {
        return this.workPlanFieldsVisibleToAgents;
    }

    public void setWorkPlanFieldsVisibleToAgents(List<WorkPlanFieldsVisibleToAgentsEnum> workPlanFieldsVisibleToAgents) {
        this.workPlanFieldsVisibleToAgents = workPlanFieldsVisibleToAgents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateWorkPlanBid createWorkPlanBid = (CreateWorkPlanBid)o;
        return Objects.equals(this.name, createWorkPlanBid.name) && Objects.equals(this.forecast, createWorkPlanBid.forecast) && Objects.equals(this.bidWindowStartDate, createWorkPlanBid.bidWindowStartDate) && Objects.equals(this.bidWindowEndDate, createWorkPlanBid.bidWindowEndDate) && Objects.equals(this.effectiveDate, createWorkPlanBid.effectiveDate) && Objects.equals((Object)this.agentRankingType, (Object)createWorkPlanBid.agentRankingType) && Objects.equals((Object)this.rankingTiebreakerType, (Object)createWorkPlanBid.rankingTiebreakerType) && Objects.equals(this.workPlanFieldsVisibleToAgents, createWorkPlanBid.workPlanFieldsVisibleToAgents);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.forecast, this.bidWindowStartDate, this.bidWindowEndDate, this.effectiveDate, this.agentRankingType, this.rankingTiebreakerType, this.workPlanFieldsVisibleToAgents});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateWorkPlanBid {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    forecast: ").append(this.toIndentedString(this.forecast)).append("\n");
        sb.append("    bidWindowStartDate: ").append(this.toIndentedString(this.bidWindowStartDate)).append("\n");
        sb.append("    bidWindowEndDate: ").append(this.toIndentedString(this.bidWindowEndDate)).append("\n");
        sb.append("    effectiveDate: ").append(this.toIndentedString(this.effectiveDate)).append("\n");
        sb.append("    agentRankingType: ").append(this.toIndentedString((Object)this.agentRankingType)).append("\n");
        sb.append("    rankingTiebreakerType: ").append(this.toIndentedString((Object)this.rankingTiebreakerType)).append("\n");
        sb.append("    workPlanFieldsVisibleToAgents: ").append(this.toIndentedString(this.workPlanFieldsVisibleToAgents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AgentRankingTypeEnumDeserializer.class)
    public static enum AgentRankingTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        HIREDATE("HireDate"),
        PERFORMANCE("Performance");

        private String value;

        private AgentRankingTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AgentRankingTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AgentRankingTypeEnum value : AgentRankingTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AgentRankingTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=RankingTiebreakerTypeEnumDeserializer.class)
    public static enum RankingTiebreakerTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        HIREDATE("HireDate"),
        PERFORMANCE("Performance"),
        CUSTOM("Custom"),
        RANDOMLYASSIGN("RandomlyAssign");

        private String value;

        private RankingTiebreakerTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RankingTiebreakerTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RankingTiebreakerTypeEnum value : RankingTiebreakerTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RankingTiebreakerTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=WorkPlanFieldsVisibleToAgentsEnumDeserializer.class)
    public static enum WorkPlanFieldsVisibleToAgentsEnum {
        NAME("Name"),
        PAIDHOURS("PaidHours");

        private String value;

        private WorkPlanFieldsVisibleToAgentsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static WorkPlanFieldsVisibleToAgentsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (WorkPlanFieldsVisibleToAgentsEnum value : WorkPlanFieldsVisibleToAgentsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return WorkPlanFieldsVisibleToAgentsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class WorkPlanFieldsVisibleToAgentsEnumDeserializer
    extends StdDeserializer<WorkPlanFieldsVisibleToAgentsEnum> {
        public WorkPlanFieldsVisibleToAgentsEnumDeserializer() {
            super(WorkPlanFieldsVisibleToAgentsEnumDeserializer.class);
        }

        public WorkPlanFieldsVisibleToAgentsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return WorkPlanFieldsVisibleToAgentsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class RankingTiebreakerTypeEnumDeserializer
    extends StdDeserializer<RankingTiebreakerTypeEnum> {
        public RankingTiebreakerTypeEnumDeserializer() {
            super(RankingTiebreakerTypeEnumDeserializer.class);
        }

        public RankingTiebreakerTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RankingTiebreakerTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class AgentRankingTypeEnumDeserializer
    extends StdDeserializer<AgentRankingTypeEnum> {
        public AgentRankingTypeEnumDeserializer() {
            super(AgentRankingTypeEnumDeserializer.class);
        }

        public AgentRankingTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AgentRankingTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

