/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.ConversationEditedInput;
import com.mypurecloud.sdk.v2.model.ConversationSummaryFollowup;
import com.mypurecloud.sdk.v2.model.ConversationSummaryReason;
import com.mypurecloud.sdk.v2.model.ConversationSummaryResolution;
import com.mypurecloud.sdk.v2.model.ConversationSummaryWrapupCode;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ConversationSummary
implements Serializable {
    private String text = null;
    private StatusEnum status = null;
    private MediaTypeEnum mediaType = null;
    private String language = null;
    private List<ConversationSummaryWrapupCode> predictedWrapupCodes = new ArrayList<ConversationSummaryWrapupCode>();
    private ConversationEditedInput editedSummary = null;
    private ConversationSummaryReason reason = null;
    private ConversationSummaryFollowup followup = null;
    private ConversationSummaryResolution resolution = null;
    private Date dateCreated = null;
    private String id = null;
    private Float confidence = null;
    private List<AddressableEntityRef> participants = new ArrayList<AddressableEntityRef>();

    public ConversationSummary text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="The text of the summary.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ConversationSummary status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the conversation summary.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ConversationSummary mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="The media type of the conversation.")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public ConversationSummary language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", value="The language of the conversation.")
    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public ConversationSummary predictedWrapupCodes(List<ConversationSummaryWrapupCode> predictedWrapupCodes) {
        this.predictedWrapupCodes = predictedWrapupCodes;
        return this;
    }

    @ApiModelProperty(example="null", value="The wrapup codes of the conversation summary.")
    @JsonProperty(value="predictedWrapupCodes")
    public List<ConversationSummaryWrapupCode> getPredictedWrapupCodes() {
        return this.predictedWrapupCodes;
    }

    public void setPredictedWrapupCodes(List<ConversationSummaryWrapupCode> predictedWrapupCodes) {
        this.predictedWrapupCodes = predictedWrapupCodes;
    }

    public ConversationSummary editedSummary(ConversationEditedInput editedSummary) {
        this.editedSummary = editedSummary;
        return this;
    }

    @ApiModelProperty(example="null", value="The edited summary of the conversation.")
    @JsonProperty(value="editedSummary")
    public ConversationEditedInput getEditedSummary() {
        return this.editedSummary;
    }

    public void setEditedSummary(ConversationEditedInput editedSummary) {
        this.editedSummary = editedSummary;
    }

    public ConversationSummary reason(ConversationSummaryReason reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason of the conversation summary.")
    @JsonProperty(value="reason")
    public ConversationSummaryReason getReason() {
        return this.reason;
    }

    public void setReason(ConversationSummaryReason reason) {
        this.reason = reason;
    }

    public ConversationSummary followup(ConversationSummaryFollowup followup) {
        this.followup = followup;
        return this;
    }

    @ApiModelProperty(example="null", value="The followup of the conversation summary.")
    @JsonProperty(value="followup")
    public ConversationSummaryFollowup getFollowup() {
        return this.followup;
    }

    public void setFollowup(ConversationSummaryFollowup followup) {
        this.followup = followup;
    }

    public ConversationSummary resolution(ConversationSummaryResolution resolution) {
        this.resolution = resolution;
        return this;
    }

    @ApiModelProperty(example="null", value="The resolution of the conversation summary.")
    @JsonProperty(value="resolution")
    public ConversationSummaryResolution getResolution() {
        return this.resolution;
    }

    public void setResolution(ConversationSummaryResolution resolution) {
        this.resolution = resolution;
    }

    public ConversationSummary dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="The created date of the summary. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @ApiModelProperty(example="null", value="The id of the summary.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The AI confidence value.")
    @JsonProperty(value="confidence")
    public Float getConfidence() {
        return this.confidence;
    }

    public ConversationSummary participants(List<AddressableEntityRef> participants) {
        this.participants = participants;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of participants.")
    @JsonProperty(value="participants")
    public List<AddressableEntityRef> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<AddressableEntityRef> participants) {
        this.participants = participants;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationSummary conversationSummary = (ConversationSummary)o;
        return Objects.equals(this.text, conversationSummary.text) && Objects.equals((Object)this.status, (Object)conversationSummary.status) && Objects.equals((Object)this.mediaType, (Object)conversationSummary.mediaType) && Objects.equals(this.language, conversationSummary.language) && Objects.equals(this.predictedWrapupCodes, conversationSummary.predictedWrapupCodes) && Objects.equals(this.editedSummary, conversationSummary.editedSummary) && Objects.equals(this.reason, conversationSummary.reason) && Objects.equals(this.followup, conversationSummary.followup) && Objects.equals(this.resolution, conversationSummary.resolution) && Objects.equals(this.dateCreated, conversationSummary.dateCreated) && Objects.equals(this.id, conversationSummary.id) && Objects.equals(this.confidence, conversationSummary.confidence) && Objects.equals(this.participants, conversationSummary.participants);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.text, this.status, this.mediaType, this.language, this.predictedWrapupCodes, this.editedSummary, this.reason, this.followup, this.resolution, this.dateCreated, this.id, this.confidence, this.participants});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationSummary {\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    predictedWrapupCodes: ").append(this.toIndentedString(this.predictedWrapupCodes)).append("\n");
        sb.append("    editedSummary: ").append(this.toIndentedString(this.editedSummary)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    followup: ").append(this.toIndentedString(this.followup)).append("\n");
        sb.append("    resolution: ").append(this.toIndentedString(this.resolution)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    confidence: ").append(this.toIndentedString(this.confidence)).append("\n");
        sb.append("    participants: ").append(this.toIndentedString(this.participants)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PENDING("Pending"),
        QUEUED("Queued"),
        STARTED("Started"),
        COMPLETED("Completed"),
        ERROR("Error"),
        PROCESSING("Processing");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EMAIL("Email"),
        CALL("Call"),
        CHAT("Chat"),
        MESSAGE("Message"),
        WEBMESSAGING("Webmessaging"),
        UNKNOWN("Unknown");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

