/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;

public class AlternativeShiftNotification
implements Serializable {
    private String id = null;
    private LocalDate weekDate = null;
    private GranularityEnum granularity = null;
    private NewStateEnum newState = null;
    private UserReference initiatingUser = null;
    private Date initiatingShiftDate = null;
    private UserReference receivingUser = null;
    private Date receivingShiftDate = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public AlternativeShiftNotification weekDate(LocalDate weekDate) {
        this.weekDate = weekDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The start date of the schedule with which this trade is associated. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="weekDate")
    public LocalDate getWeekDate() {
        return this.weekDate;
    }

    public void setWeekDate(LocalDate weekDate) {
        this.weekDate = weekDate;
    }

    public AlternativeShiftNotification granularity(GranularityEnum granularity) {
        this.granularity = granularity;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The granularity of alternative shifts to be traded")
    @JsonProperty(value="granularity")
    public GranularityEnum getGranularity() {
        return this.granularity;
    }

    public void setGranularity(GranularityEnum granularity) {
        this.granularity = granularity;
    }

    public AlternativeShiftNotification newState(NewStateEnum newState) {
        this.newState = newState;
        return this;
    }

    @ApiModelProperty(example="null", value="The new state of the alternative shift trade, null if there was no change")
    @JsonProperty(value="newState")
    public NewStateEnum getNewState() {
        return this.newState;
    }

    public void setNewState(NewStateEnum newState) {
        this.newState = newState;
    }

    public AlternativeShiftNotification initiatingUser(UserReference initiatingUser) {
        this.initiatingUser = initiatingUser;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The user who initiated the alternative shift trade")
    @JsonProperty(value="initiatingUser")
    public UserReference getInitiatingUser() {
        return this.initiatingUser;
    }

    public void setInitiatingUser(UserReference initiatingUser) {
        this.initiatingUser = initiatingUser;
    }

    public AlternativeShiftNotification initiatingShiftDate(Date initiatingShiftDate) {
        this.initiatingShiftDate = initiatingShiftDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The start date and time of the initiating shift. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="initiatingShiftDate")
    public Date getInitiatingShiftDate() {
        return this.initiatingShiftDate;
    }

    public void setInitiatingShiftDate(Date initiatingShiftDate) {
        this.initiatingShiftDate = initiatingShiftDate;
    }

    public AlternativeShiftNotification receivingUser(UserReference receivingUser) {
        this.receivingUser = receivingUser;
        return this;
    }

    @ApiModelProperty(example="null", value="The user on the receiving side of this alternative shift trade")
    @JsonProperty(value="receivingUser")
    public UserReference getReceivingUser() {
        return this.receivingUser;
    }

    public void setReceivingUser(UserReference receivingUser) {
        this.receivingUser = receivingUser;
    }

    public AlternativeShiftNotification receivingShiftDate(Date receivingShiftDate) {
        this.receivingShiftDate = receivingShiftDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The start date and time of the receiving alternative shift. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="receivingShiftDate")
    public Date getReceivingShiftDate() {
        return this.receivingShiftDate;
    }

    public void setReceivingShiftDate(Date receivingShiftDate) {
        this.receivingShiftDate = receivingShiftDate;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlternativeShiftNotification alternativeShiftNotification = (AlternativeShiftNotification)o;
        return Objects.equals(this.id, alternativeShiftNotification.id) && Objects.equals(this.weekDate, alternativeShiftNotification.weekDate) && Objects.equals((Object)this.granularity, (Object)alternativeShiftNotification.granularity) && Objects.equals((Object)this.newState, (Object)alternativeShiftNotification.newState) && Objects.equals(this.initiatingUser, alternativeShiftNotification.initiatingUser) && Objects.equals(this.initiatingShiftDate, alternativeShiftNotification.initiatingShiftDate) && Objects.equals(this.receivingUser, alternativeShiftNotification.receivingUser) && Objects.equals(this.receivingShiftDate, alternativeShiftNotification.receivingShiftDate) && Objects.equals(this.selfUri, alternativeShiftNotification.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.weekDate, this.granularity, this.newState, this.initiatingUser, this.initiatingShiftDate, this.receivingUser, this.receivingShiftDate, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlternativeShiftNotification {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    weekDate: ").append(this.toIndentedString(this.weekDate)).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString((Object)this.granularity)).append("\n");
        sb.append("    newState: ").append(this.toIndentedString((Object)this.newState)).append("\n");
        sb.append("    initiatingUser: ").append(this.toIndentedString(this.initiatingUser)).append("\n");
        sb.append("    initiatingShiftDate: ").append(this.toIndentedString(this.initiatingShiftDate)).append("\n");
        sb.append("    receivingUser: ").append(this.toIndentedString(this.receivingUser)).append("\n");
        sb.append("    receivingShiftDate: ").append(this.toIndentedString(this.receivingShiftDate)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=GranularityEnumDeserializer.class)
    public static enum GranularityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DAILY("Daily");

        private String value;

        private GranularityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GranularityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GranularityEnum value : GranularityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GranularityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=NewStateEnumDeserializer.class)
    public static enum NewStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CANCELED("Canceled"),
        DENIED("Denied"),
        EXPIRED("Expired"),
        SUBMITTED("Submitted"),
        APPROVED("Approved");

        private String value;

        private NewStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static NewStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (NewStateEnum value : NewStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return NewStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class NewStateEnumDeserializer
    extends StdDeserializer<NewStateEnum> {
        public NewStateEnumDeserializer() {
            super(NewStateEnumDeserializer.class);
        }

        public NewStateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return NewStateEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class GranularityEnumDeserializer
    extends StdDeserializer<GranularityEnum> {
        public GranularityEnumDeserializer() {
            super(GranularityEnumDeserializer.class);
        }

        public GranularityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return GranularityEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

