/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;

public class WorkPlanOverrideRequest
implements Serializable {
    private ActionEnum action = null;
    private LocalDate startDate = null;
    private Integer weekCount = null;
    private String workPlanId = null;

    public WorkPlanOverrideRequest action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(example="null", value="The action to perform on work plan override, defaults to add")
    @JsonProperty(value="action")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public WorkPlanOverrideRequest startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The start date in yyyy-MM-dd format for the updated work plan. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="startDate")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public WorkPlanOverrideRequest weekCount(Integer weekCount) {
        this.weekCount = weekCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The week count of the updated work plan, required if action is Add or Update")
    @JsonProperty(value="weekCount")
    public Integer getWeekCount() {
        return this.weekCount;
    }

    public void setWeekCount(Integer weekCount) {
        this.weekCount = weekCount;
    }

    public WorkPlanOverrideRequest workPlanId(String workPlanId) {
        this.workPlanId = workPlanId;
        return this;
    }

    @ApiModelProperty(example="null", value="The updated work plan id")
    @JsonProperty(value="workPlanId")
    public String getWorkPlanId() {
        return this.workPlanId;
    }

    public void setWorkPlanId(String workPlanId) {
        this.workPlanId = workPlanId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkPlanOverrideRequest workPlanOverrideRequest = (WorkPlanOverrideRequest)o;
        return Objects.equals((Object)this.action, (Object)workPlanOverrideRequest.action) && Objects.equals(this.startDate, workPlanOverrideRequest.startDate) && Objects.equals(this.weekCount, workPlanOverrideRequest.weekCount) && Objects.equals(this.workPlanId, workPlanOverrideRequest.workPlanId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.startDate, this.weekCount, this.workPlanId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkPlanOverrideRequest {\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    weekCount: ").append(this.toIndentedString(this.weekCount)).append("\n");
        sb.append("    workPlanId: ").append(this.toIndentedString(this.workPlanId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ActionEnumDeserializer.class)
    public static enum ActionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ADD("Add"),
        UPDATE("Update"),
        DELETE("Delete");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionEnum value : ActionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActionEnumDeserializer
    extends StdDeserializer<ActionEnum> {
        public ActionEnumDeserializer() {
            super(ActionEnumDeserializer.class);
        }

        public ActionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActionEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

