/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.Browser;
import com.mypurecloud.sdk.v2.model.ConnectedQueue;
import com.mypurecloud.sdk.v2.model.ConnectedUser;
import com.mypurecloud.sdk.v2.model.ConversationChannel;
import com.mypurecloud.sdk.v2.model.ConversationUserDisposition;
import com.mypurecloud.sdk.v2.model.CustomEventAttribute;
import com.mypurecloud.sdk.v2.model.CustomEventAttributeList;
import com.mypurecloud.sdk.v2.model.Device;
import com.mypurecloud.sdk.v2.model.JourneyApp;
import com.mypurecloud.sdk.v2.model.JourneyCampaign;
import com.mypurecloud.sdk.v2.model.JourneyGeolocation;
import com.mypurecloud.sdk.v2.model.JourneyPage;
import com.mypurecloud.sdk.v2.model.NetworkConnectivity;
import com.mypurecloud.sdk.v2.model.OutcomeAchievement;
import com.mypurecloud.sdk.v2.model.Referrer;
import com.mypurecloud.sdk.v2.model.SdkLibrary;
import com.mypurecloud.sdk.v2.model.SessionLastEvent;
import com.mypurecloud.sdk.v2.model.SessionSegmentAssignment;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Session
implements Serializable {
    private String id = null;
    private String customerId = null;
    private String customerIdType = null;
    private String type = null;
    private String externalId = null;
    private String externalUrl = null;
    private String shortId = null;
    private List<OutcomeAchievement> outcomeAchievements = new ArrayList<OutcomeAchievement>();
    private List<SessionSegmentAssignment> segmentAssignments = new ArrayList<SessionSegmentAssignment>();
    private Map<String, CustomEventAttribute> attributes = null;
    private Map<String, CustomEventAttributeList> attributeLists = null;
    private Browser browser = null;
    private Device device = null;
    private JourneyGeolocation geolocation = null;
    private String ipAddress = null;
    private String ipOrganization = null;
    private JourneyPage lastPage = null;
    private JourneyCampaign mktCampaign = null;
    private Referrer referrer = null;
    private JourneyApp app = null;
    private SdkLibrary sdkLibrary = null;
    private NetworkConnectivity networkConnectivity = null;
    private List<String> searchTerms = new ArrayList<String>();
    private String userAgentString = null;
    private Integer durationInSeconds = null;
    private Integer eventCount = null;
    private Integer pageviewCount = null;
    private Integer screenviewCount = null;
    private SessionLastEvent lastEvent = null;
    private ConnectedQueue lastConnectedQueue = null;
    private ConnectedUser lastConnectedUser = null;
    private ConversationUserDisposition lastUserDisposition = null;
    private List<ConversationChannel> conversationChannels = new ArrayList<ConversationChannel>();
    private OriginatingDirectionEnum originatingDirection = null;
    private String conversationSubject = null;
    private LastUserDisconnectTypeEnum lastUserDisconnectType = null;
    private LastAcdOutcomeEnum lastAcdOutcome = null;
    private Boolean authenticated = null;
    private List<String> divisionIds = new ArrayList<String>();
    private String lastScreen = null;
    private String selfUri = null;
    private Date createdDate = null;
    private Date endedDate = null;
    private AddressableEntityRef externalContact = null;
    private Date awayDate = null;
    private Date idleDate = null;
    private AddressableEntityRef conversation = null;

    public Session id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the session.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Session customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    @ApiModelProperty(example="null", value="Primary identifier of the customer in the source where the events for the session originate from.")
    @JsonProperty(value="customerId")
    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public Session customerIdType(String customerIdType) {
        this.customerIdType = customerIdType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of source customer identifier (e.g. cookie, email, phone).")
    @JsonProperty(value="customerIdType")
    public String getCustomerIdType() {
        return this.customerIdType;
    }

    public void setCustomerIdType(String customerIdType) {
        this.customerIdType = customerIdType;
    }

    public Session type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Session types indicate the type or category of sessions (e.g. web, app).")
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Session externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier in the external system where the events for the session originate from.")
    @JsonProperty(value="externalId")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Session externalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="A URL that identifies an external system-of-record resource that may have more detailed information on the session.")
    @JsonProperty(value="externalUrl")
    public String getExternalUrl() {
        return this.externalUrl;
    }

    public void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }

    public Session shortId(String shortId) {
        this.shortId = shortId;
        return this;
    }

    @ApiModelProperty(example="null", value="Shortened numeric identifier of 4-6 digits.")
    @JsonProperty(value="shortId")
    public String getShortId() {
        return this.shortId;
    }

    public void setShortId(String shortId) {
        this.shortId = shortId;
    }

    public Session outcomeAchievements(List<OutcomeAchievement> outcomeAchievements) {
        this.outcomeAchievements = outcomeAchievements;
        return this;
    }

    @ApiModelProperty(example="null", value="List of the outcome achievements by the customer in this session.")
    @JsonProperty(value="outcomeAchievements")
    public List<OutcomeAchievement> getOutcomeAchievements() {
        return this.outcomeAchievements;
    }

    public void setOutcomeAchievements(List<OutcomeAchievement> outcomeAchievements) {
        this.outcomeAchievements = outcomeAchievements;
    }

    public Session segmentAssignments(List<SessionSegmentAssignment> segmentAssignments) {
        this.segmentAssignments = segmentAssignments;
        return this;
    }

    @ApiModelProperty(example="null", value="List of the segment assignments to the customer in this session.")
    @JsonProperty(value="segmentAssignments")
    public List<SessionSegmentAssignment> getSegmentAssignments() {
        return this.segmentAssignments;
    }

    public void setSegmentAssignments(List<SessionSegmentAssignment> segmentAssignments) {
        this.segmentAssignments = segmentAssignments;
    }

    public Session attributes(Map<String, CustomEventAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="null", value="Attributes projected from the session's event stream.")
    @JsonProperty(value="attributes")
    public Map<String, CustomEventAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, CustomEventAttribute> attributes) {
        this.attributes = attributes;
    }

    public Session attributeLists(Map<String, CustomEventAttributeList> attributeLists) {
        this.attributeLists = attributeLists;
        return this;
    }

    @ApiModelProperty(example="null", value="List-type attributes projected from the session's event stream.")
    @JsonProperty(value="attributeLists")
    public Map<String, CustomEventAttributeList> getAttributeLists() {
        return this.attributeLists;
    }

    public void setAttributeLists(Map<String, CustomEventAttributeList> attributeLists) {
        this.attributeLists = attributeLists;
    }

    public Session browser(Browser browser) {
        this.browser = browser;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer's browser.")
    @JsonProperty(value="browser")
    public Browser getBrowser() {
        return this.browser;
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    public Session device(Device device) {
        this.device = device;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer's device.")
    @JsonProperty(value="device")
    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public Session geolocation(JourneyGeolocation geolocation) {
        this.geolocation = geolocation;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer's geolocation.")
    @JsonProperty(value="geolocation")
    public JourneyGeolocation getGeolocation() {
        return this.geolocation;
    }

    public void setGeolocation(JourneyGeolocation geolocation) {
        this.geolocation = geolocation;
    }

    public Session ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer's IP address.")
    @JsonProperty(value="ipAddress")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public Session ipOrganization(String ipOrganization) {
        this.ipOrganization = ipOrganization;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer's IP-based organization or ISP name.")
    @JsonProperty(value="ipOrganization")
    public String getIpOrganization() {
        return this.ipOrganization;
    }

    public void setIpOrganization(String ipOrganization) {
        this.ipOrganization = ipOrganization;
    }

    public Session lastPage(JourneyPage lastPage) {
        this.lastPage = lastPage;
        return this;
    }

    @ApiModelProperty(example="null", value="The webpage where the customer's last web interaction occurred.")
    @JsonProperty(value="lastPage")
    public JourneyPage getLastPage() {
        return this.lastPage;
    }

    public void setLastPage(JourneyPage lastPage) {
        this.lastPage = lastPage;
    }

    public Session mktCampaign(JourneyCampaign mktCampaign) {
        this.mktCampaign = mktCampaign;
        return this;
    }

    @ApiModelProperty(example="null", value="Marketing / traffic source information.")
    @JsonProperty(value="mktCampaign")
    public JourneyCampaign getMktCampaign() {
        return this.mktCampaign;
    }

    public void setMktCampaign(JourneyCampaign mktCampaign) {
        this.mktCampaign = mktCampaign;
    }

    public Session referrer(Referrer referrer) {
        this.referrer = referrer;
        return this;
    }

    @ApiModelProperty(example="null", value="Identifies the page URL that originally generated the request for the current page being viewed.")
    @JsonProperty(value="referrer")
    public Referrer getReferrer() {
        return this.referrer;
    }

    public void setReferrer(Referrer referrer) {
        this.referrer = referrer;
    }

    public Session app(JourneyApp app) {
        this.app = app;
        return this;
    }

    @ApiModelProperty(example="null", value="Application that the customer is interacting with (for app sessions).")
    @JsonProperty(value="app")
    public JourneyApp getApp() {
        return this.app;
    }

    public void setApp(JourneyApp app) {
        this.app = app;
    }

    public Session sdkLibrary(SdkLibrary sdkLibrary) {
        this.sdkLibrary = sdkLibrary;
        return this;
    }

    @ApiModelProperty(example="null", value="SDK library used to generate the events for the session (for app and web sessions).")
    @JsonProperty(value="sdkLibrary")
    public SdkLibrary getSdkLibrary() {
        return this.sdkLibrary;
    }

    public void setSdkLibrary(SdkLibrary sdkLibrary) {
        this.sdkLibrary = sdkLibrary;
    }

    public Session networkConnectivity(NetworkConnectivity networkConnectivity) {
        this.networkConnectivity = networkConnectivity;
        return this;
    }

    @ApiModelProperty(example="null", value="Information relating to the device's network connectivity (for app sessions).")
    @JsonProperty(value="networkConnectivity")
    public NetworkConnectivity getNetworkConnectivity() {
        return this.networkConnectivity;
    }

    public void setNetworkConnectivity(NetworkConnectivity networkConnectivity) {
        this.networkConnectivity = networkConnectivity;
    }

    public Session searchTerms(List<String> searchTerms) {
        this.searchTerms = searchTerms;
        return this;
    }

    @ApiModelProperty(example="null", value="Search terms associated with the session.")
    @JsonProperty(value="searchTerms")
    public List<String> getSearchTerms() {
        return this.searchTerms;
    }

    public void setSearchTerms(List<String> searchTerms) {
        this.searchTerms = searchTerms;
    }

    public Session userAgentString(String userAgentString) {
        this.userAgentString = userAgentString;
        return this;
    }

    @ApiModelProperty(example="null", value="String identifying the user agent.")
    @JsonProperty(value="userAgentString")
    public String getUserAgentString() {
        return this.userAgentString;
    }

    public void setUserAgentString(String userAgentString) {
        this.userAgentString = userAgentString;
    }

    public Session durationInSeconds(Integer durationInSeconds) {
        this.durationInSeconds = durationInSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates how long the session has been active (valid for an individual device).")
    @JsonProperty(value="durationInSeconds")
    public Integer getDurationInSeconds() {
        return this.durationInSeconds;
    }

    public void setDurationInSeconds(Integer durationInSeconds) {
        this.durationInSeconds = durationInSeconds;
    }

    public Session eventCount(Integer eventCount) {
        this.eventCount = eventCount;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The count of all events performed during the session.")
    @JsonProperty(value="eventCount")
    public Integer getEventCount() {
        return this.eventCount;
    }

    public void setEventCount(Integer eventCount) {
        this.eventCount = eventCount;
    }

    public Session pageviewCount(Integer pageviewCount) {
        this.pageviewCount = pageviewCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The count of all pageviews performed during the session.")
    @JsonProperty(value="pageviewCount")
    public Integer getPageviewCount() {
        return this.pageviewCount;
    }

    public void setPageviewCount(Integer pageviewCount) {
        this.pageviewCount = pageviewCount;
    }

    public Session screenviewCount(Integer screenviewCount) {
        this.screenviewCount = screenviewCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The count of all screenviews performed during the session.")
    @JsonProperty(value="screenviewCount")
    public Integer getScreenviewCount() {
        return this.screenviewCount;
    }

    public void setScreenviewCount(Integer screenviewCount) {
        this.screenviewCount = screenviewCount;
    }

    public Session lastEvent(SessionLastEvent lastEvent) {
        this.lastEvent = lastEvent;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Information about the most recent event in this session.")
    @JsonProperty(value="lastEvent")
    public SessionLastEvent getLastEvent() {
        return this.lastEvent;
    }

    public void setLastEvent(SessionLastEvent lastEvent) {
        this.lastEvent = lastEvent;
    }

    public Session lastConnectedQueue(ConnectedQueue lastConnectedQueue) {
        this.lastConnectedQueue = lastConnectedQueue;
        return this;
    }

    @ApiModelProperty(example="null", value="The last queue connected to this session.")
    @JsonProperty(value="lastConnectedQueue")
    public ConnectedQueue getLastConnectedQueue() {
        return this.lastConnectedQueue;
    }

    public void setLastConnectedQueue(ConnectedQueue lastConnectedQueue) {
        this.lastConnectedQueue = lastConnectedQueue;
    }

    public Session lastConnectedUser(ConnectedUser lastConnectedUser) {
        this.lastConnectedUser = lastConnectedUser;
        return this;
    }

    @ApiModelProperty(example="null", value="The last user connected to this session.")
    @JsonProperty(value="lastConnectedUser")
    public ConnectedUser getLastConnectedUser() {
        return this.lastConnectedUser;
    }

    public void setLastConnectedUser(ConnectedUser lastConnectedUser) {
        this.lastConnectedUser = lastConnectedUser;
    }

    public Session lastUserDisposition(ConversationUserDisposition lastUserDisposition) {
        this.lastUserDisposition = lastUserDisposition;
        return this;
    }

    @ApiModelProperty(example="null", value="The last user disposition connected to this session.")
    @JsonProperty(value="lastUserDisposition")
    public ConversationUserDisposition getLastUserDisposition() {
        return this.lastUserDisposition;
    }

    public void setLastUserDisposition(ConversationUserDisposition lastUserDisposition) {
        this.lastUserDisposition = lastUserDisposition;
    }

    public Session conversationChannels(List<ConversationChannel> conversationChannels) {
        this.conversationChannels = conversationChannels;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents the channels used for this conversation.")
    @JsonProperty(value="conversationChannels")
    public List<ConversationChannel> getConversationChannels() {
        return this.conversationChannels;
    }

    public void setConversationChannels(List<ConversationChannel> conversationChannels) {
        this.conversationChannels = conversationChannels;
    }

    public Session originatingDirection(OriginatingDirectionEnum originatingDirection) {
        this.originatingDirection = originatingDirection;
        return this;
    }

    @ApiModelProperty(example="null", value="The original direction of the conversation.")
    @JsonProperty(value="originatingDirection")
    public OriginatingDirectionEnum getOriginatingDirection() {
        return this.originatingDirection;
    }

    public void setOriginatingDirection(OriginatingDirectionEnum originatingDirection) {
        this.originatingDirection = originatingDirection;
    }

    public Session conversationSubject(String conversationSubject) {
        this.conversationSubject = conversationSubject;
        return this;
    }

    @ApiModelProperty(example="null", value="The subject for the conversation, for example an email subject.")
    @JsonProperty(value="conversationSubject")
    public String getConversationSubject() {
        return this.conversationSubject;
    }

    public void setConversationSubject(String conversationSubject) {
        this.conversationSubject = conversationSubject;
    }

    public Session lastUserDisconnectType(LastUserDisconnectTypeEnum lastUserDisconnectType) {
        this.lastUserDisconnectType = lastUserDisconnectType;
        return this;
    }

    @ApiModelProperty(example="null", value="Disconnect reason for the last user connected to the conversation.")
    @JsonProperty(value="lastUserDisconnectType")
    public LastUserDisconnectTypeEnum getLastUserDisconnectType() {
        return this.lastUserDisconnectType;
    }

    public void setLastUserDisconnectType(LastUserDisconnectTypeEnum lastUserDisconnectType) {
        this.lastUserDisconnectType = lastUserDisconnectType;
    }

    public Session lastAcdOutcome(LastAcdOutcomeEnum lastAcdOutcome) {
        this.lastAcdOutcome = lastAcdOutcome;
        return this;
    }

    @ApiModelProperty(example="null", value="Last ACD outcome for the conversation.")
    @JsonProperty(value="lastAcdOutcome")
    public LastAcdOutcomeEnum getLastAcdOutcome() {
        return this.lastAcdOutcome;
    }

    public void setLastAcdOutcome(LastAcdOutcomeEnum lastAcdOutcome) {
        this.lastAcdOutcome = lastAcdOutcome;
    }

    public Session authenticated(Boolean authenticated) {
        this.authenticated = authenticated;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicates whether or not the session is authenticated.")
    @JsonProperty(value="authenticated")
    public Boolean getAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(Boolean authenticated) {
        this.authenticated = authenticated;
    }

    public Session divisionIds(List<String> divisionIds) {
        this.divisionIds = divisionIds;
        return this;
    }

    @ApiModelProperty(example="null", value="List of division IDs associated with the session.")
    @JsonProperty(value="divisionIds")
    public List<String> getDivisionIds() {
        return this.divisionIds;
    }

    public void setDivisionIds(List<String> divisionIds) {
        this.divisionIds = divisionIds;
    }

    public Session lastScreen(String lastScreen) {
        this.lastScreen = lastScreen;
        return this;
    }

    @ApiModelProperty(example="null", value="The app screen name where the customer's last app interaction occurred.")
    @JsonProperty(value="lastScreen")
    public String getLastScreen() {
        return this.lastScreen;
    }

    public void setLastScreen(String lastScreen) {
        this.lastScreen = lastScreen;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public Session createdDate(Date createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Timestamp indicating when the session was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="createdDate")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Session endedDate(Date endedDate) {
        this.endedDate = endedDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp indicating when the session was ended. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="endedDate")
    public Date getEndedDate() {
        return this.endedDate;
    }

    public void setEndedDate(Date endedDate) {
        this.endedDate = endedDate;
    }

    @ApiModelProperty(example="null", value="The external contact associated with this session.")
    @JsonProperty(value="externalContact")
    public AddressableEntityRef getExternalContact() {
        return this.externalContact;
    }

    public Session awayDate(Date awayDate) {
        this.awayDate = awayDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp indicating when the visitor should be considered as away. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="awayDate")
    public Date getAwayDate() {
        return this.awayDate;
    }

    public void setAwayDate(Date awayDate) {
        this.awayDate = awayDate;
    }

    public Session idleDate(Date idleDate) {
        this.idleDate = idleDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Timestamp indicating when the visitor should be considered as idle. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="idleDate")
    public Date getIdleDate() {
        return this.idleDate;
    }

    public void setIdleDate(Date idleDate) {
        this.idleDate = idleDate;
    }

    @ApiModelProperty(example="null", value="The conversation for this session.")
    @JsonProperty(value="conversation")
    public AddressableEntityRef getConversation() {
        return this.conversation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session session = (Session)o;
        return Objects.equals(this.id, session.id) && Objects.equals(this.customerId, session.customerId) && Objects.equals(this.customerIdType, session.customerIdType) && Objects.equals(this.type, session.type) && Objects.equals(this.externalId, session.externalId) && Objects.equals(this.externalUrl, session.externalUrl) && Objects.equals(this.shortId, session.shortId) && Objects.equals(this.outcomeAchievements, session.outcomeAchievements) && Objects.equals(this.segmentAssignments, session.segmentAssignments) && Objects.equals(this.attributes, session.attributes) && Objects.equals(this.attributeLists, session.attributeLists) && Objects.equals(this.browser, session.browser) && Objects.equals(this.device, session.device) && Objects.equals(this.geolocation, session.geolocation) && Objects.equals(this.ipAddress, session.ipAddress) && Objects.equals(this.ipOrganization, session.ipOrganization) && Objects.equals(this.lastPage, session.lastPage) && Objects.equals(this.mktCampaign, session.mktCampaign) && Objects.equals(this.referrer, session.referrer) && Objects.equals(this.app, session.app) && Objects.equals(this.sdkLibrary, session.sdkLibrary) && Objects.equals(this.networkConnectivity, session.networkConnectivity) && Objects.equals(this.searchTerms, session.searchTerms) && Objects.equals(this.userAgentString, session.userAgentString) && Objects.equals(this.durationInSeconds, session.durationInSeconds) && Objects.equals(this.eventCount, session.eventCount) && Objects.equals(this.pageviewCount, session.pageviewCount) && Objects.equals(this.screenviewCount, session.screenviewCount) && Objects.equals(this.lastEvent, session.lastEvent) && Objects.equals(this.lastConnectedQueue, session.lastConnectedQueue) && Objects.equals(this.lastConnectedUser, session.lastConnectedUser) && Objects.equals(this.lastUserDisposition, session.lastUserDisposition) && Objects.equals(this.conversationChannels, session.conversationChannels) && Objects.equals((Object)this.originatingDirection, (Object)session.originatingDirection) && Objects.equals(this.conversationSubject, session.conversationSubject) && Objects.equals((Object)this.lastUserDisconnectType, (Object)session.lastUserDisconnectType) && Objects.equals((Object)this.lastAcdOutcome, (Object)session.lastAcdOutcome) && Objects.equals(this.authenticated, session.authenticated) && Objects.equals(this.divisionIds, session.divisionIds) && Objects.equals(this.lastScreen, session.lastScreen) && Objects.equals(this.selfUri, session.selfUri) && Objects.equals(this.createdDate, session.createdDate) && Objects.equals(this.endedDate, session.endedDate) && Objects.equals(this.externalContact, session.externalContact) && Objects.equals(this.awayDate, session.awayDate) && Objects.equals(this.idleDate, session.idleDate) && Objects.equals(this.conversation, session.conversation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.customerId, this.customerIdType, this.type, this.externalId, this.externalUrl, this.shortId, this.outcomeAchievements, this.segmentAssignments, this.attributes, this.attributeLists, this.browser, this.device, this.geolocation, this.ipAddress, this.ipOrganization, this.lastPage, this.mktCampaign, this.referrer, this.app, this.sdkLibrary, this.networkConnectivity, this.searchTerms, this.userAgentString, this.durationInSeconds, this.eventCount, this.pageviewCount, this.screenviewCount, this.lastEvent, this.lastConnectedQueue, this.lastConnectedUser, this.lastUserDisposition, this.conversationChannels, this.originatingDirection, this.conversationSubject, this.lastUserDisconnectType, this.lastAcdOutcome, this.authenticated, this.divisionIds, this.lastScreen, this.selfUri, this.createdDate, this.endedDate, this.externalContact, this.awayDate, this.idleDate, this.conversation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Session {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    customerIdType: ").append(this.toIndentedString(this.customerIdType)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    externalUrl: ").append(this.toIndentedString(this.externalUrl)).append("\n");
        sb.append("    shortId: ").append(this.toIndentedString(this.shortId)).append("\n");
        sb.append("    outcomeAchievements: ").append(this.toIndentedString(this.outcomeAchievements)).append("\n");
        sb.append("    segmentAssignments: ").append(this.toIndentedString(this.segmentAssignments)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    attributeLists: ").append(this.toIndentedString(this.attributeLists)).append("\n");
        sb.append("    browser: ").append(this.toIndentedString(this.browser)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    geolocation: ").append(this.toIndentedString(this.geolocation)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    ipOrganization: ").append(this.toIndentedString(this.ipOrganization)).append("\n");
        sb.append("    lastPage: ").append(this.toIndentedString(this.lastPage)).append("\n");
        sb.append("    mktCampaign: ").append(this.toIndentedString(this.mktCampaign)).append("\n");
        sb.append("    referrer: ").append(this.toIndentedString(this.referrer)).append("\n");
        sb.append("    app: ").append(this.toIndentedString(this.app)).append("\n");
        sb.append("    sdkLibrary: ").append(this.toIndentedString(this.sdkLibrary)).append("\n");
        sb.append("    networkConnectivity: ").append(this.toIndentedString(this.networkConnectivity)).append("\n");
        sb.append("    searchTerms: ").append(this.toIndentedString(this.searchTerms)).append("\n");
        sb.append("    userAgentString: ").append(this.toIndentedString(this.userAgentString)).append("\n");
        sb.append("    durationInSeconds: ").append(this.toIndentedString(this.durationInSeconds)).append("\n");
        sb.append("    eventCount: ").append(this.toIndentedString(this.eventCount)).append("\n");
        sb.append("    pageviewCount: ").append(this.toIndentedString(this.pageviewCount)).append("\n");
        sb.append("    screenviewCount: ").append(this.toIndentedString(this.screenviewCount)).append("\n");
        sb.append("    lastEvent: ").append(this.toIndentedString(this.lastEvent)).append("\n");
        sb.append("    lastConnectedQueue: ").append(this.toIndentedString(this.lastConnectedQueue)).append("\n");
        sb.append("    lastConnectedUser: ").append(this.toIndentedString(this.lastConnectedUser)).append("\n");
        sb.append("    lastUserDisposition: ").append(this.toIndentedString(this.lastUserDisposition)).append("\n");
        sb.append("    conversationChannels: ").append(this.toIndentedString(this.conversationChannels)).append("\n");
        sb.append("    originatingDirection: ").append(this.toIndentedString((Object)this.originatingDirection)).append("\n");
        sb.append("    conversationSubject: ").append(this.toIndentedString(this.conversationSubject)).append("\n");
        sb.append("    lastUserDisconnectType: ").append(this.toIndentedString((Object)this.lastUserDisconnectType)).append("\n");
        sb.append("    lastAcdOutcome: ").append(this.toIndentedString((Object)this.lastAcdOutcome)).append("\n");
        sb.append("    authenticated: ").append(this.toIndentedString(this.authenticated)).append("\n");
        sb.append("    divisionIds: ").append(this.toIndentedString(this.divisionIds)).append("\n");
        sb.append("    lastScreen: ").append(this.toIndentedString(this.lastScreen)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    endedDate: ").append(this.toIndentedString(this.endedDate)).append("\n");
        sb.append("    externalContact: ").append(this.toIndentedString(this.externalContact)).append("\n");
        sb.append("    awayDate: ").append(this.toIndentedString(this.awayDate)).append("\n");
        sb.append("    idleDate: ").append(this.toIndentedString(this.idleDate)).append("\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OriginatingDirectionEnumDeserializer.class)
    public static enum OriginatingDirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        INBOUND("Inbound"),
        OUTBOUND("Outbound");

        private String value;

        private OriginatingDirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OriginatingDirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OriginatingDirectionEnum value : OriginatingDirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OriginatingDirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=LastUserDisconnectTypeEnumDeserializer.class)
    public static enum LastUserDisconnectTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        ENDPOINT("Endpoint"),
        CLIENT("Client"),
        SYSTEM("System"),
        TRANSFER("Transfer"),
        ERROR("Error"),
        PEER("Peer"),
        OTHER("Other"),
        SPAM("Spam"),
        TIMEOUT("Timeout"),
        TRANSPORTFAILURE("TransportFailure"),
        CONFERENCETRANSFER("ConferenceTransfer"),
        CONSULTTRANSFER("ConsultTransfer"),
        FORWARDTRANSFER("ForwardTransfer"),
        NOANSWERTRANSFER("NoAnswerTransfer"),
        NOTAVAILABLETRANSFER("NotAvailableTransfer"),
        UNCALLABLE("Uncallable"),
        DONOTDISTURBENDPOINT("DoNotDisturbEndpoint"),
        DONOTDISTURBTRANSFER("DoNotDisturbTransfer");

        private String value;

        private LastUserDisconnectTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LastUserDisconnectTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (LastUserDisconnectTypeEnum value : LastUserDisconnectTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return LastUserDisconnectTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=LastAcdOutcomeEnumDeserializer.class)
    public static enum LastAcdOutcomeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNKNOWN("Unknown"),
        ABANDON("Abandon"),
        ANSWERED("Answered"),
        FLOWOUT("FlowOut");

        private String value;

        private LastAcdOutcomeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LastAcdOutcomeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (LastAcdOutcomeEnum value : LastAcdOutcomeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return LastAcdOutcomeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class LastAcdOutcomeEnumDeserializer
    extends StdDeserializer<LastAcdOutcomeEnum> {
        public LastAcdOutcomeEnumDeserializer() {
            super(LastAcdOutcomeEnumDeserializer.class);
        }

        public LastAcdOutcomeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return LastAcdOutcomeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class LastUserDisconnectTypeEnumDeserializer
    extends StdDeserializer<LastUserDisconnectTypeEnum> {
        public LastUserDisconnectTypeEnumDeserializer() {
            super(LastUserDisconnectTypeEnumDeserializer.class);
        }

        public LastUserDisconnectTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return LastUserDisconnectTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class OriginatingDirectionEnumDeserializer
    extends StdDeserializer<OriginatingDirectionEnum> {
        public OriginatingDirectionEnumDeserializer() {
            super(OriginatingDirectionEnumDeserializer.class);
        }

        public OriginatingDirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OriginatingDirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

