/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class ShiftTradeNotification
implements Serializable {
    private String weekDate = null;
    private String tradeId = null;
    private Boolean oneSided = null;
    private NewStateEnum newState = null;
    private UserReference initiatingUser = null;
    private Date initiatingShiftDate = null;
    private UserReference receivingUser = null;
    private Date receivingShiftDate = null;

    public ShiftTradeNotification weekDate(String weekDate) {
        this.weekDate = weekDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The start week date of the initiating shift of the shift trade in yyyy-MM-dd format")
    @JsonProperty(value="weekDate")
    public String getWeekDate() {
        return this.weekDate;
    }

    public void setWeekDate(String weekDate) {
        this.weekDate = weekDate;
    }

    public ShiftTradeNotification tradeId(String tradeId) {
        this.tradeId = tradeId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the shift trade")
    @JsonProperty(value="tradeId")
    public String getTradeId() {
        return this.tradeId;
    }

    public void setTradeId(String tradeId) {
        this.tradeId = tradeId;
    }

    public ShiftTradeNotification oneSided(Boolean oneSided) {
        this.oneSided = oneSided;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this is a one sided shift trade")
    @JsonProperty(value="oneSided")
    public Boolean getOneSided() {
        return this.oneSided;
    }

    public void setOneSided(Boolean oneSided) {
        this.oneSided = oneSided;
    }

    public ShiftTradeNotification newState(NewStateEnum newState) {
        this.newState = newState;
        return this;
    }

    @ApiModelProperty(example="null", value="The new state of the shift trade, null if there was no change")
    @JsonProperty(value="newState")
    public NewStateEnum getNewState() {
        return this.newState;
    }

    public void setNewState(NewStateEnum newState) {
        this.newState = newState;
    }

    public ShiftTradeNotification initiatingUser(UserReference initiatingUser) {
        this.initiatingUser = initiatingUser;
        return this;
    }

    @ApiModelProperty(example="null", value="The user who initiated the shift trade")
    @JsonProperty(value="initiatingUser")
    public UserReference getInitiatingUser() {
        return this.initiatingUser;
    }

    public void setInitiatingUser(UserReference initiatingUser) {
        this.initiatingUser = initiatingUser;
    }

    public ShiftTradeNotification initiatingShiftDate(Date initiatingShiftDate) {
        this.initiatingShiftDate = initiatingShiftDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The start date and time of the initiating shift. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="initiatingShiftDate")
    public Date getInitiatingShiftDate() {
        return this.initiatingShiftDate;
    }

    public void setInitiatingShiftDate(Date initiatingShiftDate) {
        this.initiatingShiftDate = initiatingShiftDate;
    }

    public ShiftTradeNotification receivingUser(UserReference receivingUser) {
        this.receivingUser = receivingUser;
        return this;
    }

    @ApiModelProperty(example="null", value="The user on the receiving side of this shift trade (null if not matched)")
    @JsonProperty(value="receivingUser")
    public UserReference getReceivingUser() {
        return this.receivingUser;
    }

    public void setReceivingUser(UserReference receivingUser) {
        this.receivingUser = receivingUser;
    }

    public ShiftTradeNotification receivingShiftDate(Date receivingShiftDate) {
        this.receivingShiftDate = receivingShiftDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The start date and time of the receiving shift (null if not matched or if one-sided. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="receivingShiftDate")
    public Date getReceivingShiftDate() {
        return this.receivingShiftDate;
    }

    public void setReceivingShiftDate(Date receivingShiftDate) {
        this.receivingShiftDate = receivingShiftDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShiftTradeNotification shiftTradeNotification = (ShiftTradeNotification)o;
        return Objects.equals(this.weekDate, shiftTradeNotification.weekDate) && Objects.equals(this.tradeId, shiftTradeNotification.tradeId) && Objects.equals(this.oneSided, shiftTradeNotification.oneSided) && Objects.equals((Object)this.newState, (Object)shiftTradeNotification.newState) && Objects.equals(this.initiatingUser, shiftTradeNotification.initiatingUser) && Objects.equals(this.initiatingShiftDate, shiftTradeNotification.initiatingShiftDate) && Objects.equals(this.receivingUser, shiftTradeNotification.receivingUser) && Objects.equals(this.receivingShiftDate, shiftTradeNotification.receivingShiftDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.weekDate, this.tradeId, this.oneSided, this.newState, this.initiatingUser, this.initiatingShiftDate, this.receivingUser, this.receivingShiftDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShiftTradeNotification {\n");
        sb.append("    weekDate: ").append(this.toIndentedString(this.weekDate)).append("\n");
        sb.append("    tradeId: ").append(this.toIndentedString(this.tradeId)).append("\n");
        sb.append("    oneSided: ").append(this.toIndentedString(this.oneSided)).append("\n");
        sb.append("    newState: ").append(this.toIndentedString((Object)this.newState)).append("\n");
        sb.append("    initiatingUser: ").append(this.toIndentedString(this.initiatingUser)).append("\n");
        sb.append("    initiatingShiftDate: ").append(this.toIndentedString(this.initiatingShiftDate)).append("\n");
        sb.append("    receivingUser: ").append(this.toIndentedString(this.receivingUser)).append("\n");
        sb.append("    receivingShiftDate: ").append(this.toIndentedString(this.receivingShiftDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=NewStateEnumDeserializer.class)
    public static enum NewStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNMATCHED("Unmatched"),
        MATCHED("Matched"),
        APPROVED("Approved"),
        DENIED("Denied"),
        EXPIRED("Expired"),
        CANCELED("Canceled");

        private String value;

        private NewStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static NewStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (NewStateEnum value : NewStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return NewStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class NewStateEnumDeserializer
    extends StdDeserializer<NewStateEnum> {
        public NewStateEnumDeserializer() {
            super(NewStateEnumDeserializer.class);
        }

        public NewStateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return NewStateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

