/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ContactBulkSearchCriteria;
import com.mypurecloud.sdk.v2.model.ContactSort;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ContactListingRequest
implements Serializable {
    private String contactListFilterId = null;
    private ContactBulkSearchCriteria criteria = null;
    private Integer pageNumber = null;
    private Integer pageSize = null;
    private List<ContactSort> contactSorts = new ArrayList<ContactSort>();

    public ContactListingRequest contactListFilterId(String contactListFilterId) {
        this.contactListFilterId = contactListFilterId;
        return this;
    }

    @ApiModelProperty(example="null", value="Contact List Filter ID.")
    @JsonProperty(value="contactListFilterId")
    public String getContactListFilterId() {
        return this.contactListFilterId;
    }

    public void setContactListFilterId(String contactListFilterId) {
        this.contactListFilterId = contactListFilterId;
    }

    public ContactListingRequest criteria(ContactBulkSearchCriteria criteria) {
        this.criteria = criteria;
        return this;
    }

    @ApiModelProperty(example="null", value="Criteria to filter the contacts by.")
    @JsonProperty(value="criteria")
    public ContactBulkSearchCriteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(ContactBulkSearchCriteria criteria) {
        this.criteria = criteria;
    }

    public ContactListingRequest pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Page number.")
    @JsonProperty(value="pageNumber")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public ContactListingRequest pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Page size. The max that will be returned is 100.")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public ContactListingRequest contactSorts(List<ContactSort> contactSorts) {
        this.contactSorts = contactSorts;
        return this;
    }

    @ApiModelProperty(example="null", value="The order in which to sort contacts.")
    @JsonProperty(value="contactSorts")
    public List<ContactSort> getContactSorts() {
        return this.contactSorts;
    }

    public void setContactSorts(List<ContactSort> contactSorts) {
        this.contactSorts = contactSorts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactListingRequest contactListingRequest = (ContactListingRequest)o;
        return Objects.equals(this.contactListFilterId, contactListingRequest.contactListFilterId) && Objects.equals(this.criteria, contactListingRequest.criteria) && Objects.equals(this.pageNumber, contactListingRequest.pageNumber) && Objects.equals(this.pageSize, contactListingRequest.pageSize) && Objects.equals(this.contactSorts, contactListingRequest.contactSorts);
    }

    public int hashCode() {
        return Objects.hash(this.contactListFilterId, this.criteria, this.pageNumber, this.pageSize, this.contactSorts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContactListingRequest {\n");
        sb.append("    contactListFilterId: ").append(this.toIndentedString(this.contactListFilterId)).append("\n");
        sb.append("    criteria: ").append(this.toIndentedString(this.criteria)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    contactSorts: ").append(this.toIndentedString(this.contactSorts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

