/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteEmployeeengagementCelebrationRequest;
import com.mypurecloud.sdk.v2.api.request.GetEmployeeengagementCelebrationsRequest;
import com.mypurecloud.sdk.v2.api.request.GetEmployeeengagementRecognitionRequest;
import com.mypurecloud.sdk.v2.api.request.PatchEmployeeengagementCelebrationRequest;
import com.mypurecloud.sdk.v2.api.request.PostEmployeeengagementRecognitionsRequest;
import com.mypurecloud.sdk.v2.model.CelebrationStateParam;
import com.mypurecloud.sdk.v2.model.CreateRecognition;
import com.mypurecloud.sdk.v2.model.GetCelebrationListing;
import com.mypurecloud.sdk.v2.model.Recognition;
import com.mypurecloud.sdk.v2.model.RecognitionBase;
import java.io.IOException;

public class EmployeeEngagementApi {
    private final ApiClient pcapiClient;

    public EmployeeEngagementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EmployeeEngagementApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteEmployeeengagementCelebration(String celebrationId) throws IOException, ApiException {
        this.deleteEmployeeengagementCelebration(this.createDeleteEmployeeengagementCelebrationRequest(celebrationId));
    }

    public ApiResponse<Void> deleteEmployeeengagementCelebrationWithHttpInfo(String celebrationId) throws IOException {
        return this.deleteEmployeeengagementCelebration(this.createDeleteEmployeeengagementCelebrationRequest(celebrationId).withHttpInfo());
    }

    private DeleteEmployeeengagementCelebrationRequest createDeleteEmployeeengagementCelebrationRequest(String celebrationId) {
        return DeleteEmployeeengagementCelebrationRequest.builder().withCelebrationId(celebrationId).build();
    }

    public void deleteEmployeeengagementCelebration(DeleteEmployeeengagementCelebrationRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteEmployeeengagementCelebration(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GetCelebrationListing getEmployeeengagementCelebrations(Integer pageNumber, Integer pageSize) throws IOException, ApiException {
        return this.getEmployeeengagementCelebrations(this.createGetEmployeeengagementCelebrationsRequest(pageNumber, pageSize));
    }

    public ApiResponse<GetCelebrationListing> getEmployeeengagementCelebrationsWithHttpInfo(Integer pageNumber, Integer pageSize) throws IOException {
        return this.getEmployeeengagementCelebrations(this.createGetEmployeeengagementCelebrationsRequest(pageNumber, pageSize).withHttpInfo());
    }

    private GetEmployeeengagementCelebrationsRequest createGetEmployeeengagementCelebrationsRequest(Integer pageNumber, Integer pageSize) {
        return GetEmployeeengagementCelebrationsRequest.builder().withPageNumber(pageNumber).withPageSize(pageSize).build();
    }

    public GetCelebrationListing getEmployeeengagementCelebrations(GetEmployeeengagementCelebrationsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GetCelebrationListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GetCelebrationListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GetCelebrationListing> getEmployeeengagementCelebrations(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GetCelebrationListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Recognition getEmployeeengagementRecognition(String recognitionId) throws IOException, ApiException {
        return this.getEmployeeengagementRecognition(this.createGetEmployeeengagementRecognitionRequest(recognitionId));
    }

    public ApiResponse<Recognition> getEmployeeengagementRecognitionWithHttpInfo(String recognitionId) throws IOException {
        return this.getEmployeeengagementRecognition(this.createGetEmployeeengagementRecognitionRequest(recognitionId).withHttpInfo());
    }

    private GetEmployeeengagementRecognitionRequest createGetEmployeeengagementRecognitionRequest(String recognitionId) {
        return GetEmployeeengagementRecognitionRequest.builder().withRecognitionId(recognitionId).build();
    }

    public Recognition getEmployeeengagementRecognition(GetEmployeeengagementRecognitionRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Recognition> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Recognition>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Recognition> getEmployeeengagementRecognition(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Recognition>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void patchEmployeeengagementCelebration(String celebrationId, CelebrationStateParam body) throws IOException, ApiException {
        this.patchEmployeeengagementCelebration(this.createPatchEmployeeengagementCelebrationRequest(celebrationId, body));
    }

    public ApiResponse<Void> patchEmployeeengagementCelebrationWithHttpInfo(String celebrationId, CelebrationStateParam body) throws IOException {
        return this.patchEmployeeengagementCelebration(this.createPatchEmployeeengagementCelebrationRequest(celebrationId, body).withHttpInfo());
    }

    private PatchEmployeeengagementCelebrationRequest createPatchEmployeeengagementCelebrationRequest(String celebrationId, CelebrationStateParam body) {
        return PatchEmployeeengagementCelebrationRequest.builder().withCelebrationId(celebrationId).withBody(body).build();
    }

    public void patchEmployeeengagementCelebration(PatchEmployeeengagementCelebrationRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> patchEmployeeengagementCelebration(ApiRequest<CelebrationStateParam> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public RecognitionBase postEmployeeengagementRecognitions(CreateRecognition body) throws IOException, ApiException {
        return this.postEmployeeengagementRecognitions(this.createPostEmployeeengagementRecognitionsRequest(body));
    }

    public ApiResponse<RecognitionBase> postEmployeeengagementRecognitionsWithHttpInfo(CreateRecognition body) throws IOException {
        return this.postEmployeeengagementRecognitions(this.createPostEmployeeengagementRecognitionsRequest(body).withHttpInfo());
    }

    private PostEmployeeengagementRecognitionsRequest createPostEmployeeengagementRecognitionsRequest(CreateRecognition body) {
        return PostEmployeeengagementRecognitionsRequest.builder().withBody(body).build();
    }

    public RecognitionBase postEmployeeengagementRecognitions(PostEmployeeengagementRecognitionsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<RecognitionBase> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<RecognitionBase>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<RecognitionBase> postEmployeeengagementRecognitions(ApiRequest<CreateRecognition> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<RecognitionBase>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

