/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ActivityCodeReference;
import com.mypurecloud.sdk.v2.model.ManagementUnitReference;
import com.mypurecloud.sdk.v2.model.RecurrenceSettings;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ActivityPlanListItem
implements Serializable {
    private String id = null;
    private String name = null;
    private List<ManagementUnitReference> managementUnits = new ArrayList<ManagementUnitReference>();
    private String description = null;
    private ActivityCodeReference activityCode = null;
    private TypeEnum type = null;
    private OptimizationObjectiveEnum optimizationObjective = null;
    private RecurrenceSettings recurrenceSettings = null;
    private StateEnum state = null;
    private Date lastRunDate = null;
    private UserReference lastRunBy = null;
    private Date createdDate = null;
    private UserReference createdBy = null;
    private Date modifiedDate = null;
    private UserReference modifiedBy = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ActivityPlanListItem name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the activity plan")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ActivityPlanListItem managementUnits(List<ManagementUnitReference> managementUnits) {
        this.managementUnits = managementUnits;
        return this;
    }

    @ApiModelProperty(example="null", value="The management units to which this activity plan applies. Empty list or null means this activity plan applies to all management units in the business unit")
    @JsonProperty(value="managementUnits")
    public List<ManagementUnitReference> getManagementUnits() {
        return this.managementUnits;
    }

    public void setManagementUnits(List<ManagementUnitReference> managementUnits) {
        this.managementUnits = managementUnits;
    }

    public ActivityPlanListItem description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The description of this activity plan")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ActivityPlanListItem activityCode(ActivityCodeReference activityCode) {
        this.activityCode = activityCode;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The activity code to which this activity plan applies. Note: It is recommended to load and cache the entire list of activity codes rather than look up individual codes")
    @JsonProperty(value="activityCode")
    public ActivityCodeReference getActivityCode() {
        return this.activityCode;
    }

    public void setActivityCode(ActivityCodeReference activityCode) {
        this.activityCode = activityCode;
    }

    public ActivityPlanListItem type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of the activity plan")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ActivityPlanListItem optimizationObjective(OptimizationObjectiveEnum optimizationObjective) {
        this.optimizationObjective = optimizationObjective;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The optimization objective of this activity plan")
    @JsonProperty(value="optimizationObjective")
    public OptimizationObjectiveEnum getOptimizationObjective() {
        return this.optimizationObjective;
    }

    public void setOptimizationObjective(OptimizationObjectiveEnum optimizationObjective) {
        this.optimizationObjective = optimizationObjective;
    }

    public ActivityPlanListItem recurrenceSettings(RecurrenceSettings recurrenceSettings) {
        this.recurrenceSettings = recurrenceSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="Recurrence settings for this activity plan")
    @JsonProperty(value="recurrenceSettings")
    public RecurrenceSettings getRecurrenceSettings() {
        return this.recurrenceSettings;
    }

    public void setRecurrenceSettings(RecurrenceSettings recurrenceSettings) {
        this.recurrenceSettings = recurrenceSettings;
    }

    public ActivityPlanListItem state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The state of this activity plan")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public ActivityPlanListItem lastRunDate(Date lastRunDate) {
        this.lastRunDate = lastRunDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the activity plan was last run, in ISO-8601 format")
    @JsonProperty(value="lastRunDate")
    public Date getLastRunDate() {
        return this.lastRunDate;
    }

    public void setLastRunDate(Date lastRunDate) {
        this.lastRunDate = lastRunDate;
    }

    public ActivityPlanListItem lastRunBy(UserReference lastRunBy) {
        this.lastRunBy = lastRunBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The last user to run this activity plan")
    @JsonProperty(value="lastRunBy")
    public UserReference getLastRunBy() {
        return this.lastRunBy;
    }

    public void setLastRunBy(UserReference lastRunBy) {
        this.lastRunBy = lastRunBy;
    }

    public ActivityPlanListItem createdDate(Date createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The date the activity plan was created, in ISO-8601 format")
    @JsonProperty(value="createdDate")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public ActivityPlanListItem createdBy(UserReference createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The user who created this activity plan")
    @JsonProperty(value="createdBy")
    public UserReference getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(UserReference createdBy) {
        this.createdBy = createdBy;
    }

    public ActivityPlanListItem modifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The date the activity plan was modified, in ISO-8601 format")
    @JsonProperty(value="modifiedDate")
    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public ActivityPlanListItem modifiedBy(UserReference modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The last user to modify this activity plan")
    @JsonProperty(value="modifiedBy")
    public UserReference getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(UserReference modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityPlanListItem activityPlanListItem = (ActivityPlanListItem)o;
        return Objects.equals(this.id, activityPlanListItem.id) && Objects.equals(this.name, activityPlanListItem.name) && Objects.equals(this.managementUnits, activityPlanListItem.managementUnits) && Objects.equals(this.description, activityPlanListItem.description) && Objects.equals(this.activityCode, activityPlanListItem.activityCode) && Objects.equals((Object)this.type, (Object)activityPlanListItem.type) && Objects.equals((Object)this.optimizationObjective, (Object)activityPlanListItem.optimizationObjective) && Objects.equals(this.recurrenceSettings, activityPlanListItem.recurrenceSettings) && Objects.equals((Object)this.state, (Object)activityPlanListItem.state) && Objects.equals(this.lastRunDate, activityPlanListItem.lastRunDate) && Objects.equals(this.lastRunBy, activityPlanListItem.lastRunBy) && Objects.equals(this.createdDate, activityPlanListItem.createdDate) && Objects.equals(this.createdBy, activityPlanListItem.createdBy) && Objects.equals(this.modifiedDate, activityPlanListItem.modifiedDate) && Objects.equals(this.modifiedBy, activityPlanListItem.modifiedBy) && Objects.equals(this.selfUri, activityPlanListItem.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.managementUnits, this.description, this.activityCode, this.type, this.optimizationObjective, this.recurrenceSettings, this.state, this.lastRunDate, this.lastRunBy, this.createdDate, this.createdBy, this.modifiedDate, this.modifiedBy, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivityPlanListItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    managementUnits: ").append(this.toIndentedString(this.managementUnits)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    activityCode: ").append(this.toIndentedString(this.activityCode)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    optimizationObjective: ").append(this.toIndentedString((Object)this.optimizationObjective)).append("\n");
        sb.append("    recurrenceSettings: ").append(this.toIndentedString(this.recurrenceSettings)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    lastRunDate: ").append(this.toIndentedString(this.lastRunDate)).append("\n");
        sb.append("    lastRunBy: ").append(this.toIndentedString(this.lastRunBy)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    modifiedDate: ").append(this.toIndentedString(this.modifiedDate)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INDIVIDUAL("Individual"),
        GROUP("Group");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=OptimizationObjectiveEnumDeserializer.class)
    public static enum OptimizationObjectiveEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        FAVORSERVICEGOALS("FavorServiceGoals"),
        FAVORSCHEDULINGALL("FavorSchedulingAll");

        private String value;

        private OptimizationObjectiveEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OptimizationObjectiveEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OptimizationObjectiveEnum value : OptimizationObjectiveEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OptimizationObjectiveEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("Active"),
        INACTIVE("Inactive");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class OptimizationObjectiveEnumDeserializer
    extends StdDeserializer<OptimizationObjectiveEnum> {
        public OptimizationObjectiveEnumDeserializer() {
            super(OptimizationObjectiveEnumDeserializer.class);
        }

        public OptimizationObjectiveEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OptimizationObjectiveEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

