/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.OAuthClientRequest;
import java.util.HashMap;
import java.util.Map;

public class PostOauthClientsRequest {
    private OAuthClientRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public OAuthClientRequest getBody() {
        return this.body;
    }

    public void setBody(OAuthClientRequest body) {
        this.body = body;
    }

    public PostOauthClientsRequest withBody(OAuthClientRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostOauthClientsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<OAuthClientRequest> withHttpInfo() {
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostOauthClientsRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/oauth/clients").withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OAuthClientRequest body) {
        return new Builder().withRequiredParams(body);
    }

    public static class Builder {
        private final PostOauthClientsRequest request = new PostOauthClientsRequest();

        private Builder() {
        }

        public Builder withBody(OAuthClientRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(OAuthClientRequest body) {
            this.request.setBody(body);
            return this;
        }

        public PostOauthClientsRequest build() {
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostOauthClientsRequest.");
            }
            return this.request;
        }
    }
}

