/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetOauthClientUsageQueryResultRequest;
import com.mypurecloud.sdk.v2.api.request.GetOauthClientUsageSummaryRequest;
import com.mypurecloud.sdk.v2.api.request.GetUsageQueryExecutionIdResultsRequest;
import com.mypurecloud.sdk.v2.api.request.GetUsageSimplesearchExecutionIdResultsRequest;
import com.mypurecloud.sdk.v2.api.request.PostOauthClientUsageQueryRequest;
import com.mypurecloud.sdk.v2.api.request.PostUsageQueryRequest;
import com.mypurecloud.sdk.v2.api.request.PostUsageSimplesearchRequest;
import com.mypurecloud.sdk.v2.model.ApiUsageClientQuery;
import com.mypurecloud.sdk.v2.model.ApiUsageOrganizationQuery;
import com.mypurecloud.sdk.v2.model.ApiUsageQueryResult;
import com.mypurecloud.sdk.v2.model.ApiUsageSimpleSearch;
import com.mypurecloud.sdk.v2.model.UsageExecutionResult;
import java.io.IOException;

public class UsageApi {
    private final ApiClient pcapiClient;

    public UsageApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsageApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public ApiUsageQueryResult getOauthClientUsageQueryResult(String executionId, String clientId) throws IOException, ApiException {
        return this.getOauthClientUsageQueryResult(this.createGetOauthClientUsageQueryResultRequest(executionId, clientId));
    }

    public ApiResponse<ApiUsageQueryResult> getOauthClientUsageQueryResultWithHttpInfo(String executionId, String clientId) throws IOException {
        return this.getOauthClientUsageQueryResult(this.createGetOauthClientUsageQueryResultRequest(executionId, clientId).withHttpInfo());
    }

    private GetOauthClientUsageQueryResultRequest createGetOauthClientUsageQueryResultRequest(String executionId, String clientId) {
        return GetOauthClientUsageQueryResultRequest.builder().withExecutionId(executionId).withClientId(clientId).build();
    }

    public ApiUsageQueryResult getOauthClientUsageQueryResult(GetOauthClientUsageQueryResultRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ApiUsageQueryResult> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ApiUsageQueryResult>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ApiUsageQueryResult> getOauthClientUsageQueryResult(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ApiUsageQueryResult>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UsageExecutionResult getOauthClientUsageSummary(String clientId, String days) throws IOException, ApiException {
        return this.getOauthClientUsageSummary(this.createGetOauthClientUsageSummaryRequest(clientId, days));
    }

    public ApiResponse<UsageExecutionResult> getOauthClientUsageSummaryWithHttpInfo(String clientId, String days) throws IOException {
        return this.getOauthClientUsageSummary(this.createGetOauthClientUsageSummaryRequest(clientId, days).withHttpInfo());
    }

    private GetOauthClientUsageSummaryRequest createGetOauthClientUsageSummaryRequest(String clientId, String days) {
        return GetOauthClientUsageSummaryRequest.builder().withClientId(clientId).withDays(days).build();
    }

    public UsageExecutionResult getOauthClientUsageSummary(GetOauthClientUsageSummaryRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UsageExecutionResult> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UsageExecutionResult>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UsageExecutionResult> getOauthClientUsageSummary(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UsageExecutionResult>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ApiUsageQueryResult getUsageQueryExecutionIdResults(String executionId) throws IOException, ApiException {
        return this.getUsageQueryExecutionIdResults(this.createGetUsageQueryExecutionIdResultsRequest(executionId));
    }

    public ApiResponse<ApiUsageQueryResult> getUsageQueryExecutionIdResultsWithHttpInfo(String executionId) throws IOException {
        return this.getUsageQueryExecutionIdResults(this.createGetUsageQueryExecutionIdResultsRequest(executionId).withHttpInfo());
    }

    private GetUsageQueryExecutionIdResultsRequest createGetUsageQueryExecutionIdResultsRequest(String executionId) {
        return GetUsageQueryExecutionIdResultsRequest.builder().withExecutionId(executionId).build();
    }

    public ApiUsageQueryResult getUsageQueryExecutionIdResults(GetUsageQueryExecutionIdResultsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ApiUsageQueryResult> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ApiUsageQueryResult>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ApiUsageQueryResult> getUsageQueryExecutionIdResults(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ApiUsageQueryResult>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ApiUsageQueryResult getUsageSimplesearchExecutionIdResults(String executionId, String after, Integer pageSize) throws IOException, ApiException {
        return this.getUsageSimplesearchExecutionIdResults(this.createGetUsageSimplesearchExecutionIdResultsRequest(executionId, after, pageSize));
    }

    public ApiResponse<ApiUsageQueryResult> getUsageSimplesearchExecutionIdResultsWithHttpInfo(String executionId, String after, Integer pageSize) throws IOException {
        return this.getUsageSimplesearchExecutionIdResults(this.createGetUsageSimplesearchExecutionIdResultsRequest(executionId, after, pageSize).withHttpInfo());
    }

    private GetUsageSimplesearchExecutionIdResultsRequest createGetUsageSimplesearchExecutionIdResultsRequest(String executionId, String after, Integer pageSize) {
        return GetUsageSimplesearchExecutionIdResultsRequest.builder().withExecutionId(executionId).withAfter(after).withPageSize(pageSize).build();
    }

    public ApiUsageQueryResult getUsageSimplesearchExecutionIdResults(GetUsageSimplesearchExecutionIdResultsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ApiUsageQueryResult> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ApiUsageQueryResult>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ApiUsageQueryResult> getUsageSimplesearchExecutionIdResults(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ApiUsageQueryResult>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UsageExecutionResult postOauthClientUsageQuery(String clientId, ApiUsageClientQuery body) throws IOException, ApiException {
        return this.postOauthClientUsageQuery(this.createPostOauthClientUsageQueryRequest(clientId, body));
    }

    public ApiResponse<UsageExecutionResult> postOauthClientUsageQueryWithHttpInfo(String clientId, ApiUsageClientQuery body) throws IOException {
        return this.postOauthClientUsageQuery(this.createPostOauthClientUsageQueryRequest(clientId, body).withHttpInfo());
    }

    private PostOauthClientUsageQueryRequest createPostOauthClientUsageQueryRequest(String clientId, ApiUsageClientQuery body) {
        return PostOauthClientUsageQueryRequest.builder().withClientId(clientId).withBody(body).build();
    }

    public UsageExecutionResult postOauthClientUsageQuery(PostOauthClientUsageQueryRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UsageExecutionResult> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UsageExecutionResult>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UsageExecutionResult> postOauthClientUsageQuery(ApiRequest<ApiUsageClientQuery> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UsageExecutionResult>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UsageExecutionResult postUsageQuery(ApiUsageOrganizationQuery body) throws IOException, ApiException {
        return this.postUsageQuery(this.createPostUsageQueryRequest(body));
    }

    public ApiResponse<UsageExecutionResult> postUsageQueryWithHttpInfo(ApiUsageOrganizationQuery body) throws IOException {
        return this.postUsageQuery(this.createPostUsageQueryRequest(body).withHttpInfo());
    }

    private PostUsageQueryRequest createPostUsageQueryRequest(ApiUsageOrganizationQuery body) {
        return PostUsageQueryRequest.builder().withBody(body).build();
    }

    public UsageExecutionResult postUsageQuery(PostUsageQueryRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UsageExecutionResult> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UsageExecutionResult>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UsageExecutionResult> postUsageQuery(ApiRequest<ApiUsageOrganizationQuery> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UsageExecutionResult>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UsageExecutionResult postUsageSimplesearch(ApiUsageSimpleSearch body) throws IOException, ApiException {
        return this.postUsageSimplesearch(this.createPostUsageSimplesearchRequest(body));
    }

    public ApiResponse<UsageExecutionResult> postUsageSimplesearchWithHttpInfo(ApiUsageSimpleSearch body) throws IOException {
        return this.postUsageSimplesearch(this.createPostUsageSimplesearchRequest(body).withHttpInfo());
    }

    private PostUsageSimplesearchRequest createPostUsageSimplesearchRequest(ApiUsageSimpleSearch body) {
        return PostUsageSimplesearchRequest.builder().withBody(body).build();
    }

    public UsageExecutionResult postUsageSimplesearch(PostUsageSimplesearchRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UsageExecutionResult> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UsageExecutionResult>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UsageExecutionResult> postUsageSimplesearch(ApiRequest<ApiUsageSimpleSearch> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UsageExecutionResult>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

