/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.BuScheduleReferenceForMuRoute;
import com.mypurecloud.sdk.v2.model.UserReference;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ShiftTradeResponse
implements Serializable {
    private String id = null;
    private LocalDate weekDate = null;
    private BuScheduleReferenceForMuRoute schedule = null;
    private StateEnum state = null;
    private UserReference initiatingUser = null;
    private String initiatingShiftId = null;
    private Date initiatingShiftStart = null;
    private Date initiatingShiftEnd = null;
    private UserReference receivingUser = null;
    private String receivingShiftId = null;
    private Date receivingShiftStart = null;
    private Date receivingShiftEnd = null;
    private Date expiration = null;
    private Boolean oneSided = null;
    private List<String> acceptableIntervals = new ArrayList<String>();
    private UserReference reviewedBy = null;
    private Date reviewedDate = null;
    private WfmVersionedEntityMetadata metadata = null;

    public ShiftTradeResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of this shift trade")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ShiftTradeResponse weekDate(LocalDate weekDate) {
        this.weekDate = weekDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The start week date of the initiating shift in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="weekDate")
    public LocalDate getWeekDate() {
        return this.weekDate;
    }

    public void setWeekDate(LocalDate weekDate) {
        this.weekDate = weekDate;
    }

    public ShiftTradeResponse schedule(BuScheduleReferenceForMuRoute schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(example="null", value="A reference to the associated schedule")
    @JsonProperty(value="schedule")
    public BuScheduleReferenceForMuRoute getSchedule() {
        return this.schedule;
    }

    public void setSchedule(BuScheduleReferenceForMuRoute schedule) {
        this.schedule = schedule;
    }

    public ShiftTradeResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The state of this shift trade")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public ShiftTradeResponse initiatingUser(UserReference initiatingUser) {
        this.initiatingUser = initiatingUser;
        return this;
    }

    @ApiModelProperty(example="null", value="The user who initiated this trade")
    @JsonProperty(value="initiatingUser")
    public UserReference getInitiatingUser() {
        return this.initiatingUser;
    }

    public void setInitiatingUser(UserReference initiatingUser) {
        this.initiatingUser = initiatingUser;
    }

    public ShiftTradeResponse initiatingShiftId(String initiatingShiftId) {
        this.initiatingShiftId = initiatingShiftId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the shift offered for trade by the initiating user")
    @JsonProperty(value="initiatingShiftId")
    public String getInitiatingShiftId() {
        return this.initiatingShiftId;
    }

    public void setInitiatingShiftId(String initiatingShiftId) {
        this.initiatingShiftId = initiatingShiftId;
    }

    public ShiftTradeResponse initiatingShiftStart(Date initiatingShiftStart) {
        this.initiatingShiftStart = initiatingShiftStart;
        return this;
    }

    @ApiModelProperty(example="null", value="The start date/time of the shift being offered for trade. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="initiatingShiftStart")
    public Date getInitiatingShiftStart() {
        return this.initiatingShiftStart;
    }

    public void setInitiatingShiftStart(Date initiatingShiftStart) {
        this.initiatingShiftStart = initiatingShiftStart;
    }

    public ShiftTradeResponse initiatingShiftEnd(Date initiatingShiftEnd) {
        this.initiatingShiftEnd = initiatingShiftEnd;
        return this;
    }

    @ApiModelProperty(example="null", value="The end date/time of the shift being offered for trade. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="initiatingShiftEnd")
    public Date getInitiatingShiftEnd() {
        return this.initiatingShiftEnd;
    }

    public void setInitiatingShiftEnd(Date initiatingShiftEnd) {
        this.initiatingShiftEnd = initiatingShiftEnd;
    }

    public ShiftTradeResponse receivingUser(UserReference receivingUser) {
        this.receivingUser = receivingUser;
        return this;
    }

    @ApiModelProperty(example="null", value="The user matching the trade, or if the state is not Matched, the user to whom the trade request was sent")
    @JsonProperty(value="receivingUser")
    public UserReference getReceivingUser() {
        return this.receivingUser;
    }

    public void setReceivingUser(UserReference receivingUser) {
        this.receivingUser = receivingUser;
    }

    public ShiftTradeResponse receivingShiftId(String receivingShiftId) {
        this.receivingShiftId = receivingShiftId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the shift being exchanged for the initiating shift, null if the receiving user is picking up a shift")
    @JsonProperty(value="receivingShiftId")
    public String getReceivingShiftId() {
        return this.receivingShiftId;
    }

    public void setReceivingShiftId(String receivingShiftId) {
        this.receivingShiftId = receivingShiftId;
    }

    public ShiftTradeResponse receivingShiftStart(Date receivingShiftStart) {
        this.receivingShiftStart = receivingShiftStart;
        return this;
    }

    @ApiModelProperty(example="null", value="The start date/time of the receiving shift. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="receivingShiftStart")
    public Date getReceivingShiftStart() {
        return this.receivingShiftStart;
    }

    public void setReceivingShiftStart(Date receivingShiftStart) {
        this.receivingShiftStart = receivingShiftStart;
    }

    public ShiftTradeResponse receivingShiftEnd(Date receivingShiftEnd) {
        this.receivingShiftEnd = receivingShiftEnd;
        return this;
    }

    @ApiModelProperty(example="null", value="The end date/time of the receiving shift. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="receivingShiftEnd")
    public Date getReceivingShiftEnd() {
        return this.receivingShiftEnd;
    }

    public void setReceivingShiftEnd(Date receivingShiftEnd) {
        this.receivingShiftEnd = receivingShiftEnd;
    }

    public ShiftTradeResponse expiration(Date expiration) {
        this.expiration = expiration;
        return this;
    }

    @ApiModelProperty(example="null", value="When this shift trade offer will expire if not matched or approved. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="expiration")
    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    public ShiftTradeResponse oneSided(Boolean oneSided) {
        this.oneSided = oneSided;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this is a one-sided shift trade (e.g. the initiating user is not asking for a shift in return)")
    @JsonProperty(value="oneSided")
    public Boolean getOneSided() {
        return this.oneSided;
    }

    public void setOneSided(Boolean oneSided) {
        this.oneSided = oneSided;
    }

    public ShiftTradeResponse acceptableIntervals(List<String> acceptableIntervals) {
        this.acceptableIntervals = acceptableIntervals;
        return this;
    }

    @ApiModelProperty(example="null", value="Time frames when the initiating user is willing to accept trades.  Empty means giving up the shift. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="acceptableIntervals")
    public List<String> getAcceptableIntervals() {
        return this.acceptableIntervals;
    }

    public void setAcceptableIntervals(List<String> acceptableIntervals) {
        this.acceptableIntervals = acceptableIntervals;
    }

    public ShiftTradeResponse reviewedBy(UserReference reviewedBy) {
        this.reviewedBy = reviewedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The user who reviewed this shift trade")
    @JsonProperty(value="reviewedBy")
    public UserReference getReviewedBy() {
        return this.reviewedBy;
    }

    public void setReviewedBy(UserReference reviewedBy) {
        this.reviewedBy = reviewedBy;
    }

    public ShiftTradeResponse reviewedDate(Date reviewedDate) {
        this.reviewedDate = reviewedDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this shift trade was reviewed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="reviewedDate")
    public Date getReviewedDate() {
        return this.reviewedDate;
    }

    public void setReviewedDate(Date reviewedDate) {
        this.reviewedDate = reviewedDate;
    }

    public ShiftTradeResponse metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", value="Version data for this trade")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShiftTradeResponse shiftTradeResponse = (ShiftTradeResponse)o;
        return Objects.equals(this.id, shiftTradeResponse.id) && Objects.equals(this.weekDate, shiftTradeResponse.weekDate) && Objects.equals(this.schedule, shiftTradeResponse.schedule) && Objects.equals((Object)this.state, (Object)shiftTradeResponse.state) && Objects.equals(this.initiatingUser, shiftTradeResponse.initiatingUser) && Objects.equals(this.initiatingShiftId, shiftTradeResponse.initiatingShiftId) && Objects.equals(this.initiatingShiftStart, shiftTradeResponse.initiatingShiftStart) && Objects.equals(this.initiatingShiftEnd, shiftTradeResponse.initiatingShiftEnd) && Objects.equals(this.receivingUser, shiftTradeResponse.receivingUser) && Objects.equals(this.receivingShiftId, shiftTradeResponse.receivingShiftId) && Objects.equals(this.receivingShiftStart, shiftTradeResponse.receivingShiftStart) && Objects.equals(this.receivingShiftEnd, shiftTradeResponse.receivingShiftEnd) && Objects.equals(this.expiration, shiftTradeResponse.expiration) && Objects.equals(this.oneSided, shiftTradeResponse.oneSided) && Objects.equals(this.acceptableIntervals, shiftTradeResponse.acceptableIntervals) && Objects.equals(this.reviewedBy, shiftTradeResponse.reviewedBy) && Objects.equals(this.reviewedDate, shiftTradeResponse.reviewedDate) && Objects.equals(this.metadata, shiftTradeResponse.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.weekDate, this.schedule, this.state, this.initiatingUser, this.initiatingShiftId, this.initiatingShiftStart, this.initiatingShiftEnd, this.receivingUser, this.receivingShiftId, this.receivingShiftStart, this.receivingShiftEnd, this.expiration, this.oneSided, this.acceptableIntervals, this.reviewedBy, this.reviewedDate, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShiftTradeResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    weekDate: ").append(this.toIndentedString(this.weekDate)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    initiatingUser: ").append(this.toIndentedString(this.initiatingUser)).append("\n");
        sb.append("    initiatingShiftId: ").append(this.toIndentedString(this.initiatingShiftId)).append("\n");
        sb.append("    initiatingShiftStart: ").append(this.toIndentedString(this.initiatingShiftStart)).append("\n");
        sb.append("    initiatingShiftEnd: ").append(this.toIndentedString(this.initiatingShiftEnd)).append("\n");
        sb.append("    receivingUser: ").append(this.toIndentedString(this.receivingUser)).append("\n");
        sb.append("    receivingShiftId: ").append(this.toIndentedString(this.receivingShiftId)).append("\n");
        sb.append("    receivingShiftStart: ").append(this.toIndentedString(this.receivingShiftStart)).append("\n");
        sb.append("    receivingShiftEnd: ").append(this.toIndentedString(this.receivingShiftEnd)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    oneSided: ").append(this.toIndentedString(this.oneSided)).append("\n");
        sb.append("    acceptableIntervals: ").append(this.toIndentedString(this.acceptableIntervals)).append("\n");
        sb.append("    reviewedBy: ").append(this.toIndentedString(this.reviewedBy)).append("\n");
        sb.append("    reviewedDate: ").append(this.toIndentedString(this.reviewedDate)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNMATCHED("Unmatched"),
        MATCHED("Matched"),
        APPROVED("Approved"),
        DENIED("Denied"),
        EXPIRED("Expired"),
        CANCELED("Canceled");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

