/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class CampaignRuleExecutionSettings
implements Serializable {
    private FrequencyEnum frequency = null;
    private String timeZoneId = null;

    public CampaignRuleExecutionSettings frequency(FrequencyEnum frequency) {
        this.frequency = frequency;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Execution control frequency")
    @JsonProperty(value="frequency")
    public FrequencyEnum getFrequency() {
        return this.frequency;
    }

    public void setFrequency(FrequencyEnum frequency) {
        this.frequency = frequency;
    }

    public CampaignRuleExecutionSettings timeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
        return this;
    }

    @ApiModelProperty(example="Africa/Abidjan", value="The time zone for the execution control frequency=\"oncePerDay\"; for example, Africa/Abidjan. This property is ignored when frequency is not \"oncePerDay\"")
    @JsonProperty(value="timeZoneId")
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CampaignRuleExecutionSettings campaignRuleExecutionSettings = (CampaignRuleExecutionSettings)o;
        return Objects.equals((Object)this.frequency, (Object)campaignRuleExecutionSettings.frequency) && Objects.equals(this.timeZoneId, campaignRuleExecutionSettings.timeZoneId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.frequency, this.timeZoneId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CampaignRuleExecutionSettings {\n");
        sb.append("    frequency: ").append(this.toIndentedString((Object)this.frequency)).append("\n");
        sb.append("    timeZoneId: ").append(this.toIndentedString(this.timeZoneId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FrequencyEnumDeserializer.class)
    public static enum FrequencyEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ONEACHTRIGGER("onEachTrigger"),
        ONCEPERDAY("oncePerDay");

        private String value;

        private FrequencyEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FrequencyEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FrequencyEnum value : FrequencyEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FrequencyEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FrequencyEnumDeserializer
    extends StdDeserializer<FrequencyEnum> {
        public FrequencyEnumDeserializer() {
            super(FrequencyEnumDeserializer.class);
        }

        public FrequencyEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FrequencyEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

