/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.SchedulerMessageTypeSeverity;
import com.mypurecloud.sdk.v2.model.WfmServiceGoalImpactSettings;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BuSchedulingSettingsResponse
implements Serializable {
    private List<SchedulerMessageTypeSeverity> messageSeverities = new ArrayList<SchedulerMessageTypeSeverity>();
    private List<SyncTimeOffPropertiesEnum> syncTimeOffProperties = new ArrayList<SyncTimeOffPropertiesEnum>();
    private WfmServiceGoalImpactSettings serviceGoalImpact = null;
    private Boolean allowWorkPlanPerMinuteGranularity = null;

    public BuSchedulingSettingsResponse messageSeverities(List<SchedulerMessageTypeSeverity> messageSeverities) {
        this.messageSeverities = messageSeverities;
        return this;
    }

    @ApiModelProperty(example="null", value="Schedule generation message severity configuration")
    @JsonProperty(value="messageSeverities")
    public List<SchedulerMessageTypeSeverity> getMessageSeverities() {
        return this.messageSeverities;
    }

    public void setMessageSeverities(List<SchedulerMessageTypeSeverity> messageSeverities) {
        this.messageSeverities = messageSeverities;
    }

    public BuSchedulingSettingsResponse syncTimeOffProperties(List<SyncTimeOffPropertiesEnum> syncTimeOffProperties) {
        this.syncTimeOffProperties = syncTimeOffProperties;
        return this;
    }

    @ApiModelProperty(example="null", value="Synchronize set of time off properties from scheduled activities to time off requests when the schedule is published.")
    @JsonProperty(value="syncTimeOffProperties")
    public List<SyncTimeOffPropertiesEnum> getSyncTimeOffProperties() {
        return this.syncTimeOffProperties;
    }

    public void setSyncTimeOffProperties(List<SyncTimeOffPropertiesEnum> syncTimeOffProperties) {
        this.syncTimeOffProperties = syncTimeOffProperties;
    }

    public BuSchedulingSettingsResponse serviceGoalImpact(WfmServiceGoalImpactSettings serviceGoalImpact) {
        this.serviceGoalImpact = serviceGoalImpact;
        return this;
    }

    @ApiModelProperty(example="null", value="Configures the max percent increase and decrease of service goals for this business unit")
    @JsonProperty(value="serviceGoalImpact")
    public WfmServiceGoalImpactSettings getServiceGoalImpact() {
        return this.serviceGoalImpact;
    }

    public void setServiceGoalImpact(WfmServiceGoalImpactSettings serviceGoalImpact) {
        this.serviceGoalImpact = serviceGoalImpact;
    }

    public BuSchedulingSettingsResponse allowWorkPlanPerMinuteGranularity(Boolean allowWorkPlanPerMinuteGranularity) {
        this.allowWorkPlanPerMinuteGranularity = allowWorkPlanPerMinuteGranularity;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether or not per minute granularity for scheduling will be enabled for this business unit. Defaults to false.")
    @JsonProperty(value="allowWorkPlanPerMinuteGranularity")
    public Boolean getAllowWorkPlanPerMinuteGranularity() {
        return this.allowWorkPlanPerMinuteGranularity;
    }

    public void setAllowWorkPlanPerMinuteGranularity(Boolean allowWorkPlanPerMinuteGranularity) {
        this.allowWorkPlanPerMinuteGranularity = allowWorkPlanPerMinuteGranularity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuSchedulingSettingsResponse buSchedulingSettingsResponse = (BuSchedulingSettingsResponse)o;
        return Objects.equals(this.messageSeverities, buSchedulingSettingsResponse.messageSeverities) && Objects.equals(this.syncTimeOffProperties, buSchedulingSettingsResponse.syncTimeOffProperties) && Objects.equals(this.serviceGoalImpact, buSchedulingSettingsResponse.serviceGoalImpact) && Objects.equals(this.allowWorkPlanPerMinuteGranularity, buSchedulingSettingsResponse.allowWorkPlanPerMinuteGranularity);
    }

    public int hashCode() {
        return Objects.hash(this.messageSeverities, this.syncTimeOffProperties, this.serviceGoalImpact, this.allowWorkPlanPerMinuteGranularity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BuSchedulingSettingsResponse {\n");
        sb.append("    messageSeverities: ").append(this.toIndentedString(this.messageSeverities)).append("\n");
        sb.append("    syncTimeOffProperties: ").append(this.toIndentedString(this.syncTimeOffProperties)).append("\n");
        sb.append("    serviceGoalImpact: ").append(this.toIndentedString(this.serviceGoalImpact)).append("\n");
        sb.append("    allowWorkPlanPerMinuteGranularity: ").append(this.toIndentedString(this.allowWorkPlanPerMinuteGranularity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SyncTimeOffPropertiesEnumDeserializer.class)
    public static enum SyncTimeOffPropertiesEnum {
        PAYABLEMINUTES("PayableMinutes");

        private String value;

        private SyncTimeOffPropertiesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SyncTimeOffPropertiesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SyncTimeOffPropertiesEnum value : SyncTimeOffPropertiesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SyncTimeOffPropertiesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SyncTimeOffPropertiesEnumDeserializer
    extends StdDeserializer<SyncTimeOffPropertiesEnum> {
        public SyncTimeOffPropertiesEnumDeserializer() {
            super(SyncTimeOffPropertiesEnumDeserializer.class);
        }

        public SyncTimeOffPropertiesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SyncTimeOffPropertiesEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

