/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.PasswordRequirements;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OrgAuthSettings
implements Serializable {
    private Boolean multifactorAuthenticationRequired = null;
    private Boolean domainAllowlistEnabled = null;
    private List<String> domainAllowlist = new ArrayList<String>();
    private List<String> ipAddressAllowlist = new ArrayList<String>();
    private PasswordRequirements passwordRequirements = null;
    private List<String> inactivityTimeoutExclusions = new ArrayList<String>();

    public OrgAuthSettings multifactorAuthenticationRequired(Boolean multifactorAuthenticationRequired) {
        this.multifactorAuthenticationRequired = multifactorAuthenticationRequired;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether multi-factor authentication is required.")
    @JsonProperty(value="multifactorAuthenticationRequired")
    public Boolean getMultifactorAuthenticationRequired() {
        return this.multifactorAuthenticationRequired;
    }

    public void setMultifactorAuthenticationRequired(Boolean multifactorAuthenticationRequired) {
        this.multifactorAuthenticationRequired = multifactorAuthenticationRequired;
    }

    public OrgAuthSettings domainAllowlistEnabled(Boolean domainAllowlistEnabled) {
        this.domainAllowlistEnabled = domainAllowlistEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether the domain allowlist is enabled.")
    @JsonProperty(value="domainAllowlistEnabled")
    public Boolean getDomainAllowlistEnabled() {
        return this.domainAllowlistEnabled;
    }

    public void setDomainAllowlistEnabled(Boolean domainAllowlistEnabled) {
        this.domainAllowlistEnabled = domainAllowlistEnabled;
    }

    public OrgAuthSettings domainAllowlist(List<String> domainAllowlist) {
        this.domainAllowlist = domainAllowlist;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of domains that will be allowed to embed Genesys Cloud applications.")
    @JsonProperty(value="domainAllowlist")
    public List<String> getDomainAllowlist() {
        return this.domainAllowlist;
    }

    public void setDomainAllowlist(List<String> domainAllowlist) {
        this.domainAllowlist = domainAllowlist;
    }

    public OrgAuthSettings ipAddressAllowlist(List<String> ipAddressAllowlist) {
        this.ipAddressAllowlist = ipAddressAllowlist;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of IP addresses that will be allowed to authenticate with Genesys Cloud.")
    @JsonProperty(value="ipAddressAllowlist")
    public List<String> getIpAddressAllowlist() {
        return this.ipAddressAllowlist;
    }

    public void setIpAddressAllowlist(List<String> ipAddressAllowlist) {
        this.ipAddressAllowlist = ipAddressAllowlist;
    }

    public OrgAuthSettings passwordRequirements(PasswordRequirements passwordRequirements) {
        this.passwordRequirements = passwordRequirements;
        return this;
    }

    @ApiModelProperty(example="null", value="The password requirements for the organization.")
    @JsonProperty(value="passwordRequirements")
    public PasswordRequirements getPasswordRequirements() {
        return this.passwordRequirements;
    }

    public void setPasswordRequirements(PasswordRequirements passwordRequirements) {
        this.passwordRequirements = passwordRequirements;
    }

    public OrgAuthSettings inactivityTimeoutExclusions(List<String> inactivityTimeoutExclusions) {
        this.inactivityTimeoutExclusions = inactivityTimeoutExclusions;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of exempt apis from inactivity timeout.")
    @JsonProperty(value="inactivityTimeoutExclusions")
    public List<String> getInactivityTimeoutExclusions() {
        return this.inactivityTimeoutExclusions;
    }

    public void setInactivityTimeoutExclusions(List<String> inactivityTimeoutExclusions) {
        this.inactivityTimeoutExclusions = inactivityTimeoutExclusions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrgAuthSettings orgAuthSettings = (OrgAuthSettings)o;
        return Objects.equals(this.multifactorAuthenticationRequired, orgAuthSettings.multifactorAuthenticationRequired) && Objects.equals(this.domainAllowlistEnabled, orgAuthSettings.domainAllowlistEnabled) && Objects.equals(this.domainAllowlist, orgAuthSettings.domainAllowlist) && Objects.equals(this.ipAddressAllowlist, orgAuthSettings.ipAddressAllowlist) && Objects.equals(this.passwordRequirements, orgAuthSettings.passwordRequirements) && Objects.equals(this.inactivityTimeoutExclusions, orgAuthSettings.inactivityTimeoutExclusions);
    }

    public int hashCode() {
        return Objects.hash(this.multifactorAuthenticationRequired, this.domainAllowlistEnabled, this.domainAllowlist, this.ipAddressAllowlist, this.passwordRequirements, this.inactivityTimeoutExclusions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgAuthSettings {\n");
        sb.append("    multifactorAuthenticationRequired: ").append(this.toIndentedString(this.multifactorAuthenticationRequired)).append("\n");
        sb.append("    domainAllowlistEnabled: ").append(this.toIndentedString(this.domainAllowlistEnabled)).append("\n");
        sb.append("    domainAllowlist: ").append(this.toIndentedString(this.domainAllowlist)).append("\n");
        sb.append("    ipAddressAllowlist: ").append(this.toIndentedString(this.ipAddressAllowlist)).append("\n");
        sb.append("    passwordRequirements: ").append(this.toIndentedString(this.passwordRequirements)).append("\n");
        sb.append("    inactivityTimeoutExclusions: ").append(this.toIndentedString(this.inactivityTimeoutExclusions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

