/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.LearningModulePreviewGetResponseStep;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Learning module preview get response assignment")
public class LearningModulePreviewGetResponseAssignment
implements Serializable {
    private StateEnum state = null;
    private Float percentageScore = null;
    private Float assessmentPercentageScore = null;
    private Boolean isPassed = null;
    private Float assessmentCompletionPercentage = null;
    private Float completionPercentage = null;
    private List<LearningModulePreviewGetResponseStep> steps = new ArrayList<LearningModulePreviewGetResponseStep>();

    public LearningModulePreviewGetResponseAssignment state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The Learning Assignment state")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    @ApiModelProperty(example="null", value="The user's percentage score for this assignment")
    @JsonProperty(value="percentageScore")
    public Float getPercentageScore() {
        return this.percentageScore;
    }

    @ApiModelProperty(example="null", value="The user's percentage score for this assignment's assessment")
    @JsonProperty(value="assessmentPercentageScore")
    public Float getAssessmentPercentageScore() {
        return this.assessmentPercentageScore;
    }

    @ApiModelProperty(example="null", value="True if the assessment was passed")
    @JsonProperty(value="isPassed")
    public Boolean getIsPassed() {
        return this.isPassed;
    }

    @ApiModelProperty(example="null", value="The assessment completion percentage of assignment")
    @JsonProperty(value="assessmentCompletionPercentage")
    public Float getAssessmentCompletionPercentage() {
        return this.assessmentCompletionPercentage;
    }

    @ApiModelProperty(example="null", value="The overall completion percentage of assignment")
    @JsonProperty(value="completionPercentage")
    public Float getCompletionPercentage() {
        return this.completionPercentage;
    }

    @ApiModelProperty(example="null", value="List of assignment steps")
    @JsonProperty(value="steps")
    public List<LearningModulePreviewGetResponseStep> getSteps() {
        return this.steps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LearningModulePreviewGetResponseAssignment learningModulePreviewGetResponseAssignment = (LearningModulePreviewGetResponseAssignment)o;
        return Objects.equals((Object)this.state, (Object)learningModulePreviewGetResponseAssignment.state) && Objects.equals(this.percentageScore, learningModulePreviewGetResponseAssignment.percentageScore) && Objects.equals(this.assessmentPercentageScore, learningModulePreviewGetResponseAssignment.assessmentPercentageScore) && Objects.equals(this.isPassed, learningModulePreviewGetResponseAssignment.isPassed) && Objects.equals(this.assessmentCompletionPercentage, learningModulePreviewGetResponseAssignment.assessmentCompletionPercentage) && Objects.equals(this.completionPercentage, learningModulePreviewGetResponseAssignment.completionPercentage) && Objects.equals(this.steps, learningModulePreviewGetResponseAssignment.steps);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.percentageScore, this.assessmentPercentageScore, this.isPassed, this.assessmentCompletionPercentage, this.completionPercentage, this.steps});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LearningModulePreviewGetResponseAssignment {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    percentageScore: ").append(this.toIndentedString(this.percentageScore)).append("\n");
        sb.append("    assessmentPercentageScore: ").append(this.toIndentedString(this.assessmentPercentageScore)).append("\n");
        sb.append("    isPassed: ").append(this.toIndentedString(this.isPassed)).append("\n");
        sb.append("    assessmentCompletionPercentage: ").append(this.toIndentedString(this.assessmentCompletionPercentage)).append("\n");
        sb.append("    completionPercentage: ").append(this.toIndentedString(this.completionPercentage)).append("\n");
        sb.append("    steps: ").append(this.toIndentedString(this.steps)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASSIGNED("Assigned"),
        INPROGRESS("InProgress"),
        COMPLETED("Completed"),
        DELETED("Deleted"),
        NOTCOMPLETED("NotCompleted"),
        INVALIDSCHEDULE("InvalidSchedule");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

