/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.AiScoringSettings;
import java.util.HashMap;
import java.util.Map;

public class PutQualityFormsEvaluationAiscoringSettingsRequest {
    private String formId;
    private AiScoringSettings body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public PutQualityFormsEvaluationAiscoringSettingsRequest withFormId(String formId) {
        this.setFormId(formId);
        return this;
    }

    public AiScoringSettings getBody() {
        return this.body;
    }

    public void setBody(AiScoringSettings body) {
        this.body = body;
    }

    public PutQualityFormsEvaluationAiscoringSettingsRequest withBody(AiScoringSettings body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutQualityFormsEvaluationAiscoringSettingsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<AiScoringSettings> withHttpInfo() {
        if (this.formId == null) {
            throw new IllegalStateException("Missing the required parameter 'formId' when building request for PutQualityFormsEvaluationAiscoringSettingsRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutQualityFormsEvaluationAiscoringSettingsRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/quality/forms/evaluations/{formId}/aiscoring/settings").withPathParameter("formId", this.formId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String formId, AiScoringSettings body) {
        return new Builder().withRequiredParams(formId, body);
    }

    public static class Builder {
        private final PutQualityFormsEvaluationAiscoringSettingsRequest request = new PutQualityFormsEvaluationAiscoringSettingsRequest();

        private Builder() {
        }

        public Builder withFormId(String formId) {
            this.request.setFormId(formId);
            return this;
        }

        public Builder withBody(AiScoringSettings body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String formId, AiScoringSettings body) {
            this.request.setFormId(formId);
            this.request.setBody(body);
            return this;
        }

        public PutQualityFormsEvaluationAiscoringSettingsRequest build() {
            if (this.request.formId == null) {
                throw new IllegalStateException("Missing the required parameter 'formId' when building request for PutQualityFormsEvaluationAiscoringSettingsRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutQualityFormsEvaluationAiscoringSettingsRequest.");
            }
            return this.request;
        }
    }
}

