/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetConversationSuggestionRequest {
    private String conversationId;
    private String suggestionId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public GetConversationSuggestionRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getSuggestionId() {
        return this.suggestionId;
    }

    public void setSuggestionId(String suggestionId) {
        this.suggestionId = suggestionId;
    }

    public GetConversationSuggestionRequest withSuggestionId(String suggestionId) {
        this.setSuggestionId(suggestionId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetConversationSuggestionRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for GetConversationSuggestionRequest.");
        }
        if (this.suggestionId == null) {
            throw new IllegalStateException("Missing the required parameter 'suggestionId' when building request for GetConversationSuggestionRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/conversations/{conversationId}/suggestions/{suggestionId}").withPathParameter("conversationId", this.conversationId).withPathParameter("suggestionId", this.suggestionId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String suggestionId) {
        return new Builder().withRequiredParams(conversationId, suggestionId);
    }

    public static class Builder {
        private final GetConversationSuggestionRequest request = new GetConversationSuggestionRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withSuggestionId(String suggestionId) {
            this.request.setSuggestionId(suggestionId);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String suggestionId) {
            this.request.setConversationId(conversationId);
            this.request.setSuggestionId(suggestionId);
            return this;
        }

        public GetConversationSuggestionRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for GetConversationSuggestionRequest.");
            }
            if (this.request.suggestionId == null) {
                throw new IllegalStateException("Missing the required parameter 'suggestionId' when building request for GetConversationSuggestionRequest.");
            }
            return this.request;
        }
    }
}

