/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.Compliance;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class SmsPhoneNumberImport
implements Serializable {
    private String id = null;
    private String phoneNumber = null;
    private PhoneNumberTypeEnum phoneNumberType = null;
    private String countryCode = null;
    private String integrationId = null;
    private Compliance compliance = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public SmsPhoneNumberImport phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A phone number to be used for SMS communications. E.g. +13175555555 or +34234234234")
    @JsonProperty(value="phoneNumber")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public SmsPhoneNumberImport phoneNumberType(PhoneNumberTypeEnum phoneNumberType) {
        this.phoneNumberType = phoneNumberType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of the phone number provisioned.")
    @JsonProperty(value="phoneNumberType")
    public PhoneNumberTypeEnum getPhoneNumberType() {
        return this.phoneNumberType;
    }

    public void setPhoneNumberType(PhoneNumberTypeEnum phoneNumberType) {
        this.phoneNumberType = phoneNumberType;
    }

    public SmsPhoneNumberImport countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ISO 3166-1 alpha-2 country code of the country this phone number is associated with.")
    @JsonProperty(value="countryCode")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public SmsPhoneNumberImport integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id of the Genesys Cloud integration this phone number belongs to.")
    @JsonProperty(value="integrationId")
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public SmsPhoneNumberImport compliance(Compliance compliance) {
        this.compliance = compliance;
        return this;
    }

    @ApiModelProperty(example="null", value="Compliance configuration for short codes, including help, stop and opt in.")
    @JsonProperty(value="compliance")
    public Compliance getCompliance() {
        return this.compliance;
    }

    public void setCompliance(Compliance compliance) {
        this.compliance = compliance;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmsPhoneNumberImport smsPhoneNumberImport = (SmsPhoneNumberImport)o;
        return Objects.equals(this.id, smsPhoneNumberImport.id) && Objects.equals(this.phoneNumber, smsPhoneNumberImport.phoneNumber) && Objects.equals((Object)this.phoneNumberType, (Object)smsPhoneNumberImport.phoneNumberType) && Objects.equals(this.countryCode, smsPhoneNumberImport.countryCode) && Objects.equals(this.integrationId, smsPhoneNumberImport.integrationId) && Objects.equals(this.compliance, smsPhoneNumberImport.compliance) && Objects.equals(this.selfUri, smsPhoneNumberImport.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.phoneNumber, this.phoneNumberType, this.countryCode, this.integrationId, this.compliance, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SmsPhoneNumberImport {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    phoneNumberType: ").append(this.toIndentedString((Object)this.phoneNumberType)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    compliance: ").append(this.toIndentedString(this.compliance)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=PhoneNumberTypeEnumDeserializer.class)
    public static enum PhoneNumberTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        LOCAL("local"),
        MOBILE("mobile"),
        TOLLFREE("tollfree"),
        SHORTCODE("shortcode");

        private String value;

        private PhoneNumberTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PhoneNumberTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PhoneNumberTypeEnum value : PhoneNumberTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PhoneNumberTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class PhoneNumberTypeEnumDeserializer
    extends StdDeserializer<PhoneNumberTypeEnum> {
        public PhoneNumberTypeEnumDeserializer() {
            super(PhoneNumberTypeEnumDeserializer.class);
        }

        public PhoneNumberTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PhoneNumberTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

