/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class RecurrencePeriod
implements Serializable {
    private Integer magnitude = null;
    private GranularityEnum granularity = null;

    public RecurrencePeriod magnitude(Integer magnitude) {
        this.magnitude = magnitude;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The period of the activity plan in granularity units")
    @JsonProperty(value="magnitude")
    public Integer getMagnitude() {
        return this.magnitude;
    }

    public void setMagnitude(Integer magnitude) {
        this.magnitude = magnitude;
    }

    public RecurrencePeriod granularity(GranularityEnum granularity) {
        this.granularity = granularity;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The granularity unit to interpret the period of this activity plan")
    @JsonProperty(value="granularity")
    public GranularityEnum getGranularity() {
        return this.granularity;
    }

    public void setGranularity(GranularityEnum granularity) {
        this.granularity = granularity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecurrencePeriod recurrencePeriod = (RecurrencePeriod)o;
        return Objects.equals(this.magnitude, recurrencePeriod.magnitude) && Objects.equals((Object)this.granularity, (Object)recurrencePeriod.granularity);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.magnitude, this.granularity});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecurrencePeriod {\n");
        sb.append("    magnitude: ").append(this.toIndentedString(this.magnitude)).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString((Object)this.granularity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=GranularityEnumDeserializer.class)
    public static enum GranularityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DAYS("Days"),
        WEEKS("Weeks");

        private String value;

        private GranularityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GranularityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GranularityEnum value : GranularityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GranularityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class GranularityEnumDeserializer
    extends StdDeserializer<GranularityEnum> {
        public GranularityEnumDeserializer() {
            super(GranularityEnumDeserializer.class);
        }

        public GranularityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return GranularityEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

