/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.FileUploadSettings;
import com.mypurecloud.sdk.v2.model.LauncherButtonSettings;
import com.mypurecloud.sdk.v2.model.MessengerApps;
import com.mypurecloud.sdk.v2.model.MessengerHomeScreen;
import com.mypurecloud.sdk.v2.model.MessengerStyles;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Settings concerning messenger")
public class MessengerSettings
implements Serializable {
    private Boolean enabled = null;
    private MessengerStyles styles = null;
    private LauncherButtonSettings launcherButton = null;
    private FileUploadSettings fileUpload = null;
    private MessengerApps apps = null;
    private MessengerHomeScreen homeScreen = null;
    private SessionPersistenceTypeEnum sessionPersistenceType = null;

    public MessengerSettings enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether or not messenger is enabled")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public MessengerSettings styles(MessengerStyles styles) {
        this.styles = styles;
        return this;
    }

    @ApiModelProperty(example="null", value="The style settings for messenger")
    @JsonProperty(value="styles")
    public MessengerStyles getStyles() {
        return this.styles;
    }

    public void setStyles(MessengerStyles styles) {
        this.styles = styles;
    }

    public MessengerSettings launcherButton(LauncherButtonSettings launcherButton) {
        this.launcherButton = launcherButton;
        return this;
    }

    @ApiModelProperty(example="null", value="The launcher button settings for messenger")
    @JsonProperty(value="launcherButton")
    public LauncherButtonSettings getLauncherButton() {
        return this.launcherButton;
    }

    public void setLauncherButton(LauncherButtonSettings launcherButton) {
        this.launcherButton = launcherButton;
    }

    public MessengerSettings fileUpload(FileUploadSettings fileUpload) {
        this.fileUpload = fileUpload;
        return this;
    }

    @ApiModelProperty(example="null", value="The file upload settings for messenger")
    @JsonProperty(value="fileUpload")
    public FileUploadSettings getFileUpload() {
        return this.fileUpload;
    }

    public void setFileUpload(FileUploadSettings fileUpload) {
        this.fileUpload = fileUpload;
    }

    public MessengerSettings apps(MessengerApps apps) {
        this.apps = apps;
        return this;
    }

    @ApiModelProperty(example="null", value="The apps embedded in the messenger")
    @JsonProperty(value="apps")
    public MessengerApps getApps() {
        return this.apps;
    }

    public void setApps(MessengerApps apps) {
        this.apps = apps;
    }

    public MessengerSettings homeScreen(MessengerHomeScreen homeScreen) {
        this.homeScreen = homeScreen;
        return this;
    }

    @ApiModelProperty(example="null", value="The homescreen settings for messenger")
    @JsonProperty(value="homeScreen")
    public MessengerHomeScreen getHomeScreen() {
        return this.homeScreen;
    }

    public void setHomeScreen(MessengerHomeScreen homeScreen) {
        this.homeScreen = homeScreen;
    }

    public MessengerSettings sessionPersistenceType(SessionPersistenceTypeEnum sessionPersistenceType) {
        this.sessionPersistenceType = sessionPersistenceType;
        return this;
    }

    @ApiModelProperty(example="null", value="The session persistence type for messenger")
    @JsonProperty(value="sessionPersistenceType")
    public SessionPersistenceTypeEnum getSessionPersistenceType() {
        return this.sessionPersistenceType;
    }

    public void setSessionPersistenceType(SessionPersistenceTypeEnum sessionPersistenceType) {
        this.sessionPersistenceType = sessionPersistenceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessengerSettings messengerSettings = (MessengerSettings)o;
        return Objects.equals(this.enabled, messengerSettings.enabled) && Objects.equals(this.styles, messengerSettings.styles) && Objects.equals(this.launcherButton, messengerSettings.launcherButton) && Objects.equals(this.fileUpload, messengerSettings.fileUpload) && Objects.equals(this.apps, messengerSettings.apps) && Objects.equals(this.homeScreen, messengerSettings.homeScreen) && Objects.equals((Object)this.sessionPersistenceType, (Object)messengerSettings.sessionPersistenceType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.styles, this.launcherButton, this.fileUpload, this.apps, this.homeScreen, this.sessionPersistenceType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessengerSettings {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    styles: ").append(this.toIndentedString(this.styles)).append("\n");
        sb.append("    launcherButton: ").append(this.toIndentedString(this.launcherButton)).append("\n");
        sb.append("    fileUpload: ").append(this.toIndentedString(this.fileUpload)).append("\n");
        sb.append("    apps: ").append(this.toIndentedString(this.apps)).append("\n");
        sb.append("    homeScreen: ").append(this.toIndentedString(this.homeScreen)).append("\n");
        sb.append("    sessionPersistenceType: ").append(this.toIndentedString((Object)this.sessionPersistenceType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SessionPersistenceTypeEnumDeserializer.class)
    public static enum SessionPersistenceTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACROSSSUBDOMAINS("AcrossSubdomains"),
        DOMAINORSUBDOMAINONLY("DomainOrSubdomainOnly");

        private String value;

        private SessionPersistenceTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SessionPersistenceTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SessionPersistenceTypeEnum value : SessionPersistenceTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SessionPersistenceTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SessionPersistenceTypeEnumDeserializer
    extends StdDeserializer<SessionPersistenceTypeEnum> {
        public SessionPersistenceTypeEnumDeserializer() {
            super(SessionPersistenceTypeEnumDeserializer.class);
        }

        public SessionPersistenceTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SessionPersistenceTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

