/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class KnowledgeBaseWithDialectReference
implements Serializable {
    private String id = null;
    private LanguageCodeEnum languageCode = null;
    private String selfUri = null;

    public KnowledgeBaseWithDialectReference id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The globally unique identifier for the knowledge base.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public KnowledgeBaseWithDialectReference languageCode(LanguageCodeEnum languageCode) {
        this.languageCode = languageCode;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The dialect for the knowledge base.")
    @JsonProperty(value="languageCode")
    public LanguageCodeEnum getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(LanguageCodeEnum languageCode) {
        this.languageCode = languageCode;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeBaseWithDialectReference knowledgeBaseWithDialectReference = (KnowledgeBaseWithDialectReference)o;
        return Objects.equals(this.id, knowledgeBaseWithDialectReference.id) && Objects.equals((Object)this.languageCode, (Object)knowledgeBaseWithDialectReference.languageCode) && Objects.equals(this.selfUri, knowledgeBaseWithDialectReference.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.languageCode, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeBaseWithDialectReference {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    languageCode: ").append(this.toIndentedString((Object)this.languageCode)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=LanguageCodeEnumDeserializer.class)
    public static enum LanguageCodeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EN_ZA("en-ZA"),
        EN_AU("en-AU"),
        EN_GB("en-GB"),
        EN_IE("en-IE"),
        EN_IN("en-IN"),
        EN_US("en-US"),
        ES_US("es-US"),
        ES_ES("es-ES"),
        NL_NL("nl-NL"),
        FR_CA("fr-CA"),
        FR_FR("fr-FR"),
        DE_DE("de-DE"),
        IT_IT("it-IT"),
        PT_PT("pt-PT"),
        PT_BR("pt-BR"),
        AR_AE("ar-AE"),
        JA_JP("ja-JP"),
        SV_SE("sv-SE"),
        DE_AT("de-AT"),
        DE_CH("de-CH"),
        DA_DK("da-DK"),
        FR_BE("fr-BE"),
        FR_CH("fr-CH"),
        ES_MX("es-MX"),
        ES_CO("es-CO"),
        ES_AR("es-AR");

        private String value;

        private LanguageCodeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LanguageCodeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (LanguageCodeEnum value : LanguageCodeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return LanguageCodeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class LanguageCodeEnumDeserializer
    extends StdDeserializer<LanguageCodeEnum> {
        public LanguageCodeEnumDeserializer() {
            super(LanguageCodeEnumDeserializer.class);
        }

        public LanguageCodeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return LanguageCodeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

