/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.JourneyViewElementFilterRange;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="A numeric filter on an element within a journey view")
public class JourneyViewElementFilterNumberPredicate
implements Serializable {
    private String dimension = null;
    private OperatorEnum operator = null;
    private Boolean noValue = null;
    private JourneyViewElementFilterRange range = null;

    public JourneyViewElementFilterNumberPredicate dimension(String dimension) {
        this.dimension = dimension;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="the element's attribute being filtered on")
    @JsonProperty(value="dimension")
    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public JourneyViewElementFilterNumberPredicate operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(example="null", value="Optional operator, default is Matches. Valid values: Matches")
    @JsonProperty(value="operator")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public JourneyViewElementFilterNumberPredicate noValue(Boolean noValue) {
        this.noValue = noValue;
        return this;
    }

    @ApiModelProperty(example="null", value="set this to true if no specific value to be considered")
    @JsonProperty(value="noValue")
    public Boolean getNoValue() {
        return this.noValue;
    }

    public void setNoValue(Boolean noValue) {
        this.noValue = noValue;
    }

    public JourneyViewElementFilterNumberPredicate range(JourneyViewElementFilterRange range) {
        this.range = range;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="the range of comparators to filter on")
    @JsonProperty(value="range")
    public JourneyViewElementFilterRange getRange() {
        return this.range;
    }

    public void setRange(JourneyViewElementFilterRange range) {
        this.range = range;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JourneyViewElementFilterNumberPredicate journeyViewElementFilterNumberPredicate = (JourneyViewElementFilterNumberPredicate)o;
        return Objects.equals(this.dimension, journeyViewElementFilterNumberPredicate.dimension) && Objects.equals((Object)this.operator, (Object)journeyViewElementFilterNumberPredicate.operator) && Objects.equals(this.noValue, journeyViewElementFilterNumberPredicate.noValue) && Objects.equals(this.range, journeyViewElementFilterNumberPredicate.range);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dimension, this.operator, this.noValue, this.range});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JourneyViewElementFilterNumberPredicate {\n");
        sb.append("    dimension: ").append(this.toIndentedString(this.dimension)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    noValue: ").append(this.toIndentedString(this.noValue)).append("\n");
        sb.append("    range: ").append(this.toIndentedString(this.range)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OperatorEnumDeserializer.class)
    public static enum OperatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MATCHES("Matches"),
        NOTMATCHES("NotMatches");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperatorEnum value : OperatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OperatorEnumDeserializer
    extends StdDeserializer<OperatorEnum> {
        public OperatorEnumDeserializer() {
            super(OperatorEnumDeserializer.class);
        }

        public OperatorEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OperatorEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

