/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.HistoricalShrinkageActivityCategoryResponse;
import com.mypurecloud.sdk.v2.model.HistoricalShrinkageAggregateResponse;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class HistoricalShrinkageResult
implements Serializable {
    private Date startDate = null;
    private Date endDate = null;
    private Integer totalScheduledDurationSeconds = null;
    private Integer totalLoggedInDurationSeconds = null;
    private HistoricalShrinkageAggregateResponse aggregatedShrinkage = null;
    private List<HistoricalShrinkageActivityCategoryResponse> shrinkageForActivityCategories = new ArrayList<HistoricalShrinkageActivityCategoryResponse>();
    private List<String> businessUnitIds = new ArrayList<String>();

    public HistoricalShrinkageResult startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Beginning of the date range that was queried, in ISO-8601 format")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public HistoricalShrinkageResult endDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(example="null", value="End of the date range that was queried, in ISO-8601 format. If it was not set, end date will be set to the queried time")
    @JsonProperty(value="endDate")
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public HistoricalShrinkageResult totalScheduledDurationSeconds(Integer totalScheduledDurationSeconds) {
        this.totalScheduledDurationSeconds = totalScheduledDurationSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Total duration in seconds for which agents in the management unit are scheduled")
    @JsonProperty(value="totalScheduledDurationSeconds")
    public Integer getTotalScheduledDurationSeconds() {
        return this.totalScheduledDurationSeconds;
    }

    public void setTotalScheduledDurationSeconds(Integer totalScheduledDurationSeconds) {
        this.totalScheduledDurationSeconds = totalScheduledDurationSeconds;
    }

    public HistoricalShrinkageResult totalLoggedInDurationSeconds(Integer totalLoggedInDurationSeconds) {
        this.totalLoggedInDurationSeconds = totalLoggedInDurationSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Total duration in seconds for which agents in the management unit are actually logged-in")
    @JsonProperty(value="totalLoggedInDurationSeconds")
    public Integer getTotalLoggedInDurationSeconds() {
        return this.totalLoggedInDurationSeconds;
    }

    public void setTotalLoggedInDurationSeconds(Integer totalLoggedInDurationSeconds) {
        this.totalLoggedInDurationSeconds = totalLoggedInDurationSeconds;
    }

    public HistoricalShrinkageResult aggregatedShrinkage(HistoricalShrinkageAggregateResponse aggregatedShrinkage) {
        this.aggregatedShrinkage = aggregatedShrinkage;
        return this;
    }

    @ApiModelProperty(example="null", value="Aggregated shrinkage data for all the activity categories")
    @JsonProperty(value="aggregatedShrinkage")
    public HistoricalShrinkageAggregateResponse getAggregatedShrinkage() {
        return this.aggregatedShrinkage;
    }

    public void setAggregatedShrinkage(HistoricalShrinkageAggregateResponse aggregatedShrinkage) {
        this.aggregatedShrinkage = aggregatedShrinkage;
    }

    public HistoricalShrinkageResult shrinkageForActivityCategories(List<HistoricalShrinkageActivityCategoryResponse> shrinkageForActivityCategories) {
        this.shrinkageForActivityCategories = shrinkageForActivityCategories;
        return this;
    }

    @ApiModelProperty(example="null", value="Shrinkage for activity categories")
    @JsonProperty(value="shrinkageForActivityCategories")
    public List<HistoricalShrinkageActivityCategoryResponse> getShrinkageForActivityCategories() {
        return this.shrinkageForActivityCategories;
    }

    public void setShrinkageForActivityCategories(List<HistoricalShrinkageActivityCategoryResponse> shrinkageForActivityCategories) {
        this.shrinkageForActivityCategories = shrinkageForActivityCategories;
    }

    public HistoricalShrinkageResult businessUnitIds(List<String> businessUnitIds) {
        this.businessUnitIds = businessUnitIds;
        return this;
    }

    @ApiModelProperty(example="null", value="List of all business units of all the agents in response")
    @JsonProperty(value="businessUnitIds")
    public List<String> getBusinessUnitIds() {
        return this.businessUnitIds;
    }

    public void setBusinessUnitIds(List<String> businessUnitIds) {
        this.businessUnitIds = businessUnitIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricalShrinkageResult historicalShrinkageResult = (HistoricalShrinkageResult)o;
        return Objects.equals(this.startDate, historicalShrinkageResult.startDate) && Objects.equals(this.endDate, historicalShrinkageResult.endDate) && Objects.equals(this.totalScheduledDurationSeconds, historicalShrinkageResult.totalScheduledDurationSeconds) && Objects.equals(this.totalLoggedInDurationSeconds, historicalShrinkageResult.totalLoggedInDurationSeconds) && Objects.equals(this.aggregatedShrinkage, historicalShrinkageResult.aggregatedShrinkage) && Objects.equals(this.shrinkageForActivityCategories, historicalShrinkageResult.shrinkageForActivityCategories) && Objects.equals(this.businessUnitIds, historicalShrinkageResult.businessUnitIds);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.totalScheduledDurationSeconds, this.totalLoggedInDurationSeconds, this.aggregatedShrinkage, this.shrinkageForActivityCategories, this.businessUnitIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricalShrinkageResult {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    totalScheduledDurationSeconds: ").append(this.toIndentedString(this.totalScheduledDurationSeconds)).append("\n");
        sb.append("    totalLoggedInDurationSeconds: ").append(this.toIndentedString(this.totalLoggedInDurationSeconds)).append("\n");
        sb.append("    aggregatedShrinkage: ").append(this.toIndentedString(this.aggregatedShrinkage)).append("\n");
        sb.append("    shrinkageForActivityCategories: ").append(this.toIndentedString(this.shrinkageForActivityCategories)).append("\n");
        sb.append("    businessUnitIds: ").append(this.toIndentedString(this.businessUnitIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

