/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ActivityPlanServiceGoalImpactOverrides;
import com.mypurecloud.sdk.v2.model.FixedAvailability;
import com.mypurecloud.sdk.v2.model.GroupSettings;
import com.mypurecloud.sdk.v2.model.RecurrenceSettings;
import com.mypurecloud.sdk.v2.model.SchedulingPeriod;
import com.mypurecloud.sdk.v2.model.UserSearchRule;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CreateActivityPlanRequest
implements Serializable {
    private String name = null;
    private List<String> managementUnitIds = new ArrayList<String>();
    private String description = null;
    private String activityCodeId = null;
    private TypeEnum type = null;
    private Integer lengthMinutes = null;
    private SchedulingPeriod initialSchedulePeriod = null;
    private GroupSettings groupSettings = null;
    private RecurrenceSettings recurrenceSettings = null;
    private UserSearchRule attendeesSearchRule = null;
    private Boolean facilitated = null;
    private UserSearchRule facilitatorsSearchRule = null;
    private Integer transitionTimeMinutes = null;
    private ActivityPlanServiceGoalImpactOverrides serviceGoalImpactOverrides = null;
    private OptimizationObjectiveEnum optimizationObjective = null;
    private StateEnum state = null;
    private Boolean countsAsPaidTime = null;
    private List<FixedAvailability> fixedAvailability = new ArrayList<FixedAvailability>();

    public CreateActivityPlanRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the activity plan")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateActivityPlanRequest managementUnitIds(List<String> managementUnitIds) {
        this.managementUnitIds = managementUnitIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The management units to which this activity plan applies. Empty list or null means this activity plan applies to the entire business unit")
    @JsonProperty(value="managementUnitIds")
    public List<String> getManagementUnitIds() {
        return this.managementUnitIds;
    }

    public void setManagementUnitIds(List<String> managementUnitIds) {
        this.managementUnitIds = managementUnitIds;
    }

    public CreateActivityPlanRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the activity plan")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateActivityPlanRequest activityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The activity code associated with the activity plan")
    @JsonProperty(value="activityCodeId")
    public String getActivityCodeId() {
        return this.activityCodeId;
    }

    public void setActivityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
    }

    public CreateActivityPlanRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of the activity plan")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CreateActivityPlanRequest lengthMinutes(Integer lengthMinutes) {
        this.lengthMinutes = lengthMinutes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The length in minutes of the activity plan")
    @JsonProperty(value="lengthMinutes")
    public Integer getLengthMinutes() {
        return this.lengthMinutes;
    }

    public void setLengthMinutes(Integer lengthMinutes) {
        this.lengthMinutes = lengthMinutes;
    }

    public CreateActivityPlanRequest initialSchedulePeriod(SchedulingPeriod initialSchedulePeriod) {
        this.initialSchedulePeriod = initialSchedulePeriod;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The initial scheduling period for the activity plan")
    @JsonProperty(value="initialSchedulePeriod")
    public SchedulingPeriod getInitialSchedulePeriod() {
        return this.initialSchedulePeriod;
    }

    public void setInitialSchedulePeriod(SchedulingPeriod initialSchedulePeriod) {
        this.initialSchedulePeriod = initialSchedulePeriod;
    }

    public CreateActivityPlanRequest groupSettings(GroupSettings groupSettings) {
        this.groupSettings = groupSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="Group settings for the activity plan")
    @JsonProperty(value="groupSettings")
    public GroupSettings getGroupSettings() {
        return this.groupSettings;
    }

    public void setGroupSettings(GroupSettings groupSettings) {
        this.groupSettings = groupSettings;
    }

    public CreateActivityPlanRequest recurrenceSettings(RecurrenceSettings recurrenceSettings) {
        this.recurrenceSettings = recurrenceSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="Settings controlling recurrence for the activity plan. If not set the activity plan will only occur once")
    @JsonProperty(value="recurrenceSettings")
    public RecurrenceSettings getRecurrenceSettings() {
        return this.recurrenceSettings;
    }

    public void setRecurrenceSettings(RecurrenceSettings recurrenceSettings) {
        this.recurrenceSettings = recurrenceSettings;
    }

    public CreateActivityPlanRequest attendeesSearchRule(UserSearchRule attendeesSearchRule) {
        this.attendeesSearchRule = attendeesSearchRule;
        return this;
    }

    @ApiModelProperty(example="null", value="Attendee search rule for this activity plan")
    @JsonProperty(value="attendeesSearchRule")
    public UserSearchRule getAttendeesSearchRule() {
        return this.attendeesSearchRule;
    }

    public void setAttendeesSearchRule(UserSearchRule attendeesSearchRule) {
        this.attendeesSearchRule = attendeesSearchRule;
    }

    public CreateActivityPlanRequest facilitated(Boolean facilitated) {
        this.facilitated = facilitated;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the sessions created by this activity plan should be facilitated")
    @JsonProperty(value="facilitated")
    public Boolean getFacilitated() {
        return this.facilitated;
    }

    public void setFacilitated(Boolean facilitated) {
        this.facilitated = facilitated;
    }

    public CreateActivityPlanRequest facilitatorsSearchRule(UserSearchRule facilitatorsSearchRule) {
        this.facilitatorsSearchRule = facilitatorsSearchRule;
        return this;
    }

    @ApiModelProperty(example="null", value="Facilitator search rule for this activity plan")
    @JsonProperty(value="facilitatorsSearchRule")
    public UserSearchRule getFacilitatorsSearchRule() {
        return this.facilitatorsSearchRule;
    }

    public void setFacilitatorsSearchRule(UserSearchRule facilitatorsSearchRule) {
        this.facilitatorsSearchRule = facilitatorsSearchRule;
    }

    public CreateActivityPlanRequest transitionTimeMinutes(Integer transitionTimeMinutes) {
        this.transitionTimeMinutes = transitionTimeMinutes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Transition time in minutes between facilitated sessions")
    @JsonProperty(value="transitionTimeMinutes")
    public Integer getTransitionTimeMinutes() {
        return this.transitionTimeMinutes;
    }

    public void setTransitionTimeMinutes(Integer transitionTimeMinutes) {
        this.transitionTimeMinutes = transitionTimeMinutes;
    }

    public CreateActivityPlanRequest serviceGoalImpactOverrides(ActivityPlanServiceGoalImpactOverrides serviceGoalImpactOverrides) {
        this.serviceGoalImpactOverrides = serviceGoalImpactOverrides;
        return this;
    }

    @ApiModelProperty(example="null", value="Allowable service goal impact override settings for this activity plan. If not set the business unit setting will be used")
    @JsonProperty(value="serviceGoalImpactOverrides")
    public ActivityPlanServiceGoalImpactOverrides getServiceGoalImpactOverrides() {
        return this.serviceGoalImpactOverrides;
    }

    public void setServiceGoalImpactOverrides(ActivityPlanServiceGoalImpactOverrides serviceGoalImpactOverrides) {
        this.serviceGoalImpactOverrides = serviceGoalImpactOverrides;
    }

    public CreateActivityPlanRequest optimizationObjective(OptimizationObjectiveEnum optimizationObjective) {
        this.optimizationObjective = optimizationObjective;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The optimization objective of this activity plan")
    @JsonProperty(value="optimizationObjective")
    public OptimizationObjectiveEnum getOptimizationObjective() {
        return this.optimizationObjective;
    }

    public void setOptimizationObjective(OptimizationObjectiveEnum optimizationObjective) {
        this.optimizationObjective = optimizationObjective;
    }

    public CreateActivityPlanRequest state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The state of this activity plan")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public CreateActivityPlanRequest countsAsPaidTime(Boolean countsAsPaidTime) {
        this.countsAsPaidTime = countsAsPaidTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether the activity should count as paid time")
    @JsonProperty(value="countsAsPaidTime")
    public Boolean getCountsAsPaidTime() {
        return this.countsAsPaidTime;
    }

    public void setCountsAsPaidTime(Boolean countsAsPaidTime) {
        this.countsAsPaidTime = countsAsPaidTime;
    }

    public CreateActivityPlanRequest fixedAvailability(List<FixedAvailability> fixedAvailability) {
        this.fixedAvailability = fixedAvailability;
        return this;
    }

    @ApiModelProperty(example="null", value="Fixed availability configuration for the activity plan")
    @JsonProperty(value="fixedAvailability")
    public List<FixedAvailability> getFixedAvailability() {
        return this.fixedAvailability;
    }

    public void setFixedAvailability(List<FixedAvailability> fixedAvailability) {
        this.fixedAvailability = fixedAvailability;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateActivityPlanRequest createActivityPlanRequest = (CreateActivityPlanRequest)o;
        return Objects.equals(this.name, createActivityPlanRequest.name) && Objects.equals(this.managementUnitIds, createActivityPlanRequest.managementUnitIds) && Objects.equals(this.description, createActivityPlanRequest.description) && Objects.equals(this.activityCodeId, createActivityPlanRequest.activityCodeId) && Objects.equals((Object)this.type, (Object)createActivityPlanRequest.type) && Objects.equals(this.lengthMinutes, createActivityPlanRequest.lengthMinutes) && Objects.equals(this.initialSchedulePeriod, createActivityPlanRequest.initialSchedulePeriod) && Objects.equals(this.groupSettings, createActivityPlanRequest.groupSettings) && Objects.equals(this.recurrenceSettings, createActivityPlanRequest.recurrenceSettings) && Objects.equals(this.attendeesSearchRule, createActivityPlanRequest.attendeesSearchRule) && Objects.equals(this.facilitated, createActivityPlanRequest.facilitated) && Objects.equals(this.facilitatorsSearchRule, createActivityPlanRequest.facilitatorsSearchRule) && Objects.equals(this.transitionTimeMinutes, createActivityPlanRequest.transitionTimeMinutes) && Objects.equals(this.serviceGoalImpactOverrides, createActivityPlanRequest.serviceGoalImpactOverrides) && Objects.equals((Object)this.optimizationObjective, (Object)createActivityPlanRequest.optimizationObjective) && Objects.equals((Object)this.state, (Object)createActivityPlanRequest.state) && Objects.equals(this.countsAsPaidTime, createActivityPlanRequest.countsAsPaidTime) && Objects.equals(this.fixedAvailability, createActivityPlanRequest.fixedAvailability);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.managementUnitIds, this.description, this.activityCodeId, this.type, this.lengthMinutes, this.initialSchedulePeriod, this.groupSettings, this.recurrenceSettings, this.attendeesSearchRule, this.facilitated, this.facilitatorsSearchRule, this.transitionTimeMinutes, this.serviceGoalImpactOverrides, this.optimizationObjective, this.state, this.countsAsPaidTime, this.fixedAvailability});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateActivityPlanRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    managementUnitIds: ").append(this.toIndentedString(this.managementUnitIds)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    activityCodeId: ").append(this.toIndentedString(this.activityCodeId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    lengthMinutes: ").append(this.toIndentedString(this.lengthMinutes)).append("\n");
        sb.append("    initialSchedulePeriod: ").append(this.toIndentedString(this.initialSchedulePeriod)).append("\n");
        sb.append("    groupSettings: ").append(this.toIndentedString(this.groupSettings)).append("\n");
        sb.append("    recurrenceSettings: ").append(this.toIndentedString(this.recurrenceSettings)).append("\n");
        sb.append("    attendeesSearchRule: ").append(this.toIndentedString(this.attendeesSearchRule)).append("\n");
        sb.append("    facilitated: ").append(this.toIndentedString(this.facilitated)).append("\n");
        sb.append("    facilitatorsSearchRule: ").append(this.toIndentedString(this.facilitatorsSearchRule)).append("\n");
        sb.append("    transitionTimeMinutes: ").append(this.toIndentedString(this.transitionTimeMinutes)).append("\n");
        sb.append("    serviceGoalImpactOverrides: ").append(this.toIndentedString(this.serviceGoalImpactOverrides)).append("\n");
        sb.append("    optimizationObjective: ").append(this.toIndentedString((Object)this.optimizationObjective)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    countsAsPaidTime: ").append(this.toIndentedString(this.countsAsPaidTime)).append("\n");
        sb.append("    fixedAvailability: ").append(this.toIndentedString(this.fixedAvailability)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INDIVIDUAL("Individual"),
        GROUP("Group");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=OptimizationObjectiveEnumDeserializer.class)
    public static enum OptimizationObjectiveEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        FAVORSERVICEGOALS("FavorServiceGoals"),
        FAVORSCHEDULINGALL("FavorSchedulingAll");

        private String value;

        private OptimizationObjectiveEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OptimizationObjectiveEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OptimizationObjectiveEnum value : OptimizationObjectiveEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OptimizationObjectiveEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("Active"),
        INACTIVE("Inactive");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class OptimizationObjectiveEnumDeserializer
    extends StdDeserializer<OptimizationObjectiveEnum> {
        public OptimizationObjectiveEnumDeserializer() {
            super(OptimizationObjectiveEnumDeserializer.class);
        }

        public OptimizationObjectiveEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OptimizationObjectiveEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

