/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.JourneyView;
import java.util.HashMap;
import java.util.Map;

public class PutJourneyViewVersionRequest {
    private String viewId;
    private String versionId;
    private JourneyView body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public PutJourneyViewVersionRequest withViewId(String viewId) {
        this.setViewId(viewId);
        return this;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public PutJourneyViewVersionRequest withVersionId(String versionId) {
        this.setVersionId(versionId);
        return this;
    }

    public JourneyView getBody() {
        return this.body;
    }

    public void setBody(JourneyView body) {
        this.body = body;
    }

    public PutJourneyViewVersionRequest withBody(JourneyView body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutJourneyViewVersionRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<JourneyView> withHttpInfo() {
        if (this.viewId == null) {
            throw new IllegalStateException("Missing the required parameter 'viewId' when building request for PutJourneyViewVersionRequest.");
        }
        if (this.versionId == null) {
            throw new IllegalStateException("Missing the required parameter 'versionId' when building request for PutJourneyViewVersionRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutJourneyViewVersionRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/journey/views/{viewId}/versions/{versionId}").withPathParameter("viewId", this.viewId).withPathParameter("versionId", this.versionId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String viewId, String versionId, JourneyView body) {
        return new Builder().withRequiredParams(viewId, versionId, body);
    }

    public static class Builder {
        private final PutJourneyViewVersionRequest request = new PutJourneyViewVersionRequest();

        private Builder() {
        }

        public Builder withViewId(String viewId) {
            this.request.setViewId(viewId);
            return this;
        }

        public Builder withVersionId(String versionId) {
            this.request.setVersionId(versionId);
            return this;
        }

        public Builder withBody(JourneyView body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String viewId, String versionId, JourneyView body) {
            this.request.setViewId(viewId);
            this.request.setVersionId(versionId);
            this.request.setBody(body);
            return this;
        }

        public PutJourneyViewVersionRequest build() {
            if (this.request.viewId == null) {
                throw new IllegalStateException("Missing the required parameter 'viewId' when building request for PutJourneyViewVersionRequest.");
            }
            if (this.request.versionId == null) {
                throw new IllegalStateException("Missing the required parameter 'versionId' when building request for PutJourneyViewVersionRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutJourneyViewVersionRequest.");
            }
            return this.request;
        }
    }
}

