/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.MatchCriteria;
import com.mypurecloud.sdk.v2.model.TriggerTarget;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UpdateTriggerRequest
implements Serializable {
    private Long version = null;
    private Boolean enabled = null;
    private TriggerTarget target = null;
    private List<MatchCriteria> matchCriteria = new ArrayList<MatchCriteria>();
    private String name = null;
    private String topicName = null;
    private Integer eventTTLSeconds = null;
    private Integer delayBySeconds = null;
    private String description = null;

    public UpdateTriggerRequest version(Long version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version of this trigger")
    @JsonProperty(value="version")
    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public UpdateTriggerRequest enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Boolean indicating if Trigger is enabled")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public UpdateTriggerRequest target(TriggerTarget target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The target to invoke when a matching event is received")
    @JsonProperty(value="target")
    public TriggerTarget getTarget() {
        return this.target;
    }

    public void setTarget(TriggerTarget target) {
        this.target = target;
    }

    public UpdateTriggerRequest matchCriteria(List<MatchCriteria> matchCriteria) {
        this.matchCriteria = matchCriteria;
        return this;
    }

    @ApiModelProperty(example="null", value="The configuration for when a trigger is considered to be a match for an event")
    @JsonProperty(value="matchCriteria")
    public List<MatchCriteria> getMatchCriteria() {
        return this.matchCriteria;
    }

    public void setMatchCriteria(List<MatchCriteria> matchCriteria) {
        this.matchCriteria = matchCriteria;
    }

    public UpdateTriggerRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the trigger")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UpdateTriggerRequest topicName(String topicName) {
        this.topicName = topicName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The topic that will cause the trigger to be invoked. Must match existing trigger topicName.")
    @JsonProperty(value="topicName")
    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public UpdateTriggerRequest eventTTLSeconds(Integer eventTTLSeconds) {
        this.eventTTLSeconds = eventTTLSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Optional length of time that events are meaningful after origination. Events older than this threshold may be dropped if the platform is delayed in processing events. Unset means events are valid indefinitely, otherwise must be set to at least 10 seconds. Only one of eventTTLSeconds or delayBySeconds can be set.")
    @JsonProperty(value="eventTTLSeconds")
    public Integer getEventTTLSeconds() {
        return this.eventTTLSeconds;
    }

    public void setEventTTLSeconds(Integer eventTTLSeconds) {
        this.eventTTLSeconds = eventTTLSeconds;
    }

    public UpdateTriggerRequest delayBySeconds(Integer delayBySeconds) {
        this.delayBySeconds = delayBySeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Optional delay invoking target after trigger fires. Must be in the range of 60 to 900 seconds. Only one of eventTTLSeconds or delayBySeconds can be set.")
    @JsonProperty(value="delayBySeconds")
    public Integer getDelayBySeconds() {
        return this.delayBySeconds;
    }

    public void setDelayBySeconds(Integer delayBySeconds) {
        this.delayBySeconds = delayBySeconds;
    }

    public UpdateTriggerRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Description of the trigger. Can be up to 512 characters in length.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateTriggerRequest updateTriggerRequest = (UpdateTriggerRequest)o;
        return Objects.equals(this.version, updateTriggerRequest.version) && Objects.equals(this.enabled, updateTriggerRequest.enabled) && Objects.equals(this.target, updateTriggerRequest.target) && Objects.equals(this.matchCriteria, updateTriggerRequest.matchCriteria) && Objects.equals(this.name, updateTriggerRequest.name) && Objects.equals(this.topicName, updateTriggerRequest.topicName) && Objects.equals(this.eventTTLSeconds, updateTriggerRequest.eventTTLSeconds) && Objects.equals(this.delayBySeconds, updateTriggerRequest.delayBySeconds) && Objects.equals(this.description, updateTriggerRequest.description);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.enabled, this.target, this.matchCriteria, this.name, this.topicName, this.eventTTLSeconds, this.delayBySeconds, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateTriggerRequest {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    matchCriteria: ").append(this.toIndentedString(this.matchCriteria)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    topicName: ").append(this.toIndentedString(this.topicName)).append("\n");
        sb.append("    eventTTLSeconds: ").append(this.toIndentedString(this.eventTTLSeconds)).append("\n");
        sb.append("    delayBySeconds: ").append(this.toIndentedString(this.delayBySeconds)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

