/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AnswerGenerationConfig;
import com.mypurecloud.sdk.v2.model.KnowledgeAnswerConfig;
import com.mypurecloud.sdk.v2.model.NluConfig;
import com.mypurecloud.sdk.v2.model.RuleEngineConfig;
import com.mypurecloud.sdk.v2.model.SummaryGenerationConfig;
import com.mypurecloud.sdk.v2.model.WrapupCodePredictionConfig;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class Copilot
implements Serializable {
    private Boolean enabled = null;
    private Boolean liveOnQueue = null;
    private String defaultLanguage = null;
    private KnowledgeAnswerConfig knowledgeAnswerConfig = null;
    private SummaryGenerationConfig summaryGenerationConfig = null;
    private WrapupCodePredictionConfig wrapupCodePredictionConfig = null;
    private AnswerGenerationConfig answerGenerationConfig = null;
    private NluEngineTypeEnum nluEngineType = null;
    private NluConfig nluConfig = null;
    private RuleEngineConfig ruleEngineConfig = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="Copilot is enabled.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public Copilot liveOnQueue(Boolean liveOnQueue) {
        this.liveOnQueue = liveOnQueue;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Copilot is live on selected queue.")
    @JsonProperty(value="liveOnQueue")
    public Boolean getLiveOnQueue() {
        return this.liveOnQueue;
    }

    public void setLiveOnQueue(Boolean liveOnQueue) {
        this.liveOnQueue = liveOnQueue;
    }

    public Copilot defaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Copilot default language, e.g. [en-US, es-US, es-ES]. Once set, it can not be modified.")
    @JsonProperty(value="defaultLanguage")
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public Copilot knowledgeAnswerConfig(KnowledgeAnswerConfig knowledgeAnswerConfig) {
        this.knowledgeAnswerConfig = knowledgeAnswerConfig;
        return this;
    }

    @ApiModelProperty(example="null", value="Knowledge answer configuration.")
    @JsonProperty(value="knowledgeAnswerConfig")
    public KnowledgeAnswerConfig getKnowledgeAnswerConfig() {
        return this.knowledgeAnswerConfig;
    }

    public void setKnowledgeAnswerConfig(KnowledgeAnswerConfig knowledgeAnswerConfig) {
        this.knowledgeAnswerConfig = knowledgeAnswerConfig;
    }

    public Copilot summaryGenerationConfig(SummaryGenerationConfig summaryGenerationConfig) {
        this.summaryGenerationConfig = summaryGenerationConfig;
        return this;
    }

    @ApiModelProperty(example="null", value="Copilot generated summary configuration.")
    @JsonProperty(value="summaryGenerationConfig")
    public SummaryGenerationConfig getSummaryGenerationConfig() {
        return this.summaryGenerationConfig;
    }

    public void setSummaryGenerationConfig(SummaryGenerationConfig summaryGenerationConfig) {
        this.summaryGenerationConfig = summaryGenerationConfig;
    }

    public Copilot wrapupCodePredictionConfig(WrapupCodePredictionConfig wrapupCodePredictionConfig) {
        this.wrapupCodePredictionConfig = wrapupCodePredictionConfig;
        return this;
    }

    @ApiModelProperty(example="null", value="Copilot generated wrapup code prediction configuration.")
    @JsonProperty(value="wrapupCodePredictionConfig")
    public WrapupCodePredictionConfig getWrapupCodePredictionConfig() {
        return this.wrapupCodePredictionConfig;
    }

    public void setWrapupCodePredictionConfig(WrapupCodePredictionConfig wrapupCodePredictionConfig) {
        this.wrapupCodePredictionConfig = wrapupCodePredictionConfig;
    }

    public Copilot answerGenerationConfig(AnswerGenerationConfig answerGenerationConfig) {
        this.answerGenerationConfig = answerGenerationConfig;
        return this;
    }

    @ApiModelProperty(example="null", value="Answer generation configuration.")
    @JsonProperty(value="answerGenerationConfig")
    public AnswerGenerationConfig getAnswerGenerationConfig() {
        return this.answerGenerationConfig;
    }

    public void setAnswerGenerationConfig(AnswerGenerationConfig answerGenerationConfig) {
        this.answerGenerationConfig = answerGenerationConfig;
    }

    public Copilot nluEngineType(NluEngineTypeEnum nluEngineType) {
        this.nluEngineType = nluEngineType;
        return this;
    }

    @ApiModelProperty(example="null", value="Language understanding engine type.")
    @JsonProperty(value="nluEngineType")
    public NluEngineTypeEnum getNluEngineType() {
        return this.nluEngineType;
    }

    public void setNluEngineType(NluEngineTypeEnum nluEngineType) {
        this.nluEngineType = nluEngineType;
    }

    public Copilot nluConfig(NluConfig nluConfig) {
        this.nluConfig = nluConfig;
        return this;
    }

    @ApiModelProperty(example="null", value="NLU configuration.")
    @JsonProperty(value="nluConfig")
    public NluConfig getNluConfig() {
        return this.nluConfig;
    }

    public void setNluConfig(NluConfig nluConfig) {
        this.nluConfig = nluConfig;
    }

    public Copilot ruleEngineConfig(RuleEngineConfig ruleEngineConfig) {
        this.ruleEngineConfig = ruleEngineConfig;
        return this;
    }

    @ApiModelProperty(example="null", value="Rule engine configuration.")
    @JsonProperty(value="ruleEngineConfig")
    public RuleEngineConfig getRuleEngineConfig() {
        return this.ruleEngineConfig;
    }

    public void setRuleEngineConfig(RuleEngineConfig ruleEngineConfig) {
        this.ruleEngineConfig = ruleEngineConfig;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Copilot copilot = (Copilot)o;
        return Objects.equals(this.enabled, copilot.enabled) && Objects.equals(this.liveOnQueue, copilot.liveOnQueue) && Objects.equals(this.defaultLanguage, copilot.defaultLanguage) && Objects.equals(this.knowledgeAnswerConfig, copilot.knowledgeAnswerConfig) && Objects.equals(this.summaryGenerationConfig, copilot.summaryGenerationConfig) && Objects.equals(this.wrapupCodePredictionConfig, copilot.wrapupCodePredictionConfig) && Objects.equals(this.answerGenerationConfig, copilot.answerGenerationConfig) && Objects.equals((Object)this.nluEngineType, (Object)copilot.nluEngineType) && Objects.equals(this.nluConfig, copilot.nluConfig) && Objects.equals(this.ruleEngineConfig, copilot.ruleEngineConfig) && Objects.equals(this.selfUri, copilot.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.liveOnQueue, this.defaultLanguage, this.knowledgeAnswerConfig, this.summaryGenerationConfig, this.wrapupCodePredictionConfig, this.answerGenerationConfig, this.nluEngineType, this.nluConfig, this.ruleEngineConfig, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Copilot {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    liveOnQueue: ").append(this.toIndentedString(this.liveOnQueue)).append("\n");
        sb.append("    defaultLanguage: ").append(this.toIndentedString(this.defaultLanguage)).append("\n");
        sb.append("    knowledgeAnswerConfig: ").append(this.toIndentedString(this.knowledgeAnswerConfig)).append("\n");
        sb.append("    summaryGenerationConfig: ").append(this.toIndentedString(this.summaryGenerationConfig)).append("\n");
        sb.append("    wrapupCodePredictionConfig: ").append(this.toIndentedString(this.wrapupCodePredictionConfig)).append("\n");
        sb.append("    answerGenerationConfig: ").append(this.toIndentedString(this.answerGenerationConfig)).append("\n");
        sb.append("    nluEngineType: ").append(this.toIndentedString((Object)this.nluEngineType)).append("\n");
        sb.append("    nluConfig: ").append(this.toIndentedString(this.nluConfig)).append("\n");
        sb.append("    ruleEngineConfig: ").append(this.toIndentedString(this.ruleEngineConfig)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=NluEngineTypeEnumDeserializer.class)
    public static enum NluEngineTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NLUV3("NluV3");

        private String value;

        private NluEngineTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static NluEngineTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (NluEngineTypeEnum value : NluEngineTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return NluEngineTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class NluEngineTypeEnumDeserializer
    extends StdDeserializer<NluEngineTypeEnum> {
        public NluEngineTypeEnumDeserializer() {
            super(NluEngineTypeEnumDeserializer.class);
        }

        public NluEngineTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return NluEngineTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

