/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.AlertSummaryEntity;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AlertSummary
implements Serializable {
    private List<AlertSummaryEntity> entities = new ArrayList<AlertSummaryEntity>();
    private AddressableEntityRef conversation = null;
    private MetricTypeEnum metricType = null;
    private Boolean entitiesAreTeamMembers = null;

    public AlertSummary entities(List<AlertSummaryEntity> entities) {
        this.entities = entities;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The entities who violated the rule condition over the duration of the alert.")
    @JsonProperty(value="entities")
    public List<AlertSummaryEntity> getEntities() {
        return this.entities;
    }

    public void setEntities(List<AlertSummaryEntity> entities) {
        this.entities = entities;
    }

    public AlertSummary conversation(AddressableEntityRef conversation) {
        this.conversation = conversation;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the conversation that triggered the alert.  Only used for alerts based on instance-based conversation metrics.")
    @JsonProperty(value="conversation")
    public AddressableEntityRef getConversation() {
        return this.conversation;
    }

    public void setConversation(AddressableEntityRef conversation) {
        this.conversation = conversation;
    }

    public AlertSummary metricType(MetricTypeEnum metricType) {
        this.metricType = metricType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The metric type that is monitored.")
    @JsonProperty(value="metricType")
    public MetricTypeEnum getMetricType() {
        return this.metricType;
    }

    public void setMetricType(MetricTypeEnum metricType) {
        this.metricType = metricType;
    }

    public AlertSummary entitiesAreTeamMembers(Boolean entitiesAreTeamMembers) {
        this.entitiesAreTeamMembers = entitiesAreTeamMembers;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Flag that indicated whether or not the alert is for a rule with a condition for all members of a team.")
    @JsonProperty(value="entitiesAreTeamMembers")
    public Boolean getEntitiesAreTeamMembers() {
        return this.entitiesAreTeamMembers;
    }

    public void setEntitiesAreTeamMembers(Boolean entitiesAreTeamMembers) {
        this.entitiesAreTeamMembers = entitiesAreTeamMembers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlertSummary alertSummary = (AlertSummary)o;
        return Objects.equals(this.entities, alertSummary.entities) && Objects.equals(this.conversation, alertSummary.conversation) && Objects.equals((Object)this.metricType, (Object)alertSummary.metricType) && Objects.equals(this.entitiesAreTeamMembers, alertSummary.entitiesAreTeamMembers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entities, this.conversation, this.metricType, this.entitiesAreTeamMembers});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlertSummary {\n");
        sb.append("    entities: ").append(this.toIndentedString(this.entities)).append("\n");
        sb.append("    conversation: ").append(this.toIndentedString(this.conversation)).append("\n");
        sb.append("    metricType: ").append(this.toIndentedString((Object)this.metricType)).append("\n");
        sb.append("    entitiesAreTeamMembers: ").append(this.toIndentedString(this.entitiesAreTeamMembers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MetricTypeEnumDeserializer.class)
    public static enum MetricTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INTERVAL("Interval"),
        INSTANCE("Instance");

        private String value;

        private MetricTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricTypeEnum value : MetricTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MetricTypeEnumDeserializer
    extends StdDeserializer<MetricTypeEnum> {
        public MetricTypeEnumDeserializer() {
            super(MetricTypeEnumDeserializer.class);
        }

        public MetricTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MetricTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

