/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.UnreadFields;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class AlertRequest
implements Serializable {
    private TypeEnum type = null;
    private Date dateStart = null;
    private Date dateEnd = null;
    private UnreadFields unread = null;
    private Boolean validRequest = null;

    public AlertRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The action being taken on the alert.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public AlertRequest dateStart(Date dateStart) {
        this.dateStart = dateStart;
        return this;
    }

    @ApiModelProperty(example="null", value="The start date of the mute/snooze period. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateStart")
    public Date getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(Date dateStart) {
        this.dateStart = dateStart;
    }

    public AlertRequest dateEnd(Date dateEnd) {
        this.dateEnd = dateEnd;
        return this;
    }

    @ApiModelProperty(example="null", value="The end date of the mute/snooze period. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateEnd")
    public Date getDateEnd() {
        return this.dateEnd;
    }

    public void setDateEnd(Date dateEnd) {
        this.dateEnd = dateEnd;
    }

    public AlertRequest unread(UnreadFields unread) {
        this.unread = unread;
        return this;
    }

    @ApiModelProperty(example="null", value="The fields need for an unread update requests")
    @JsonProperty(value="unread")
    public UnreadFields getUnread() {
        return this.unread;
    }

    public void setUnread(UnreadFields unread) {
        this.unread = unread;
    }

    public AlertRequest validRequest(Boolean validRequest) {
        this.validRequest = validRequest;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="validRequest")
    public Boolean getValidRequest() {
        return this.validRequest;
    }

    public void setValidRequest(Boolean validRequest) {
        this.validRequest = validRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlertRequest alertRequest = (AlertRequest)o;
        return Objects.equals((Object)this.type, (Object)alertRequest.type) && Objects.equals(this.dateStart, alertRequest.dateStart) && Objects.equals(this.dateEnd, alertRequest.dateEnd) && Objects.equals(this.unread, alertRequest.unread) && Objects.equals(this.validRequest, alertRequest.validRequest);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.dateStart, this.dateEnd, this.unread, this.validRequest});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlertRequest {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    dateStart: ").append(this.toIndentedString(this.dateStart)).append("\n");
        sb.append("    dateEnd: ").append(this.toIndentedString(this.dateEnd)).append("\n");
        sb.append("    unread: ").append(this.toIndentedString(this.unread)).append("\n");
        sb.append("    validRequest: ").append(this.toIndentedString(this.validRequest)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MUTE("Mute"),
        SNOOZE("Snooze"),
        UNREAD("Unread");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

