/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Work plan bid reference")
public class AgentWorkPlanBid
implements Serializable {
    private String id = null;
    private String name = null;
    private LocalDate bidWindowStartDate = null;
    private LocalDate bidWindowEndDate = null;
    private LocalDate effectiveDate = null;
    private StatusEnum status = null;
    private List<WorkPlanFieldsVisibleToAgentsEnum> workPlanFieldsVisibleToAgents = new ArrayList<WorkPlanFieldsVisibleToAgentsEnum>();
    private String selfUri = null;

    public AgentWorkPlanBid id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the work plan bid")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AgentWorkPlanBid name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AgentWorkPlanBid bidWindowStartDate(LocalDate bidWindowStartDate) {
        this.bidWindowStartDate = bidWindowStartDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The date when agents can start participating in work plan bidding. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="bidWindowStartDate")
    public LocalDate getBidWindowStartDate() {
        return this.bidWindowStartDate;
    }

    public void setBidWindowStartDate(LocalDate bidWindowStartDate) {
        this.bidWindowStartDate = bidWindowStartDate;
    }

    public AgentWorkPlanBid bidWindowEndDate(LocalDate bidWindowEndDate) {
        this.bidWindowEndDate = bidWindowEndDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The inclusive end date of a bid window. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="bidWindowEndDate")
    public LocalDate getBidWindowEndDate() {
        return this.bidWindowEndDate;
    }

    public void setBidWindowEndDate(LocalDate bidWindowEndDate) {
        this.bidWindowEndDate = bidWindowEndDate;
    }

    public AgentWorkPlanBid effectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The date when agents will be assigned to the new work plan. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="effectiveDate")
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public AgentWorkPlanBid status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The state of the bid")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AgentWorkPlanBid workPlanFieldsVisibleToAgents(List<WorkPlanFieldsVisibleToAgentsEnum> workPlanFieldsVisibleToAgents) {
        this.workPlanFieldsVisibleToAgents = workPlanFieldsVisibleToAgents;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The work plan fields visible to agents whenever work plan preferences are made")
    @JsonProperty(value="workPlanFieldsVisibleToAgents")
    public List<WorkPlanFieldsVisibleToAgentsEnum> getWorkPlanFieldsVisibleToAgents() {
        return this.workPlanFieldsVisibleToAgents;
    }

    public void setWorkPlanFieldsVisibleToAgents(List<WorkPlanFieldsVisibleToAgentsEnum> workPlanFieldsVisibleToAgents) {
        this.workPlanFieldsVisibleToAgents = workPlanFieldsVisibleToAgents;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentWorkPlanBid agentWorkPlanBid = (AgentWorkPlanBid)o;
        return Objects.equals(this.id, agentWorkPlanBid.id) && Objects.equals(this.name, agentWorkPlanBid.name) && Objects.equals(this.bidWindowStartDate, agentWorkPlanBid.bidWindowStartDate) && Objects.equals(this.bidWindowEndDate, agentWorkPlanBid.bidWindowEndDate) && Objects.equals(this.effectiveDate, agentWorkPlanBid.effectiveDate) && Objects.equals((Object)this.status, (Object)agentWorkPlanBid.status) && Objects.equals(this.workPlanFieldsVisibleToAgents, agentWorkPlanBid.workPlanFieldsVisibleToAgents) && Objects.equals(this.selfUri, agentWorkPlanBid.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.bidWindowStartDate, this.bidWindowEndDate, this.effectiveDate, this.status, this.workPlanFieldsVisibleToAgents, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgentWorkPlanBid {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    bidWindowStartDate: ").append(this.toIndentedString(this.bidWindowStartDate)).append("\n");
        sb.append("    bidWindowEndDate: ").append(this.toIndentedString(this.bidWindowEndDate)).append("\n");
        sb.append("    effectiveDate: ").append(this.toIndentedString(this.effectiveDate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    workPlanFieldsVisibleToAgents: ").append(this.toIndentedString(this.workPlanFieldsVisibleToAgents)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DRAFT("Draft"),
        LOCKED("Locked"),
        OPTIMIZED("Optimized"),
        SCHEDULED("Scheduled"),
        OPEN("Open"),
        CLOSED("Closed"),
        PROCESSED("Processed"),
        PUBLISHED("Published");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=WorkPlanFieldsVisibleToAgentsEnumDeserializer.class)
    public static enum WorkPlanFieldsVisibleToAgentsEnum {
        NAME("Name"),
        PAIDHOURS("PaidHours");

        private String value;

        private WorkPlanFieldsVisibleToAgentsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static WorkPlanFieldsVisibleToAgentsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (WorkPlanFieldsVisibleToAgentsEnum value : WorkPlanFieldsVisibleToAgentsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return WorkPlanFieldsVisibleToAgentsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class WorkPlanFieldsVisibleToAgentsEnumDeserializer
    extends StdDeserializer<WorkPlanFieldsVisibleToAgentsEnum> {
        public WorkPlanFieldsVisibleToAgentsEnumDeserializer() {
            super(WorkPlanFieldsVisibleToAgentsEnumDeserializer.class);
        }

        public WorkPlanFieldsVisibleToAgentsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return WorkPlanFieldsVisibleToAgentsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

