/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class RecognitionBase
implements Serializable {
    private String id = null;
    private UserReference recipient = null;
    private UserReference createdBy = null;
    private Date dateCreated = null;
    private TypeEnum type = null;
    private String title = null;
    private String note = null;
    private ContextTypeEnum contextType = null;
    private String contextId = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public RecognitionBase recipient(UserReference recipient) {
        this.recipient = recipient;
        return this;
    }

    @ApiModelProperty(example="null", value="The recipient of the recognition")
    @JsonProperty(value="recipient")
    public UserReference getRecipient() {
        return this.recipient;
    }

    public void setRecipient(UserReference recipient) {
        this.recipient = recipient;
    }

    public RecognitionBase createdBy(UserReference createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The creator of the recognition")
    @JsonProperty(value="createdBy")
    public UserReference getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(UserReference createdBy) {
        this.createdBy = createdBy;
    }

    public RecognitionBase dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="2023-01-01T01:01:01Z", value="The creation date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public RecognitionBase type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of recognition")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public RecognitionBase title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", value="The recognition title")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public RecognitionBase note(String note) {
        this.note = note;
        return this;
    }

    @ApiModelProperty(example="null", value="The recognition note")
    @JsonProperty(value="note")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public RecognitionBase contextType(ContextTypeEnum contextType) {
        this.contextType = contextType;
        return this;
    }

    @ApiModelProperty(example="null", value="The context type (optional)")
    @JsonProperty(value="contextType")
    public ContextTypeEnum getContextType() {
        return this.contextType;
    }

    public void setContextType(ContextTypeEnum contextType) {
        this.contextType = contextType;
    }

    public RecognitionBase contextId(String contextId) {
        this.contextId = contextId;
        return this;
    }

    @ApiModelProperty(example="null", value="The context id (optional)")
    @JsonProperty(value="contextId")
    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecognitionBase recognitionBase = (RecognitionBase)o;
        return Objects.equals(this.id, recognitionBase.id) && Objects.equals(this.recipient, recognitionBase.recipient) && Objects.equals(this.createdBy, recognitionBase.createdBy) && Objects.equals(this.dateCreated, recognitionBase.dateCreated) && Objects.equals((Object)this.type, (Object)recognitionBase.type) && Objects.equals(this.title, recognitionBase.title) && Objects.equals(this.note, recognitionBase.note) && Objects.equals((Object)this.contextType, (Object)recognitionBase.contextType) && Objects.equals(this.contextId, recognitionBase.contextId) && Objects.equals(this.selfUri, recognitionBase.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.recipient, this.createdBy, this.dateCreated, this.type, this.title, this.note, this.contextType, this.contextId, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecognitionBase {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    note: ").append(this.toIndentedString(this.note)).append("\n");
        sb.append("    contextType: ").append(this.toIndentedString((Object)this.contextType)).append("\n");
        sb.append("    contextId: ").append(this.toIndentedString(this.contextId)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        THANKYOU("ThankYou"),
        CONGRATULATIONS("Congratulations"),
        HIGHPERFORMANCE("HighPerformance"),
        COMPANYVALUES("CompanyValues");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ContextTypeEnumDeserializer.class)
    public static enum ContextTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INTERACTION("Interaction"),
        INSIGHTS("Insights"),
        DEVELOPMENT("Development"),
        SCORECARD("Scorecard");

        private String value;

        private ContextTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ContextTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ContextTypeEnum value : ContextTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ContextTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ContextTypeEnumDeserializer
    extends StdDeserializer<ContextTypeEnum> {
        public ContextTypeEnumDeserializer() {
            super(ContextTypeEnumDeserializer.class);
        }

        public ContextTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ContextTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

