/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetRoutingQueueAssistantRequest {
    private String queueId;
    private String expand;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public GetRoutingQueueAssistantRequest withQueueId(String queueId) {
        this.setQueueId(queueId);
        return this;
    }

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public GetRoutingQueueAssistantRequest withExpand(String expand) {
        this.setExpand(expand);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetRoutingQueueAssistantRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.queueId == null) {
            throw new IllegalStateException("Missing the required parameter 'queueId' when building request for GetRoutingQueueAssistantRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/routing/queues/{queueId}/assistant").withPathParameter("queueId", this.queueId).withQueryParameters("expand", "", this.expand).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String queueId) {
        return new Builder().withRequiredParams(queueId);
    }

    public static class Builder {
        private final GetRoutingQueueAssistantRequest request = new GetRoutingQueueAssistantRequest();

        private Builder() {
        }

        public Builder withQueueId(String queueId) {
            this.request.setQueueId(queueId);
            return this;
        }

        public Builder withExpand(String expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withExpand(expandValues expand) {
            this.request.setExpand(expand.toString());
            return this;
        }

        public Builder withRequiredParams(String queueId) {
            this.request.setQueueId(queueId);
            return this;
        }

        public GetRoutingQueueAssistantRequest build() {
            if (this.request.queueId == null) {
                throw new IllegalStateException("Missing the required parameter 'queueId' when building request for GetRoutingQueueAssistantRequest.");
            }
            return this.request;
        }
    }

    public static enum expandValues {
        ASSISTANT("assistant");

        private String value;

        private expandValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static expandValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (expandValues value : expandValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return expandValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

