/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class Warning
implements Serializable {
    private Integer value = null;
    private RangeTypeEnum rangeType = null;
    private String color = null;

    public Warning value(Integer value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="The value for the warning configuration.")
    @JsonProperty(value="value")
    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public Warning rangeType(RangeTypeEnum rangeType) {
        this.rangeType = rangeType;
        return this;
    }

    @ApiModelProperty(example="null", value="The range type for the warning configuration.")
    @JsonProperty(value="rangeType")
    public RangeTypeEnum getRangeType() {
        return this.rangeType;
    }

    public void setRangeType(RangeTypeEnum rangeType) {
        this.rangeType = rangeType;
    }

    public Warning color(String color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(example="null", value="The color for the warning configuration in RGB hexadecimal format (for example \"#FF0000\" represents red).")
    @JsonProperty(value="color")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Warning warning = (Warning)o;
        return Objects.equals(this.value, warning.value) && Objects.equals((Object)this.rangeType, (Object)warning.rangeType) && Objects.equals(this.color, warning.color);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.rangeType, this.color});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Warning {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    rangeType: ").append(this.toIndentedString((Object)this.rangeType)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=RangeTypeEnumDeserializer.class)
    public static enum RangeTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OVER("OVER"),
        UNDER("UNDER"),
        BETWEEN("BETWEEN");

        private String value;

        private RangeTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RangeTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RangeTypeEnum value : RangeTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RangeTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class RangeTypeEnumDeserializer
    extends StdDeserializer<RangeTypeEnum> {
        public RangeTypeEnumDeserializer() {
            super(RangeTypeEnumDeserializer.class);
        }

        public RangeTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RangeTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

