/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class OutcomeAttributionJobStateResponse
implements Serializable {
    private String id = null;
    private StateEnum state = null;
    private String resultsUri = null;
    private Integer percentFailedThreshold = null;
    private String selfUri = null;
    private Date createdDate = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public OutcomeAttributionJobStateResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="State of job.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public OutcomeAttributionJobStateResponse resultsUri(String resultsUri) {
        this.resultsUri = resultsUri;
        return this;
    }

    @ApiModelProperty(example="null", value="URI where the query results can be retrieved.  Populated when job has reached a terminal state, i.e. no longer Running.")
    @JsonProperty(value="resultsUri")
    public String getResultsUri() {
        return this.resultsUri;
    }

    public void setResultsUri(String resultsUri) {
        this.resultsUri = resultsUri;
    }

    public OutcomeAttributionJobStateResponse percentFailedThreshold(Integer percentFailedThreshold) {
        this.percentFailedThreshold = percentFailedThreshold;
        return this;
    }

    @ApiModelProperty(example="null", value="Optional percent failed threshold for validation errors; if reached will halt the job. Default is 5 percent, allowed values 0 to 100.")
    @JsonProperty(value="percentFailedThreshold")
    public Integer getPercentFailedThreshold() {
        return this.percentFailedThreshold;
    }

    public void setPercentFailedThreshold(Integer percentFailedThreshold) {
        this.percentFailedThreshold = percentFailedThreshold;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public OutcomeAttributionJobStateResponse createdDate(Date createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date when the job was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="createdDate")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutcomeAttributionJobStateResponse outcomeAttributionJobStateResponse = (OutcomeAttributionJobStateResponse)o;
        return Objects.equals(this.id, outcomeAttributionJobStateResponse.id) && Objects.equals((Object)this.state, (Object)outcomeAttributionJobStateResponse.state) && Objects.equals(this.resultsUri, outcomeAttributionJobStateResponse.resultsUri) && Objects.equals(this.percentFailedThreshold, outcomeAttributionJobStateResponse.percentFailedThreshold) && Objects.equals(this.selfUri, outcomeAttributionJobStateResponse.selfUri) && Objects.equals(this.createdDate, outcomeAttributionJobStateResponse.createdDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.resultsUri, this.percentFailedThreshold, this.selfUri, this.createdDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OutcomeAttributionJobStateResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    resultsUri: ").append(this.toIndentedString(this.resultsUri)).append("\n");
        sb.append("    percentFailedThreshold: ").append(this.toIndentedString(this.percentFailedThreshold)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        RUNNING("Running"),
        COMPLETED("Completed"),
        COMPLETEDWITHERRORS("CompletedWithErrors"),
        FAILED("Failed");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

