/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.FlowActivityScoredAgent;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class FlowActivityEntityData
implements Serializable {
    private Date activityDate = null;
    private MetricEnum metric = null;
    private ActiveRoutingEnum activeRouting = null;
    private String addressFrom = null;
    private String addressTo = null;
    private String ani = null;
    private String conversationId = null;
    private String convertedFrom = null;
    private String convertedTo = null;
    private DirectionEnum direction = null;
    private String dnis = null;
    private String flowId = null;
    private FlowTypeEnum flowType = null;
    private MediaTypeEnum mediaType = null;
    private String participantName = null;
    private String queueId = null;
    private String requestedLanguageId = null;
    private List<String> requestedRoutingSkillIds = new ArrayList<String>();
    private List<RequestedRoutingsEnum> requestedRoutings = new ArrayList<RequestedRoutingsEnum>();
    private Long routingPriority = null;
    private String sessionId = null;
    private String teamId = null;
    private UsedRoutingEnum usedRouting = null;
    private String userId = null;
    private List<FlowActivityScoredAgent> scoredAgents = new ArrayList<FlowActivityScoredAgent>();

    public FlowActivityEntityData activityDate(Date activityDate) {
        this.activityDate = activityDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The time at which the activity was observed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="activityDate")
    public Date getActivityDate() {
        return this.activityDate;
    }

    public void setActivityDate(Date activityDate) {
        this.activityDate = activityDate;
    }

    public FlowActivityEntityData metric(MetricEnum metric) {
        this.metric = metric;
        return this;
    }

    @ApiModelProperty(example="null", value="Activity metric")
    @JsonProperty(value="metric")
    public MetricEnum getMetric() {
        return this.metric;
    }

    public void setMetric(MetricEnum metric) {
        this.metric = metric;
    }

    public FlowActivityEntityData activeRouting(ActiveRoutingEnum activeRouting) {
        this.activeRouting = activeRouting;
        return this;
    }

    @ApiModelProperty(example="null", value="Active routing method")
    @JsonProperty(value="activeRouting")
    public ActiveRoutingEnum getActiveRouting() {
        return this.activeRouting;
    }

    public void setActiveRouting(ActiveRoutingEnum activeRouting) {
        this.activeRouting = activeRouting;
    }

    public FlowActivityEntityData addressFrom(String addressFrom) {
        this.addressFrom = addressFrom;
        return this;
    }

    @ApiModelProperty(example="null", value="The address that initiated an action")
    @JsonProperty(value="addressFrom")
    public String getAddressFrom() {
        return this.addressFrom;
    }

    public void setAddressFrom(String addressFrom) {
        this.addressFrom = addressFrom;
    }

    public FlowActivityEntityData addressTo(String addressTo) {
        this.addressTo = addressTo;
        return this;
    }

    @ApiModelProperty(example="null", value="The address receiving an action")
    @JsonProperty(value="addressTo")
    public String getAddressTo() {
        return this.addressTo;
    }

    public void setAddressTo(String addressTo) {
        this.addressTo = addressTo;
    }

    public FlowActivityEntityData ani(String ani) {
        this.ani = ani;
        return this;
    }

    @ApiModelProperty(example="null", value="Automatic Number Identification (caller's number)")
    @JsonProperty(value="ani")
    public String getAni() {
        return this.ani;
    }

    public void setAni(String ani) {
        this.ani = ani;
    }

    public FlowActivityEntityData conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the conversation")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public FlowActivityEntityData convertedFrom(String convertedFrom) {
        this.convertedFrom = convertedFrom;
        return this;
    }

    @ApiModelProperty(example="null", value="Session media type that was converted from in case of a media type conversion")
    @JsonProperty(value="convertedFrom")
    public String getConvertedFrom() {
        return this.convertedFrom;
    }

    public void setConvertedFrom(String convertedFrom) {
        this.convertedFrom = convertedFrom;
    }

    public FlowActivityEntityData convertedTo(String convertedTo) {
        this.convertedTo = convertedTo;
        return this;
    }

    @ApiModelProperty(example="null", value="Session media type that was converted to in case of a media type conversion")
    @JsonProperty(value="convertedTo")
    public String getConvertedTo() {
        return this.convertedTo;
    }

    public void setConvertedTo(String convertedTo) {
        this.convertedTo = convertedTo;
    }

    public FlowActivityEntityData direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(example="null", value="The direction of the communication")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public FlowActivityEntityData dnis(String dnis) {
        this.dnis = dnis;
        return this;
    }

    @ApiModelProperty(example="null", value="Dialed number identification service (number dialed by the calling party)")
    @JsonProperty(value="dnis")
    public String getDnis() {
        return this.dnis;
    }

    public void setDnis(String dnis) {
        this.dnis = dnis;
    }

    public FlowActivityEntityData flowId(String flowId) {
        this.flowId = flowId;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique identifier of this flow")
    @JsonProperty(value="flowId")
    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public FlowActivityEntityData flowType(FlowTypeEnum flowType) {
        this.flowType = flowType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of this flow")
    @JsonProperty(value="flowType")
    public FlowTypeEnum getFlowType() {
        return this.flowType;
    }

    public void setFlowType(FlowTypeEnum flowType) {
        this.flowType = flowType;
    }

    public FlowActivityEntityData mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="The session media type")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public FlowActivityEntityData participantName(String participantName) {
        this.participantName = participantName;
        return this;
    }

    @ApiModelProperty(example="null", value="A human readable name identifying the participant")
    @JsonProperty(value="participantName")
    public String getParticipantName() {
        return this.participantName;
    }

    public void setParticipantName(String participantName) {
        this.participantName = participantName;
    }

    public FlowActivityEntityData queueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    @ApiModelProperty(example="null", value="Queue identifier")
    @JsonProperty(value="queueId")
    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public FlowActivityEntityData requestedLanguageId(String requestedLanguageId) {
        this.requestedLanguageId = requestedLanguageId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the language requested for an interaction")
    @JsonProperty(value="requestedLanguageId")
    public String getRequestedLanguageId() {
        return this.requestedLanguageId;
    }

    public void setRequestedLanguageId(String requestedLanguageId) {
        this.requestedLanguageId = requestedLanguageId;
    }

    public FlowActivityEntityData requestedRoutingSkillIds(List<String> requestedRoutingSkillIds) {
        this.requestedRoutingSkillIds = requestedRoutingSkillIds;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier(s) for skill(s) requested for an interaction")
    @JsonProperty(value="requestedRoutingSkillIds")
    public List<String> getRequestedRoutingSkillIds() {
        return this.requestedRoutingSkillIds;
    }

    public void setRequestedRoutingSkillIds(List<String> requestedRoutingSkillIds) {
        this.requestedRoutingSkillIds = requestedRoutingSkillIds;
    }

    public FlowActivityEntityData requestedRoutings(List<RequestedRoutingsEnum> requestedRoutings) {
        this.requestedRoutings = requestedRoutings;
        return this;
    }

    @ApiModelProperty(example="null", value="Routing type(s) for requested/attempted routing methods.")
    @JsonProperty(value="requestedRoutings")
    public List<RequestedRoutingsEnum> getRequestedRoutings() {
        return this.requestedRoutings;
    }

    public void setRequestedRoutings(List<RequestedRoutingsEnum> requestedRoutings) {
        this.requestedRoutings = requestedRoutings;
    }

    public FlowActivityEntityData routingPriority(Long routingPriority) {
        this.routingPriority = routingPriority;
        return this;
    }

    @ApiModelProperty(example="null", value="Routing priority for the current interaction")
    @JsonProperty(value="routingPriority")
    public Long getRoutingPriority() {
        return this.routingPriority;
    }

    public void setRoutingPriority(Long routingPriority) {
        this.routingPriority = routingPriority;
    }

    public FlowActivityEntityData sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique identifier of this session")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public FlowActivityEntityData teamId(String teamId) {
        this.teamId = teamId;
        return this;
    }

    @ApiModelProperty(example="null", value="The team ID the user is a member of")
    @JsonProperty(value="teamId")
    public String getTeamId() {
        return this.teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public FlowActivityEntityData usedRouting(UsedRoutingEnum usedRouting) {
        this.usedRouting = usedRouting;
        return this;
    }

    @ApiModelProperty(example="null", value="Complete routing method")
    @JsonProperty(value="usedRouting")
    public UsedRoutingEnum getUsedRouting() {
        return this.usedRouting;
    }

    public void setUsedRouting(UsedRoutingEnum usedRouting) {
        this.usedRouting = usedRouting;
    }

    public FlowActivityEntityData userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the user")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public FlowActivityEntityData scoredAgents(List<FlowActivityScoredAgent> scoredAgents) {
        this.scoredAgents = scoredAgents;
        return this;
    }

    @ApiModelProperty(example="null", value="Scored agents")
    @JsonProperty(value="scoredAgents")
    public List<FlowActivityScoredAgent> getScoredAgents() {
        return this.scoredAgents;
    }

    public void setScoredAgents(List<FlowActivityScoredAgent> scoredAgents) {
        this.scoredAgents = scoredAgents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowActivityEntityData flowActivityEntityData = (FlowActivityEntityData)o;
        return Objects.equals(this.activityDate, flowActivityEntityData.activityDate) && Objects.equals((Object)this.metric, (Object)flowActivityEntityData.metric) && Objects.equals((Object)this.activeRouting, (Object)flowActivityEntityData.activeRouting) && Objects.equals(this.addressFrom, flowActivityEntityData.addressFrom) && Objects.equals(this.addressTo, flowActivityEntityData.addressTo) && Objects.equals(this.ani, flowActivityEntityData.ani) && Objects.equals(this.conversationId, flowActivityEntityData.conversationId) && Objects.equals(this.convertedFrom, flowActivityEntityData.convertedFrom) && Objects.equals(this.convertedTo, flowActivityEntityData.convertedTo) && Objects.equals((Object)this.direction, (Object)flowActivityEntityData.direction) && Objects.equals(this.dnis, flowActivityEntityData.dnis) && Objects.equals(this.flowId, flowActivityEntityData.flowId) && Objects.equals((Object)this.flowType, (Object)flowActivityEntityData.flowType) && Objects.equals((Object)this.mediaType, (Object)flowActivityEntityData.mediaType) && Objects.equals(this.participantName, flowActivityEntityData.participantName) && Objects.equals(this.queueId, flowActivityEntityData.queueId) && Objects.equals(this.requestedLanguageId, flowActivityEntityData.requestedLanguageId) && Objects.equals(this.requestedRoutingSkillIds, flowActivityEntityData.requestedRoutingSkillIds) && Objects.equals(this.requestedRoutings, flowActivityEntityData.requestedRoutings) && Objects.equals(this.routingPriority, flowActivityEntityData.routingPriority) && Objects.equals(this.sessionId, flowActivityEntityData.sessionId) && Objects.equals(this.teamId, flowActivityEntityData.teamId) && Objects.equals((Object)this.usedRouting, (Object)flowActivityEntityData.usedRouting) && Objects.equals(this.userId, flowActivityEntityData.userId) && Objects.equals(this.scoredAgents, flowActivityEntityData.scoredAgents);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.activityDate, this.metric, this.activeRouting, this.addressFrom, this.addressTo, this.ani, this.conversationId, this.convertedFrom, this.convertedTo, this.direction, this.dnis, this.flowId, this.flowType, this.mediaType, this.participantName, this.queueId, this.requestedLanguageId, this.requestedRoutingSkillIds, this.requestedRoutings, this.routingPriority, this.sessionId, this.teamId, this.usedRouting, this.userId, this.scoredAgents});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlowActivityEntityData {\n");
        sb.append("    activityDate: ").append(this.toIndentedString(this.activityDate)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString((Object)this.metric)).append("\n");
        sb.append("    activeRouting: ").append(this.toIndentedString((Object)this.activeRouting)).append("\n");
        sb.append("    addressFrom: ").append(this.toIndentedString(this.addressFrom)).append("\n");
        sb.append("    addressTo: ").append(this.toIndentedString(this.addressTo)).append("\n");
        sb.append("    ani: ").append(this.toIndentedString(this.ani)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    convertedFrom: ").append(this.toIndentedString(this.convertedFrom)).append("\n");
        sb.append("    convertedTo: ").append(this.toIndentedString(this.convertedTo)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    dnis: ").append(this.toIndentedString(this.dnis)).append("\n");
        sb.append("    flowId: ").append(this.toIndentedString(this.flowId)).append("\n");
        sb.append("    flowType: ").append(this.toIndentedString((Object)this.flowType)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    participantName: ").append(this.toIndentedString(this.participantName)).append("\n");
        sb.append("    queueId: ").append(this.toIndentedString(this.queueId)).append("\n");
        sb.append("    requestedLanguageId: ").append(this.toIndentedString(this.requestedLanguageId)).append("\n");
        sb.append("    requestedRoutingSkillIds: ").append(this.toIndentedString(this.requestedRoutingSkillIds)).append("\n");
        sb.append("    requestedRoutings: ").append(this.toIndentedString(this.requestedRoutings)).append("\n");
        sb.append("    routingPriority: ").append(this.toIndentedString(this.routingPriority)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    teamId: ").append(this.toIndentedString(this.teamId)).append("\n");
        sb.append("    usedRouting: ").append(this.toIndentedString((Object)this.usedRouting)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    scoredAgents: ").append(this.toIndentedString(this.scoredAgents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MetricEnumDeserializer.class)
    public static enum MetricEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OFLOW("oFlow");

        private String value;

        private MetricEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricEnum value : MetricEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ActiveRoutingEnumDeserializer.class)
    public static enum ActiveRoutingEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BULLSEYE("Bullseye"),
        CONDITIONAL("Conditional"),
        DIRECT("Direct"),
        LAST("Last"),
        MANUAL("Manual"),
        PREDICTIVE("Predictive"),
        PREFERRED("Preferred"),
        STANDARD("Standard"),
        VIP("Vip");

        private String value;

        private ActiveRoutingEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActiveRoutingEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActiveRoutingEnum value : ActiveRoutingEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActiveRoutingEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("inbound"),
        OUTBOUND("outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=FlowTypeEnumDeserializer.class)
    public static enum FlowTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BOT("BOT"),
        COMMONMODULE("COMMONMODULE"),
        DIGITALBOT("DIGITALBOT"),
        INBOUNDCALL("INBOUNDCALL"),
        INBOUNDCHAT("INBOUNDCHAT"),
        INBOUNDEMAIL("INBOUNDEMAIL"),
        INBOUNDSHORTMESSAGE("INBOUNDSHORTMESSAGE"),
        INQUEUECALL("INQUEUECALL"),
        INQUEUEEMAIL("INQUEUEEMAIL"),
        INQUEUESHORTMESSAGE("INQUEUESHORTMESSAGE"),
        OUTBOUNDCALL("OUTBOUNDCALL"),
        SECURECALL("SECURECALL"),
        SPEECH("SPEECH"),
        SURVEYINVITE("SURVEYINVITE"),
        VOICE("VOICE"),
        VOICEMAIL("VOICEMAIL"),
        VOICESURVEY("VOICESURVEY"),
        WORKFLOW("WORKFLOW"),
        WORKITEM("WORKITEM");

        private String value;

        private FlowTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FlowTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FlowTypeEnum value : FlowTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FlowTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CALLBACK("callback"),
        CHAT("chat"),
        COBROWSE("cobrowse"),
        EMAIL("email"),
        MESSAGE("message"),
        INTERNALMESSAGE("internalmessage"),
        SCREENSHARE("screenshare"),
        UNKNOWN("unknown"),
        VIDEO("video"),
        VOICE("voice");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=UsedRoutingEnumDeserializer.class)
    public static enum UsedRoutingEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BULLSEYE("Bullseye"),
        CONDITIONAL("Conditional"),
        DIRECT("Direct"),
        LAST("Last"),
        MANUAL("Manual"),
        PREDICTIVE("Predictive"),
        PREFERRED("Preferred"),
        STANDARD("Standard"),
        VIP("Vip");

        private String value;

        private UsedRoutingEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UsedRoutingEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (UsedRoutingEnum value : UsedRoutingEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return UsedRoutingEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class UsedRoutingEnumDeserializer
    extends StdDeserializer<UsedRoutingEnum> {
        public UsedRoutingEnumDeserializer() {
            super(UsedRoutingEnumDeserializer.class);
        }

        public UsedRoutingEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return UsedRoutingEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=RequestedRoutingsEnumDeserializer.class)
    public static enum RequestedRoutingsEnum {
        BULLSEYE("Bullseye"),
        CONDITIONAL("Conditional"),
        DIRECT("Direct"),
        LAST("Last"),
        MANUAL("Manual"),
        PREDICTIVE("Predictive"),
        PREFERRED("Preferred"),
        STANDARD("Standard"),
        VIP("Vip");

        private String value;

        private RequestedRoutingsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RequestedRoutingsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RequestedRoutingsEnum value : RequestedRoutingsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RequestedRoutingsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class RequestedRoutingsEnumDeserializer
    extends StdDeserializer<RequestedRoutingsEnum> {
        public RequestedRoutingsEnumDeserializer() {
            super(RequestedRoutingsEnumDeserializer.class);
        }

        public RequestedRoutingsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RequestedRoutingsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class FlowTypeEnumDeserializer
    extends StdDeserializer<FlowTypeEnum> {
        public FlowTypeEnumDeserializer() {
            super(FlowTypeEnumDeserializer.class);
        }

        public FlowTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FlowTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ActiveRoutingEnumDeserializer
    extends StdDeserializer<ActiveRoutingEnum> {
        public ActiveRoutingEnumDeserializer() {
            super(ActiveRoutingEnumDeserializer.class);
        }

        public ActiveRoutingEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActiveRoutingEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class MetricEnumDeserializer
    extends StdDeserializer<MetricEnum> {
        public MetricEnumDeserializer() {
            super(MetricEnumDeserializer.class);
        }

        public MetricEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MetricEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

