/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.CommonRulePredicateEntity;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class CommonRulePredicate
implements Serializable {
    private MetricTypeEnum metricType = null;
    private MetricValueTypeEnum metricValueType = null;
    private ComparisonOperatorEnum comparisonOperator = null;
    private Double value = null;
    private String status = null;
    private CommonRulePredicateEntity entity = null;
    private MediaTypeEnum mediaType = null;
    private MetricEnum metric = null;

    public CommonRulePredicate metricType(MetricTypeEnum metricType) {
        this.metricType = metricType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of metric being evaluated.")
    @JsonProperty(value="metricType")
    public MetricTypeEnum getMetricType() {
        return this.metricType;
    }

    public void setMetricType(MetricTypeEnum metricType) {
        this.metricType = metricType;
    }

    public CommonRulePredicate metricValueType(MetricValueTypeEnum metricValueType) {
        this.metricValueType = metricValueType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of metric value being evaluated.")
    @JsonProperty(value="metricValueType")
    public MetricValueTypeEnum getMetricValueType() {
        return this.metricValueType;
    }

    public void setMetricValueType(MetricValueTypeEnum metricValueType) {
        this.metricValueType = metricValueType;
    }

    public CommonRulePredicate comparisonOperator(ComparisonOperatorEnum comparisonOperator) {
        this.comparisonOperator = comparisonOperator;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The comparison operator being performed on the metric.")
    @JsonProperty(value="comparisonOperator")
    public ComparisonOperatorEnum getComparisonOperator() {
        return this.comparisonOperator;
    }

    public void setComparisonOperator(ComparisonOperatorEnum comparisonOperator) {
        this.comparisonOperator = comparisonOperator;
    }

    public CommonRulePredicate value(Double value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The value the metric will be compared to.")
    @JsonProperty(value="value")
    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public CommonRulePredicate status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the entity corresponding to the metric.")
    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public CommonRulePredicate entity(CommonRulePredicateEntity entity) {
        this.entity = entity;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The entity whose metric is being represented.")
    @JsonProperty(value="entity")
    public CommonRulePredicateEntity getEntity() {
        return this.entity;
    }

    public void setEntity(CommonRulePredicateEntity entity) {
        this.entity = entity;
    }

    public CommonRulePredicate mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="The media type of the conversation the metric describes.")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public CommonRulePredicate metric(MetricEnum metric) {
        this.metric = metric;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The metric being evaluated.")
    @JsonProperty(value="metric")
    public MetricEnum getMetric() {
        return this.metric;
    }

    public void setMetric(MetricEnum metric) {
        this.metric = metric;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommonRulePredicate commonRulePredicate = (CommonRulePredicate)o;
        return Objects.equals((Object)this.metricType, (Object)commonRulePredicate.metricType) && Objects.equals((Object)this.metricValueType, (Object)commonRulePredicate.metricValueType) && Objects.equals((Object)this.comparisonOperator, (Object)commonRulePredicate.comparisonOperator) && Objects.equals(this.value, commonRulePredicate.value) && Objects.equals(this.status, commonRulePredicate.status) && Objects.equals(this.entity, commonRulePredicate.entity) && Objects.equals((Object)this.mediaType, (Object)commonRulePredicate.mediaType) && Objects.equals((Object)this.metric, (Object)commonRulePredicate.metric);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metricType, this.metricValueType, this.comparisonOperator, this.value, this.status, this.entity, this.mediaType, this.metric});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CommonRulePredicate {\n");
        sb.append("    metricType: ").append(this.toIndentedString((Object)this.metricType)).append("\n");
        sb.append("    metricValueType: ").append(this.toIndentedString((Object)this.metricValueType)).append("\n");
        sb.append("    comparisonOperator: ").append(this.toIndentedString((Object)this.comparisonOperator)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString((Object)this.metric)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MetricTypeEnumDeserializer.class)
    public static enum MetricTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INTERVAL("Interval"),
        INSTANCE("Instance");

        private String value;

        private MetricTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricTypeEnum value : MetricTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=MetricValueTypeEnumDeserializer.class)
    public static enum MetricValueTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        COUNT("Count"),
        MIN("Min"),
        TIMER("Timer"),
        MAX("Max"),
        PERCENTAGE("Percentage"),
        AVERAGE("Average"),
        OBSERVATION("Observation");

        private String value;

        private MetricValueTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricValueTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricValueTypeEnum value : MetricValueTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricValueTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ComparisonOperatorEnumDeserializer.class)
    public static enum ComparisonOperatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GT("Gt"),
        GTE("Gte"),
        LT("Lt"),
        LTE("Lte"),
        EQ("Eq"),
        NE("Ne");

        private String value;

        private ComparisonOperatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ComparisonOperatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ComparisonOperatorEnum value : ComparisonOperatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ComparisonOperatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        VOICE("Voice"),
        CHAT("Chat"),
        EMAIL("Email"),
        CALLBACK("Callback"),
        MESSAGE("Message");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=MetricEnumDeserializer.class)
    public static enum MetricEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NABANDON("nAbandon"),
        NCONNECTED("nConnected"),
        NINTERACTIONS("nInteractions"),
        NOFFERED("nOffered"),
        NOUTBOUND("nOutbound"),
        NTRANSFERRED("nTransferred"),
        SERVICELEVEL("serviceLevel"),
        OSERVICELEVEL("oServiceLevel"),
        OWAITING("oWaiting"),
        TABANDON("tAbandon"),
        TACW("tAcw"),
        TALERT("tAlert"),
        TANSWERED("tAnswered"),
        THANDLE("tHandle"),
        THELDCOMPLETE("tHeldComplete"),
        TTALKCOMPLETE("tTalkComplete"),
        TWAIT("tWait"),
        TTALK("tTalk"),
        THELD("tHeld"),
        TORGANIZATIONPRESENCE("tOrganizationPresence"),
        TSYSTEMPRESENCE("tSystemPresence"),
        TAGENTROUTINGSTATUS("tAgentRoutingStatus"),
        OUSERROUTINGSTATUSES("oUserRoutingStatuses"),
        OUSERPRESENCES("oUserPresences"),
        OINTERACTING("oInteracting"),
        TFLOWOUT("tFlowOut"),
        TADHERENCESTATUS("tAdherenceStatus");

        private String value;

        private MetricEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricEnum value : MetricEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MetricEnumDeserializer
    extends StdDeserializer<MetricEnum> {
        public MetricEnumDeserializer() {
            super(MetricEnumDeserializer.class);
        }

        public MetricEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MetricEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ComparisonOperatorEnumDeserializer
    extends StdDeserializer<ComparisonOperatorEnum> {
        public ComparisonOperatorEnumDeserializer() {
            super(ComparisonOperatorEnumDeserializer.class);
        }

        public ComparisonOperatorEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ComparisonOperatorEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class MetricValueTypeEnumDeserializer
    extends StdDeserializer<MetricValueTypeEnum> {
        public MetricValueTypeEnumDeserializer() {
            super(MetricValueTypeEnumDeserializer.class);
        }

        public MetricValueTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MetricValueTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class MetricTypeEnumDeserializer
    extends StdDeserializer<MetricTypeEnum> {
        public MetricTypeEnumDeserializer() {
            super(MetricTypeEnumDeserializer.class);
        }

        public MetricTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MetricTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

